/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.text.EditDistance;
import java.util.TreeSet;
import one.util.streamex.StreamEx;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptor;
import org.angular2.codeInsight.attributes.Angular2I18nAttributesProvider;
import org.angular2.inspections.AngularHtmlLikeTemplateLocalInspectionTool;
import org.angular2.inspections.quickfixes.CreateAttributeQuickFix;
import org.angular2.inspections.quickfixes.RenameAttributeQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.jetbrains.annotations.NotNull;

public class AngularInvalidI18nAttributeInspection
extends AngularHtmlLikeTemplateLocalInspectionTool {
    @Override
    protected void visitAngularAttribute(@NotNull ProblemsHolder holder, @NotNull XmlAttribute attribute, @NotNull Angular2AttributeDescriptor descriptor) {
        if (holder == null) {
            AngularInvalidI18nAttributeInspection.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            AngularInvalidI18nAttributeInspection.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            AngularInvalidI18nAttributeInspection.$$$reportNull$$$0(2);
        }
        Angular2AttributeNameParser.AttributeInfo info = descriptor.getInfo();
        XmlTag parent = attribute.getParent();
        if (info.type == Angular2AttributeType.I18N && parent != null) {
            LocalQuickFix[] quickFixes;
            TextRange range = attribute.getNameElement().getTextRangeInParent();
            String i18nedAttrName = info.name;
            TreeSet<String> candidates = new TreeSet<String>();
            for (XmlAttribute attr : parent.getAttributes()) {
                Angular2AttributeNameParser.AttributeInfo attrInfo = Angular2AttributeNameParser.parse(attr.getName(), parent);
                if (!Angular2I18nAttributesProvider.isI18nCandidate(attrInfo)) continue;
                candidates.add(Angular2AttributeType.I18N.buildName(attr.getName()));
            }
            for (XmlAttribute attr : parent.getAttributes()) {
                candidates.remove(attr.getName());
            }
            if (i18nedAttrName.isEmpty()) {
                quickFixes = (LocalQuickFix[])((StreamEx)StreamEx.of(candidates).limit(3L)).map(name -> new RenameAttributeQuickFix((String)name)).toArray(LocalQuickFix[]::new);
                holder.registerProblem((PsiElement)attribute, range, Angular2Bundle.message("angular.inspection.i18n.message.empty", new Object[0]), quickFixes);
            } else if (descriptor.getDeclarations().isEmpty()) {
                quickFixes = (LocalQuickFix[])((StreamEx)((StreamEx)StreamEx.of(candidates).sorted((str1, str2) -> -EditDistance.levenshtein((CharSequence)str1, (CharSequence)str2, (boolean)false))).limit(2L)).map(name -> new RenameAttributeQuickFix((String)name)).append((Object)new CreateAttributeQuickFix(i18nedAttrName)).toArray(LocalQuickFix[]::new);
                holder.registerProblem((PsiElement)attribute, new TextRange(range.getStartOffset() + 5, range.getEndOffset()), Angular2Bundle.message("angular.inspection.i18n.message.not-matching", i18nedAttrName), quickFixes);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "attribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/angular2/inspections/AngularInvalidI18nAttributeInspection";
        objectArray[2] = "visitAngularAttribute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

