/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.testIntegration.TestFinderHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.source.Angular2SourceModule;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

public class AngularMissingOrInvalidDeclarationInModuleInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularMissingOrInvalidDeclarationInModuleInspection.$$$reportNull$$$0(0);
        }
        return new JSElementVisitor(){

            public void visitES6Decorator(ES6Decorator decorator) {
                Angular2Declaration declaration;
                if (Angular2DecoratorUtil.isAngularEntityDecorator(decorator, "Component", "Directive", "Pipe") && !TestFinderHelper.isTest((PsiElement)decorator) && (declaration = (Angular2Declaration)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity((PsiElement)decorator), Angular2Declaration.class)) != null) {
                    Collection<Angular2Module> modules = declaration.getAllModules();
                    PsiElement classIdentifier = (PsiElement)ObjectUtils.notNull((Object)ObjectUtils.doIfNotNull((Object)Angular2DecoratorUtil.getClassForDecoratorElement((PsiElement)decorator), PsiNameIdentifierOwner::getNameIdentifier), (Object)decorator);
                    if (modules.isEmpty()) {
                        holder.registerProblem(classIdentifier, Angular2Bundle.message("angular.inspection.invalid-declaration-in-module.message.not-declared", Angular2EntityUtils.getEntityClassName(decorator)), AngularMissingOrInvalidDeclarationInModuleInspection.allSourceDeclarationsResolved(decorator.getProject()) ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                    } else if (modules.size() > 1) {
                        holder.registerProblem(classIdentifier, Angular2Bundle.message("angular.inspection.invalid-declaration-in-module.message.declared-in-many", Angular2EntityUtils.getEntityClassName(decorator), Angular2EntityUtils.renderEntityList(modules)), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static boolean allSourceDeclarationsResolved(@NotNull Project project) {
        if (project == null) {
            AngularMissingOrInvalidDeclarationInModuleInspection.$$$reportNull$$$0(1);
        }
        return !ContainerUtil.exists(Angular2EntitiesProvider.getAllModules(project), module -> module instanceof Angular2SourceModule && !module.areDeclarationsFullyResolved());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/angular2/inspections/AngularMissingOrInvalidDeclarationInModuleInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "allSourceDeclarationsResolved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

