/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import a.d.la;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CoverageEnabledConfiguration
implements JDOMExternalizable {
    private static final Logger b;
    public static final Key<CoverageEnabledConfiguration> COVERAGE_KEY;
    @NonNls
    protected static final String COVERAGE_ENABLED_ATTRIBUTE_NAME = "enabled";
    @NonNls
    protected static final String COVERAGE_RUNNER = "runner";
    @NonNls
    protected static final String TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME = "per_test_coverage_enabled";
    @NonNls
    protected static final String SAMPLING_COVERAGE_ATTRIBUTE_NAME = "sample_coverage";
    @NonNls
    protected static final String TRACK_TEST_FOLDERS = "track_test_folders";
    private final Project j;
    private final RunConfigurationBase e;
    private boolean i = false;
    private String c;
    private CoverageRunner h;
    private boolean f = true;
    private boolean d = true;
    private boolean a = false;
    @NonNls
    protected String myCoverageFilePath;
    private CoverageSuite g;
    private static final long k;

    public CoverageEnabledConfiguration(RunConfigurationBase configuration) {
        this.e = configuration;
        this.j = configuration.getProject();
    }

    public RunConfigurationBase getConfiguration() {
        return this.e;
    }

    public boolean isCoverageEnabled() {
        return this.i;
    }

    public void setCoverageEnabled(boolean isCoverageEnabled) {
        this.i = isCoverageEnabled;
    }

    public boolean isSampling() {
        return this.d;
    }

    public void setSampling(boolean sampling) {
        this.d = sampling;
    }

    public String getRunnerId() {
        return this.c;
    }

    @Nullable
    public CoverageRunner getCoverageRunner() {
        return this.h;
    }

    public void setCoverageRunner(@Nullable CoverageRunner coverageRunner) {
        this.h = coverageRunner;
        this.c = coverageRunner != null ? coverageRunner.getId() : null;
        this.myCoverageFilePath = null;
    }

    public void coverageRunnerExtensionRemoved(@NotNull CoverageRunner runner) {
        if (runner == null) {
            CoverageEnabledConfiguration.a(0);
        }
        if (runner.getId().equals(this.c)) {
            this.h = null;
            this.myCoverageFilePath = null;
        }
    }

    public boolean isTrackPerTestCoverage() {
        return this.f;
    }

    public void setTrackPerTestCoverage(boolean collectLineInfo) {
        this.f = collectLineInfo;
    }

    public boolean isTrackTestFolders() {
        return this.a;
    }

    public void setTrackTestFolders(boolean trackTestFolders) {
        this.a = trackTestFolders;
    }

    public CoverageSuite getCurrentCoverageSuite() {
        return this.g;
    }

    public void setCurrentCoverageSuite(CoverageSuite currentCoverageSuite) {
        this.g = currentCoverageSuite;
    }

    public String getName() {
        return this.e.getName();
    }

    public boolean canHavePerTestCoverage() {
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(this.e)) continue;
            return coverageEngine.canHavePerTestCoverage(this.e);
        }
        return false;
    }

    public static boolean isApplicableTo(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(1);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) != null) {
            return true;
        }
        for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
            if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static CoverageEnabledConfiguration getOrCreate(@NotNull RunConfigurationBase runConfiguration) {
        CoverageEnabledConfiguration coverageEnabledConfiguration;
        long l2 = k ^ 0x6C2DFF928F04L;
        if (runConfiguration == null) {
            CoverageEnabledConfiguration.a(2);
        }
        if ((coverageEnabledConfiguration = (CoverageEnabledConfiguration)runConfiguration.getCopyableUserData(COVERAGE_KEY)) == null) {
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageEngine.isApplicableTo(runConfiguration)) continue;
                coverageEnabledConfiguration = coverageEngine.createCoverageEnabledConfiguration(runConfiguration);
                break;
            }
            b.assertTrue(coverageEnabledConfiguration != null, (Object)("Coverage enabled run configuration wasn't found for run configuration: " + runConfiguration.getName() + ", type = " + runConfiguration.getClass().getName()));
            runConfiguration.putCopyableUserData(COVERAGE_KEY, (Object)coverageEnabledConfiguration);
        }
        CoverageEnabledConfiguration coverageEnabledConfiguration2 = coverageEnabledConfiguration;
        if (coverageEnabledConfiguration2 == null) {
            CoverageEnabledConfiguration.a(3);
        }
        return coverageEnabledConfiguration2;
    }

    @Nullable
    @NonNls
    public String getCoverageFilePath() {
        if (this.myCoverageFilePath == null) {
            this.myCoverageFilePath = this.createCoverageFile();
        }
        return this.myCoverageFilePath;
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = k ^ 0x19F46CC762A9L;
        this.i = Boolean.parseBoolean(element.getAttributeValue(COVERAGE_ENABLED_ATTRIBUTE_NAME));
        String string = element.getAttributeValue(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME);
        this.f = string == null || Boolean.valueOf(string) != false;
        this.d = Boolean.parseBoolean(element.getAttributeValue(SAMPLING_COVERAGE_ATTRIBUTE_NAME, "true"));
        String string2 = element.getAttributeValue(TRACK_TEST_FOLDERS);
        this.a = string2 != null && Boolean.valueOf(string2) != false;
        String string3 = element.getAttributeValue(COVERAGE_RUNNER);
        if (string3 != null) {
            this.c = string3;
            this.h = null;
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)this.c)) continue;
                this.h = coverageRunner;
                break;
            }
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = k ^ 0x301C8EE0977EL;
        if (this.i) {
            element.setAttribute(COVERAGE_ENABLED_ATTRIBUTE_NAME, String.valueOf(true));
        }
        if (!this.f) {
            element.setAttribute(TRACK_PER_TEST_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (!this.d) {
            element.setAttribute(SAMPLING_COVERAGE_ATTRIBUTE_NAME, String.valueOf(false));
        }
        if (this.a) {
            element.setAttribute(TRACK_TEST_FOLDERS, String.valueOf(true));
        }
        if (this.h != null) {
            element.setAttribute(COVERAGE_RUNNER, this.h.getId());
        } else if (this.c != null) {
            element.setAttribute(COVERAGE_RUNNER, this.c);
        }
    }

    @Nullable
    @NonNls
    protected String createCoverageFile() {
        long l2 = k ^ 0x4C07E5CFF1F3L;
        if (this.h == null) {
            return null;
        }
        String string = PathManager.getSystemPath() + File.separator + "coverage";
        String string2 = string + File.separator + FileUtil.sanitizeFileName((String)this.j.getName()) + this.coverageFileNameSeparator() + FileUtil.sanitizeFileName((String)this.e.getName()) + "." + this.h.getDataFileExtension();
        new File(string).mkdirs();
        return string2;
    }

    protected String coverageFileNameSeparator() {
        return "$";
    }

    static {
        k = la.a(-4932746699578295193L, -608115743654501600L, MethodHandles.lookup().lookupClass()).a(276837109004440L);
        long l2 = k ^ 0x10B86920A20EL;
        b = Logger.getInstance((String)CoverageEnabledConfiguration.class.getName());
        COVERAGE_KEY = Key.create((String)"com.intellij.coverage");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x658804DA064BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = COVERAGE_RUNNER;
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/coverage/CoverageEnabledConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "coverageRunnerExtensionRemoved";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

