/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class DomApplicationComponent {
    private final MultiMap<String, DomFileMetaData> a = MultiMap.createSet();
    private final Set<DomFileMetaData> c = new THashSet();
    private final ImplementationClassCache f = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager b = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class<?>, DomElementsAnnotator> d = ConcurrentFactoryMap.createMap(clazz -> {
        DomFileDescription<?> domFileDescription = this.a((Class<?>)clazz);
        return domFileDescription == null ? null : domFileDescription.createAnnotator();
    });
    private final Map<Class<?>, InvocationCache> e = ConcurrentFactoryMap.create(InvocationCache::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> g = ConcurrentFactoryMap.createMap(VisitorDescription::new);

    public DomApplicationComponent() {
        this.b();
        DomApplicationComponent.a(DomFileDescription.EP_NAME, this::a);
        DomApplicationComponent.a(DomFileMetaData.EP_NAME, this::a);
    }

    private static <T> void a(ExtensionPointName<T> extensionPointName, ExtensionPointChangeListener extensionPointChangeListener) {
        Application application = ApplicationManager.getApplication();
        if (Disposer.isDisposing((Disposable)application)) {
            return;
        }
        extensionPointName.addExtensionPointListener(extensionPointChangeListener, (Disposable)application);
    }

    private void b() {
        for (Object object : DomFileDescription.EP_NAME.getExtensionList()) {
            this.registerFileDescription((DomFileDescription<?>)object);
        }
        for (Object object : DomFileMetaData.EP_NAME.getExtensionList()) {
            this.registerFileDescription((DomFileMetaData)((Object)object));
        }
    }

    private synchronized void a() {
        this.a.clear();
        this.c.clear();
        this.d.clear();
        this.f.clearCache();
        this.b.clearCache();
        this.b();
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public synchronized int getCumulativeVersion(boolean forStubs) {
        int n2 = 0;
        for (DomFileMetaData domFileMetaData : this.c()) {
            if (forStubs) {
                if (domFileMetaData.stubVersion == null) continue;
                n2 += domFileMetaData.stubVersion.intValue();
                n2 += StringUtil.notNullize((String)domFileMetaData.rootTagName).hashCode();
                continue;
            }
            n2 += domFileMetaData.domVersion;
            n2 += StringUtil.notNullize((String)domFileMetaData.rootTagName).hashCode();
        }
        return n2;
    }

    private Iterable<DomFileMetaData> c() {
        return ContainerUtil.concat((Iterable)this.a.values(), this.c);
    }

    @Nullable
    public synchronized DomFileMetaData findMeta(DomFileDescription<?> description) {
        return (DomFileMetaData)((Object)ContainerUtil.find(this.c(), domFileMetaData -> domFileMetaData.lazyInstance == description));
    }

    public synchronized Set<DomFileDescription<?>> getFileDescriptions(String rootTagName) {
        return ContainerUtil.map2Set((Collection)this.a.get((Object)rootTagName), DomFileMetaData::getDescription);
    }

    public synchronized Set<DomFileDescription<?>> getAcceptingOtherRootTagNameDescriptions() {
        return ContainerUtil.map2Set(this.c, DomFileMetaData::getDescription);
    }

    synchronized void registerFileDescription(DomFileDescription<?> description) {
        this.registerFileDescription(new DomFileMetaData(description));
        this.initDescription(description);
    }

    void registerFileDescription(DomFileMetaData meta) {
        if (StringUtil.isEmpty((String)meta.rootTagName)) {
            this.c.add(meta);
        } else {
            this.a.putValue((Object)meta.rootTagName, (Object)meta);
        }
    }

    void initDescription(DomFileDescription<?> description) {
        Map map2 = description.getImplementations();
        for (Map.Entry entry : map2.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.b.copyFrom(description.getTypeChooserManager());
    }

    synchronized void removeDescription(DomFileDescription<?> description) {
        DomFileMetaData domFileMetaData = this.findMeta(description);
        this.a.get((Object)description.getRootTagName()).remove((Object)domFileMetaData);
        this.c.remove((Object)domFileMetaData);
    }

    @Nullable
    private synchronized DomFileDescription<?> a(Class<?> clazz) {
        for (DomFileMetaData domFileMetaData : this.c()) {
            DomFileDescription<?> domFileDescription = domFileMetaData.lazyInstance;
            if (domFileDescription == null || domFileDescription.getRootElementClass() != clazz) continue;
            return domFileDescription;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class<?> rootElementClass) {
        return this.d.get(rootElementClass);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class<?> concreteInterface) {
        return this.f.get(concreteInterface);
    }

    public final void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.f.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    TypeChooserManager getTypeChooserManager() {
        return this.b;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.getInvocationCache(ReflectionUtil.getRawType((Type)type)).genericInfo;
    }

    final InvocationCache getInvocationCache(Class<?> type) {
        return this.e.get(type);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return this.g.get(aClass);
    }
}

