/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.network.service;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reporting.ReporterKt;
import com.intellij.stats.network.service.RequestService;
import com.intellij.stats.network.service.ResponseData;
import com.intellij.stats.network.service.SimpleRequestService;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u001d\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\u00020\r*\u00020\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/stats/network/service/SimpleRequestService;", "Lcom/intellij/stats/network/service/RequestService;", "()V", "get", "Lcom/intellij/stats/network/service/ResponseData;", "url", "", "postZipped", "file", "Ljava/io/File;", "asResponseData", "Ljava/net/URLConnection;", "sentDataSize", "", "(Ljava/net/URLConnection;Ljava/lang/Integer;)Lcom/intellij/stats/network/service/ResponseData;", "getResponseCode", "Lcom/intellij/util/io/HttpRequests$Request;", "Companion", "intellij.statsCollector"})
public final class SimpleRequestService
extends RequestService {
    @NotNull
    private static final Logger LOG;
    @Deprecated
    public static final Companion Companion;

    @Override
    @Nullable
    public ResponseData postZipped(@NotNull String url, @NotNull File file) {
        ResponseData responseData;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            byte[] zippedArray = ReporterKt.compressBase64Gzip((byte[])FilesKt.readBytes((File)file));
            return (ResponseData)HttpRequests.post((String)url, null).tuner((HttpRequests.ConnectionTuner)postZipped.1.INSTANCE).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<ResponseData>(this, zippedArray){
                final /* synthetic */ SimpleRequestService this$0;
                final /* synthetic */ byte[] $zippedArray;

                @Nullable
                public final ResponseData process(@NotNull HttpRequests.Request request) {
                    Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                    request.write(this.$zippedArray);
                    URLConnection uRLConnection = request.getConnection();
                    Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"request.connection");
                    return SimpleRequestService.access$asResponseData(this.this$0, uRLConnection, this.$zippedArray.length);
                }
                {
                    this.this$0 = simpleRequestService;
                    this.$zippedArray = byArray;
                }
            });
        }
        catch (HttpRequests.HttpStatusException e) {
            int n = e.getStatusCode();
            String string = StringUtil.notNullize((String)e.getMessage());
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.notNullize(e.message)");
            responseData = new ResponseData(n, string, null, 4, null);
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            responseData = null;
        }
        return responseData;
    }

    @Override
    @Nullable
    public ResponseData get(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        try {
            RequestBuilder requestBuilder = HttpRequests.request((String)url);
            Intrinsics.checkExpressionValueIsNotNull((Object)requestBuilder, (String)"HttpRequests.request(url)");
            RequestBuilder requestBuilder2 = requestBuilder;
            return (ResponseData)requestBuilder2.connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<ResponseData>(this){
                final /* synthetic */ SimpleRequestService this$0;

                @NotNull
                public final ResponseData process(@NotNull HttpRequests.Request request) {
                    Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                    int responseCode = SimpleRequestService.access$getResponseCode(this.this$0, request);
                    String string = request.readString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.readString()");
                    String responseText = string;
                    return new ResponseData(responseCode, responseText, null, 4, null);
                }
                {
                    this.this$0 = simpleRequestService;
                }
            });
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            Object var2_3 = null;
            return var2_3;
        }
    }

    private final ResponseData asResponseData(@NotNull URLConnection $this$asResponseData, Integer sentDataSize) {
        if ($this$asResponseData instanceof HttpURLConnection) {
            int n = ((HttpURLConnection)$this$asResponseData).getResponseCode();
            String string = StringUtil.notNullize((String)((HttpURLConnection)$this$asResponseData).getResponseMessage(), (String)"");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.notNullize(this.responseMessage, \"\")");
            return new ResponseData(n, string, sentDataSize);
        }
        LOG.error("Could not get code and message from http response");
        return null;
    }

    private final int getResponseCode(@NotNull HttpRequests.Request $this$getResponseCode) {
        URLConnection uRLConnection = $this$getResponseCode.getConnection();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"this.connection");
        URLConnection connection = uRLConnection;
        if (connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)connection).getResponseCode();
        }
        LOG.error("Could not get code from http response");
        return -1;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SimpleRequestService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ ResponseData access$asResponseData(SimpleRequestService $this, URLConnection $this$access_u24asResponseData, Integer sentDataSize) {
        return $this.asResponseData($this$access_u24asResponseData, sentDataSize);
    }

    public static final /* synthetic */ int access$getResponseCode(SimpleRequestService $this, HttpRequests.Request $this$access_u24getResponseCode) {
        return $this.getResponseCode($this$access_u24getResponseCode);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/stats/network/service/SimpleRequestService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.statsCollector"})
    private static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

