/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.exceptions;

import com.intellij.database.remote.jdba.exceptions.StrippedSQLException;
import com.intellij.database.remote.jdba.exceptions.StrippedUnknownException;
import java.sql.SQLException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DBException
extends RuntimeException {
    public final int vendorErrorCode;
    public final String statementText;

    protected DBException(@NotNull SQLException sqlException, @Nullable String statementText) {
        if (sqlException == null) {
            DBException.$$$reportNull$$$0(0);
        }
        this(sqlException.getMessage(), (Throwable)sqlException, sqlException.getErrorCode(), statementText);
    }

    protected DBException(@NotNull String message, @NotNull SQLException sqlException, @Nullable String statementText) {
        if (message == null) {
            DBException.$$$reportNull$$$0(1);
        }
        if (sqlException == null) {
            DBException.$$$reportNull$$$0(2);
        }
        this(message, (Throwable)sqlException, sqlException.getErrorCode(), statementText);
    }

    protected DBException(@NotNull String message, @NotNull Exception exception, String statementText) {
        if (message == null) {
            DBException.$$$reportNull$$$0(3);
        }
        if (exception == null) {
            DBException.$$$reportNull$$$0(4);
        }
        this(message, (Throwable)exception, 0, statementText);
    }

    protected DBException(@NotNull String message, @Nullable String statementText) {
        if (message == null) {
            DBException.$$$reportNull$$$0(5);
        }
        this(message, null, 0, statementText);
    }

    public DBException(@NotNull String message, @Nullable Throwable cause, @Nullable String statementText) {
        if (message == null) {
            DBException.$$$reportNull$$$0(6);
        }
        this(message, cause, 0, statementText);
    }

    private DBException(@NotNull String message, @Nullable Throwable cause, int vendorErrorCode, @Nullable String statementText) {
        if (message == null) {
            DBException.$$$reportNull$$$0(7);
        }
        super(DBException.makeErrorText(message, cause), DBException.stripException(cause));
        this.vendorErrorCode = vendorErrorCode;
        this.statementText = statementText;
    }

    @NotNull
    private static String makeErrorText(@NotNull String message, @Nullable Throwable cause) {
        if (message == null) {
            DBException.$$$reportNull$$$0(8);
        }
        String causeMessage = cause != null ? cause.getMessage() : null;
        String string = causeMessage != null && !message.endsWith(".") && !message.contains(causeMessage) ? message + " (" + causeMessage + ")" : message;
        if (string == null) {
            DBException.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Contract(value="null->null; !null->!null")
    private static Throwable stripException(Throwable e) {
        boolean causeOk;
        if (e == null) {
            return null;
        }
        String className = e.getClass().getName();
        boolean classOk = e instanceof DBException || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.jdbc.odbc.");
        Throwable originalCause = e.getCause();
        Throwable strippedCause = DBException.stripException(originalCause);
        boolean bl = causeOk = originalCause == strippedCause;
        if (classOk && causeOk) {
            return e;
        }
        Exception strippedException = e instanceof SQLException ? new StrippedSQLException((SQLException)e, strippedCause) : new StrippedUnknownException(e, strippedCause);
        return strippedException;
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        StringBuilder b = new StringBuilder(message);
        if (this.statementText != null) {
            b.append("\nThe SQL statement:\n").append(this.statementText).append('\n');
        }
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlException";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/exceptions/DBException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/exceptions/DBException";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeErrorText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeErrorText";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

