/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.dialects;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.util.Version;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class CHouseIntermediateFacade
extends JdbcIntermediateFacade {
    private static final Pattern CHOUSE_VERSION_PATTERN = Pattern.compile("(\\d{1,2}(\\.\\d{1,10}){1,5})");
    private static final String CONNECTION_INFO_QUERY = "select currentDatabase(), version()";

    public CHouseIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, int connectionsLimit, boolean ownConnections, @NotNull DBExceptionRecognizer exceptionRecognizer) {
        if (dataSource == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            CHouseIntermediateFacade.$$$reportNull$$$0(1);
        }
        super(dataSource, connectionsLimit, ownConnections, exceptionRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        String driverVersionStr;
        String rdbmsName;
        String[] env;
        JdbcIntermediateSession session = this.openSession();
        try {
            env = session.queryOneRow(CONNECTION_INFO_QUERY, 2, String.class);
            try {
                DatabaseMetaData md = session.getConnection().getMetaData();
                rdbmsName = md.getDatabaseProductName();
                if (rdbmsName == null) {
                    rdbmsName = session.getConnection().getClass().getName();
                }
                driverVersionStr = md.getDriverVersion();
            }
            catch (SQLException sqle) {
                throw this.getExceptionRecognizer().recognizeException(sqle, "getting versions using JDBC metadata");
            }
        }
        finally {
            session.close();
        }
        Version driverVersion = CHouseIntermediateFacade.extractVersion(driverVersionStr, CHOUSE_VERSION_PATTERN, 1);
        if (env != null) {
            assert (env.length == 2);
            String serverVersionStr = env[1];
            Version serverVersion = CHouseIntermediateFacade.extractVersion(serverVersionStr, CHOUSE_VERSION_PATTERN, 1);
            return new ConnectionInfo(rdbmsName, null, env[0], null, serverVersion, driverVersion);
        }
        return new ConnectionInfo(rdbmsName, null, null, null, Version.ZERO, driverVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "exceptionRecognizer";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/remote/jdba/jdbc/dialects/CHouseIntermediateFacade";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

