/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc.pooling;

import com.intellij.database.remote.jdba.core.ImplementationAccessibleService;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.pooling.ConnectionPoolExhaustedException;
import com.intellij.database.remote.jdba.jdbc.pooling.ConnectionPoolIsNotReadyException;
import com.intellij.database.remote.jdba.jdbc.pooling.ConnectionPoolOperationInterruptedException;
import com.intellij.database.remote.jdba.jdbc.pooling.UnexpectedDataSourceException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionPool
implements ImplementationAccessibleService {
    @NotNull
    private final JdbcConnectionProvider myOriginalDataSource;
    private final boolean myOwnConnections;
    private final CopyOnWriteArrayList<Connection> myAllConnections;
    private final LinkedBlockingDeque<Connection> myFreeConnections;
    private volatile int myHoldConnections;
    private volatile int myConnectionsLimit;
    private int myBorrowTimeBeforeReplenish;
    private int myBorrowTimeOut;
    private volatile boolean myReady;

    public ConnectionPool(@NotNull JdbcConnectionProvider originalDataSource, boolean ownConnections) {
        if (originalDataSource == null) {
            ConnectionPool.$$$reportNull$$$0(0);
        }
        this.myAllConnections = new CopyOnWriteArrayList();
        this.myFreeConnections = new LinkedBlockingDeque();
        this.myHoldConnections = 1;
        this.myConnectionsLimit = 10;
        this.myBorrowTimeBeforeReplenish = 70;
        this.myBorrowTimeOut = 60000;
        this.myOriginalDataSource = originalDataSource;
        this.myOwnConnections = ownConnections;
    }

    @NotNull
    public Object getOriginalDataSource() {
        JdbcConnectionProvider jdbcConnectionProvider = this.myOriginalDataSource;
        if (jdbcConnectionProvider == null) {
            ConnectionPool.$$$reportNull$$$0(1);
        }
        return jdbcConnectionProvider;
    }

    public void connect() throws SQLException {
        int n = this.myHoldConnections - this.myAllConnections.size();
        if (this.myAllConnections.isEmpty()) {
            n = Math.max(n, 1);
        }
        for (int i = 0; i < n; ++i) {
            this.obtainOneConnectionIntoPool();
        }
        this.myReady = !this.myAllConnections.isEmpty();
    }

    private synchronized void obtainOneConnectionIntoPool() throws SQLException {
        if (this.myAllConnections.size() >= this.myConnectionsLimit) {
            return;
        }
        Connection connection = this.myOriginalDataSource.getConnection();
        if (connection == null) {
            throw new UnexpectedDataSourceException("DataSource " + this.myOriginalDataSource.getClass().getName() + " returned null.", "<DataSource.getConnection()>");
        }
        try {
            this.prepareConnectionAfterConnected(connection);
        }
        catch (SQLException sqle) {
            this.closeConnection(connection);
            throw sqle;
        }
        this.myAllConnections.add(connection);
        if (this.myReady) {
            ConnectionPool.sleep(11);
        }
        this.myFreeConnections.offer(connection);
    }

    protected void prepareConnectionAfterConnected(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            ConnectionPool.$$$reportNull$$$0(2);
        }
        connection.setAutoCommit(true);
    }

    public boolean isReady() {
        return this.myReady;
    }

    @NotNull
    public Connection borrow() throws SQLException {
        if (!this.myReady) {
            throw new ConnectionPoolIsNotReadyException("The connection pool is not connected yet or may be is disconnecting.");
        }
        Connection connection = this.provideWithConnection();
        this.activateConnection(connection);
        Connection connection2 = connection;
        if (connection2 == null) {
            ConnectionPool.$$$reportNull$$$0(3);
        }
        return connection2;
    }

    @NotNull
    private Connection provideWithConnection() throws SQLException {
        block10: {
            Connection connection;
            Connection connection2;
            block9: {
                connection2 = this.myFreeConnections.poll(this.myBorrowTimeBeforeReplenish, TimeUnit.MILLISECONDS);
                if (connection2 == null) break block9;
                Connection connection3 = connection2;
                if (connection3 == null) {
                    ConnectionPool.$$$reportNull$$$0(4);
                }
                return connection3;
            }
            try {
                while (this.myAllConnections.size() < this.myConnectionsLimit) {
                    this.obtainOneConnectionIntoPool();
                    connection2 = this.myFreeConnections.poll(this.myBorrowTimeBeforeReplenish, TimeUnit.MILLISECONDS);
                    if (connection2 == null) continue;
                    connection = connection2;
                }
            }
            catch (InterruptedException ie) {
                throw new ConnectionPoolOperationInterruptedException("Operation interrupted", (Throwable)ie, "<provide with connection>");
            }
            {
                if (connection == null) {
                    ConnectionPool.$$$reportNull$$$0(5);
                }
                return connection;
            }
            connection2 = this.myFreeConnections.poll(this.myBorrowTimeOut, TimeUnit.MILLISECONDS);
            if (connection2 == null) break block10;
            Connection connection4 = connection2;
            if (connection4 == null) {
                ConnectionPool.$$$reportNull$$$0(6);
            }
            return connection4;
        }
        int n = this.myAllConnections.size();
        throw new ConnectionPoolExhaustedException("The Connection Pool exhausted: all " + n + " connections are borrowed and not returned yet.");
    }

    protected void activateConnection(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            ConnectionPool.$$$reportNull$$$0(7);
        }
    }

    public void release(@NotNull Connection connection) {
        if (connection == null) {
            ConnectionPool.$$$reportNull$$$0(8);
        }
        try {
            this.passivateConnection(connection);
            this.myFreeConnections.offerFirst(connection);
        }
        catch (Exception e) {
            ConnectionPool.panic("Passivate Connection", e);
            this.closeAndLeaveConnection(connection);
        }
    }

    protected void passivateConnection(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            ConnectionPool.$$$reportNull$$$0(9);
        }
        if (!connection.getAutoCommit()) {
            connection.rollback();
            connection.setAutoCommit(true);
        }
    }

    public void disconnect() {
        this.myReady = false;
        while (!this.myAllConnections.isEmpty()) {
            ConnectionPool.sleep(11);
            ArrayList toClose = new ArrayList(this.myConnectionsLimit);
            this.myFreeConnections.drainTo(toClose, 100);
            this.myAllConnections.removeAll(toClose);
            for (Connection connection : toClose) {
                this.closeConnection(connection);
            }
            toClose.clear();
        }
    }

    private void closeAndLeaveConnection(@NotNull Connection connection) {
        if (connection == null) {
            ConnectionPool.$$$reportNull$$$0(10);
        }
        this.myFreeConnections.remove(connection);
        this.myAllConnections.remove(connection);
        this.closeConnection(connection);
        this.myReady = this.myReady && !this.myAllConnections.isEmpty();
    }

    private void closeConnection(Connection connection) {
        try {
            if (this.myOwnConnections) {
                connection.close();
            }
        }
        catch (Exception e) {
            ConnectionPool.panic("Close connection", e);
        }
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceClass == null) {
            ConnectionPool.$$$reportNull$$$0(11);
        }
        if (serviceName == null) {
            ConnectionPool.$$$reportNull$$$0(12);
        }
        return null;
    }

    public int getHoldConnections() {
        return this.myHoldConnections;
    }

    public void setHoldConnections(int holdConnections) {
        this.myHoldConnections = holdConnections;
    }

    public int getConnectionsLimit() {
        return this.myConnectionsLimit;
    }

    public void setConnectionsLimit(int connectionsLimit) {
        this.myConnectionsLimit = connectionsLimit;
    }

    public int countAllConnections() {
        return this.myAllConnections.size();
    }

    public int countFreeConnections() {
        return this.myFreeConnections.size();
    }

    public int countBorrowedConnections() {
        int z;
        int a = this.myAllConnections.size();
        int f = this.myFreeConnections.size();
        do {
            z = a - f;
        } while (a != this.myAllConnections.size() || f != this.myFreeConnections.size());
        return z;
    }

    private static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void panic(String operationDescription, Exception e) {
        System.err.printf("Operation %s failed: %s: %s\n", operationDescription, e.getClass().getSimpleName(), e.getMessage());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalDataSource";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/pooling/ConnectionPool";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/pooling/ConnectionPool";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalDataSource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "borrow";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "provideWithConnection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prepareConnectionAfterConnected";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "activateConnection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "passivateConnection";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "closeAndLeaveConnection";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

