/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.SybaseExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.dialects.SybaseIntermediateFacade;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AseJdbcHelper
extends JdbcHelperImpl {
    private static final Pattern ASE_VERSION_PATTERN = Pattern.compile("/" + JdbcNativeUtil.DEFAULT_VERSION_PATTERN.pattern());
    private static final Set<String> SYBASE_UNLIMITED_TYPES = Collections.singleton("int");

    public AseJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("SYBASE", version, connection);
    }

    public AseJdbcHelper() {
        this(null, null);
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            AseJdbcHelper.$$$reportNull$$$0(0);
        }
        return new SybaseIntermediateFacade(ds, 1, false, SybaseExceptionRecognizer.INSTANCE);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return AseJdbcHelper.extractVersion(version);
    }

    @Override
    protected void setBigInteger(@NotNull RemotePreparedStatement statement, @NotNull BigInteger value, int idx) throws Exception {
        if (statement == null) {
            AseJdbcHelper.$$$reportNull$$$0(1);
        }
        if (value == null) {
            AseJdbcHelper.$$$reportNull$$$0(2);
        }
        statement.setObject(idx, value.longValue());
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            AseJdbcHelper.$$$reportNull$$$0(3);
        }
        if (e.typeName == null) {
            return;
        }
        if (SYBASE_UNLIMITED_TYPES.contains(e.typeName.toLowerCase(Locale.ENGLISH))) {
            e.length = -1;
        }
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (product == null || !JdbcNativeUtil.detectString(product, "sybase") && !JdbcNativeUtil.detectString(product, "adaptive server") && !StringUtilRt.startsWithIgnoreCase((String)product, (String)"ase")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return AseJdbcHelper.create(delegate, productVer);
    }

    @NotNull
    private static AseJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "select @@version");
        JdbcNativeUtil.logInfo("@@version: " + versionStr);
        return new AseJdbcHelper(AseJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        String res = JdbcNativeUtil.findVersion(str, ASE_VERSION_PATTERN);
        if (res == null) {
            res = JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
        }
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/AseJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createFacade";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setBigInteger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

