/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.target;

import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.remote.run.target.configuration.DockerTargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerRemoteRequest
implements TargetEnvironmentRequest {
    private final DockerTargetEnvironmentConfiguration myTargetConfiguration;
    private final TargetPlatform myTargetPlatform;
    private final Map<String, MountedFileValue> myFilesMap = new LinkedHashMap<String, MountedFileValue>();
    private final Map<Integer, BoundPortValue> myPortsMap = new TreeMap<Integer, BoundPortValue>();

    public DockerRemoteRequest(DockerTargetEnvironmentConfiguration config, TargetPlatform platform) {
        this.myTargetConfiguration = config;
        this.myTargetPlatform = platform;
    }

    @NotNull
    public TargetPlatform getTargetPlatform() {
        TargetPlatform targetPlatform = this.myTargetPlatform;
        if (targetPlatform == null) {
            DockerRemoteRequest.$$$reportNull$$$0(0);
        }
        return targetPlatform;
    }

    public DockerTargetEnvironmentConfiguration getTargetConfiguration() {
        return this.myTargetConfiguration;
    }

    @NotNull
    public TargetValue<String> createUpload(@NotNull String localPath) {
        if (localPath == null) {
            DockerRemoteRequest.$$$reportNull$$$0(1);
        }
        TargetValue targetValue = (TargetValue)this.myFilesMap.computeIfAbsent(localPath, p -> MountedFileValue.forLocalPath(p, this.myTargetPlatform));
        if (targetValue == null) {
            DockerRemoteRequest.$$$reportNull$$$0(2);
        }
        return targetValue;
    }

    @NotNull
    public TargetValue<Integer> bindTargetPort(int targetPort) {
        TargetValue targetValue = (TargetValue)this.myPortsMap.computeIfAbsent(targetPort, BoundPortValue::new);
        if (targetValue == null) {
            DockerRemoteRequest.$$$reportNull$$$0(3);
        }
        return targetValue;
    }

    public List<String> getPortsAsCliOptions() {
        return this.myPortsMap.values().stream().flatMap(port -> Stream.of(port.asCliOption())).collect(Collectors.toList());
    }

    public List<MountedFileValue> getFilesToTransfer() {
        return new ArrayList<MountedFileValue>(this.myFilesMap.values());
    }

    public List<BoundPortValue> getRemotePortsToBind() {
        return new ArrayList<BoundPortValue>(this.myPortsMap.values());
    }

    private static Logger getLogger() {
        return Logger.getInstance(DockerRemoteRequest.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetPlatform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpload";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "bindTargetPort";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUpload";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class BoundPortValue
    extends DeferredLocalTargetValue<Integer> {
        private static final int NOT_BOUND = -1;

        BoundPortValue(int containerPort) {
            super((Object)containerPort);
        }

        int getContainerPort() {
            try {
                Integer port = (Integer)this.getTargetValue().blockingGet(0);
                return port != null ? port : -1;
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IllegalStateException("Port has not been resolved yet", e);
            }
        }

        void localPortBound(@Nullable DockerPortBinding portBinding) {
            Integer resolvedValue;
            Integer n = resolvedValue = portBinding == null ? null : portBinding.getHostPort();
            if (resolvedValue != null) {
                super.resolve((Object)resolvedValue);
                return;
            }
            try {
                int remotePort = this.getContainerPort();
                DockerRemoteRequest.getLogger().error("Requested port " + remotePort + " is not bound by container: " + portBinding);
            }
            catch (RuntimeException e) {
                DockerRemoteRequest.getLogger().error("Remote port was not set, port binding can't be found", (Throwable)e);
            }
        }

        String[] asCliOption() {
            return new String[]{"-p", "17000-17500:" + this.getContainerPort()};
        }
    }

    static class MountedFileValue
    extends DeferredTargetValue<String> {
        private final File myLocalFile;
        private final TargetPlatform myTargetPlatform;

        static MountedFileValue forLocalPath(String localPath, TargetPlatform platform) {
            try {
                File canonicalFile = new File(FileUtil.toSystemDependentName((String)localPath)).getCanonicalFile();
                return new MountedFileValue(canonicalFile, platform);
            }
            catch (IOException e) {
                throw new RuntimeException("Can't resolve path: " + localPath, e);
            }
        }

        private MountedFileValue(@NotNull File localFile, @NotNull TargetPlatform platform) {
            if (localFile == null) {
                MountedFileValue.$$$reportNull$$$0(0);
            }
            if (platform == null) {
                MountedFileValue.$$$reportNull$$$0(1);
            }
            super((Object)localFile.getAbsolutePath());
            this.myLocalFile = localFile;
            this.myTargetPlatform = platform;
        }

        boolean isDirectory() {
            return this.myLocalFile.isDirectory();
        }

        File getVolumeRoot() {
            return this.isDirectory() ? this.myLocalFile : this.myLocalFile.getParentFile();
        }

        void volumeAttached(DockerVolumeBinding volume) {
            String remotePath = this.isDirectory() ? volume.getContainerPath() : volume.getContainerPath() + this.myTargetPlatform.getPlatform().fileSeparator + this.myLocalFile.getName();
            super.resolve((Object)remotePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "platform";
                    break;
                }
            }
            objectArray[1] = "com/intellij/docker/remote/run/target/DockerRemoteRequest$MountedFileValue";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

