/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.caches;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class FileContent
extends UserDataHolderBase {
    private final VirtualFile myVirtualFile;
    private byte[] myCachedBytes;
    private long myCachedLength;
    private long myCachedTimeStamp;
    private Boolean myCachedWritable;

    public FileContent(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            FileContent.$$$reportNull$$$0(0);
        }
        this.myCachedLength = -1L;
        this.myCachedTimeStamp = -1L;
        this.myVirtualFile = virtualFile2;
    }

    public byte @NotNull [] getBytesOrEmptyArray() {
        byte[] byArray;
        try {
            byArray = this.getBytes();
        }
        catch (IOException e) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileContent.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        if (byArray == null) {
            FileContent.$$$reportNull$$$0(1);
        }
        return byArray;
    }

    public byte @NotNull [] getBytes() throws IOException {
        if (this.myCachedBytes == null) {
            if (this.myVirtualFile.isValid()) {
                this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
                this.myCachedBytes = this.myVirtualFile.contentsToByteArray(false);
            } else {
                this.myCachedTimeStamp = -1L;
                this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
        }
        if (this.myCachedBytes == null) {
            FileContent.$$$reportNull$$$0(3);
        }
        return this.myCachedBytes;
    }

    public void setEmptyContent() {
        this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.myCachedLength = 0L;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myVirtualFile;
        if (virtualFile2 == null) {
            FileContent.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    public long getLength() {
        if (this.myCachedLength == -1L) {
            this.myCachedLength = this.myVirtualFile.getLength();
        }
        return this.myCachedLength;
    }

    public long getTimeStamp() {
        if (this.myCachedTimeStamp == -1L) {
            this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
        }
        return this.myCachedTimeStamp;
    }

    public boolean isWritable() {
        if (this.myCachedWritable == null) {
            this.myCachedWritable = this.myVirtualFile.isWritable();
        }
        return this.myCachedWritable == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/caches/FileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/caches/FileContent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytesOrEmptyArray";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBytes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

