/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.google.common.base.CharMatcher;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JBCefFileSchemeHandler
extends CefResourceHandlerAdapter {
    private static final Logger LOG = Logger.getInstance(JBCefFileSchemeHandler.class);
    public static final String FILE_SCHEME_NAME = "file";
    @NotNull
    private final CefBrowser myBrowser;
    @NotNull
    private final CefFrame myFrame;
    @Nullable
    private Path myPath;
    @Nullable
    private InputStream myInputStream;

    JBCefFileSchemeHandler(@NotNull CefBrowser browser, @NotNull CefFrame frame) {
        if (browser == null) {
            JBCefFileSchemeHandler.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            JBCefFileSchemeHandler.$$$reportNull$$$0(1);
        }
        this.myBrowser = browser;
        this.myFrame = frame;
    }

    public boolean processRequest(@NotNull CefRequest request, @NotNull CefCallback callback) {
        String url;
        if (request == null) {
            JBCefFileSchemeHandler.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            JBCefFileSchemeHandler.$$$reportNull$$$0(3);
        }
        if ((url = request.getURL()) != null) {
            try {
                this.myPath = Paths.get(new URI(MyUriUtil.trimParameters(url)));
                if (!JBCefFileSchemeHandler.checkAccessAllowed(this.myPath)) {
                    LOG.info("Access denied: " + this.myPath);
                    return false;
                }
            }
            catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myPath != null) {
            callback.Continue();
            return true;
        }
        return false;
    }

    public void getResponseHeaders(@NotNull CefResponse response, IntRef response_length, StringRef redirectUrl) {
        if (response == null) {
            JBCefFileSchemeHandler.$$$reportNull$$$0(4);
        }
        if (this.myPath != null) {
            try {
                response.setMimeType(Files.probeContentType(this.myPath));
                this.myInputStream = new BufferedInputStream(new FileInputStream(this.myPath.toFile()));
            }
            catch (IOException | UnsupportedOperationException e) {
                response.setError(CefLoadHandler.ErrorCode.ERR_FILE_NOT_FOUND);
                response.setStatusText(e.getLocalizedMessage());
                LOG.error((Throwable)e);
            }
        }
        response.setStatus(this.myInputStream != null ? 200 : 404);
    }

    public boolean readResponse(byte @NotNull [] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
        if (data_out == null) {
            JBCefFileSchemeHandler.$$$reportNull$$$0(5);
        }
        try {
            int availableSize;
            int n = availableSize = this.myInputStream != null ? this.myInputStream.available() : 0;
            if (availableSize > 0) {
                int bytesToRead = Math.min(bytes_to_read, availableSize);
                bytesToRead = this.myInputStream.read(data_out, 0, bytesToRead);
                bytes_read.set(bytesToRead);
                return true;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        bytes_read.set(0);
        this.myPath = null;
        if (this.myInputStream != null) {
            try {
                this.myInputStream.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            this.myInputStream = null;
        }
        return false;
    }

    private static boolean checkAccessAllowed(Path path2) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data_out";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/JBCefFileSchemeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getResponseHeaders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "readResponse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyUriUtil {
        public static final CharMatcher PARAM_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"?#;");

        private MyUriUtil() {
        }

        public static String trimParameters(@NotNull String url) {
            int end;
            if (url == null) {
                MyUriUtil.$$$reportNull$$$0(0);
            }
            return (end = PARAM_CHAR_MATCHER.indexIn((CharSequence)url)) != -1 ? url.substring(0, end) : url;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ui/jcef/JBCefFileSchemeHandler$MyUriUtil", "trimParameters"));
        }
    }
}

