/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.MessagePool;
import com.intellij.diagnostic.MessagePoolListener;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.diagnostic.VMOptions;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.ide.lightEdit.LightEditorInfo;
import com.intellij.ide.lightEdit.LightEditorListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.CommandLogger;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.PlaybackRunnerExtended;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.profilers.YourKitProfilerHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectLoaded
implements StartupActivity.DumbAware,
ApplicationInitializedListener {
    private static final Logger LOG = Logger.getInstance((String)"PerformancePlugin");
    private static final int TIMEOUT = 500;
    private static final String fileNameProperty = System.getProperty("testscript.filename");
    private static final String INDEXING_PROFILER_PREFIX = "%%profileIndexing";
    private final Alarm myAlarm = AlarmFactory.getInstance().create();

    ProjectLoaded() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ProjectLoaded.$$$reportNull$$$0(0);
        }
        if (fileNameProperty != null) {
            LOG.info("Start Execution");
            Pair<String, List<String>> profilerSettings = ProjectLoaded.initializeProfilerSettingsForIndexing();
            if (profilerSettings != null) {
                try {
                    ProfilersController.getInstance().getCurrentProfilerHandler().startProfiling((String)profilerSettings.first, (List)profilerSettings.second);
                }
                catch (Exception e) {
                    System.err.println("Start profile failed: " + e.getMessage());
                    ApplicationManagerEx.getApplicationEx().exit(true, true);
                }
            }
            if (LightEdit.owns((Project)project)) {
                this.runScript(project);
            } else {
                this.runScriptAfterDumb(project);
            }
        } else {
            if (YourKitProfilerHandler.isStartupProfilingInVMEnabled() && VMOptions.getWriteFile() != null) {
                YourKitProfilerHandler.disableProfiler();
                ProjectLoaded.showStartupProfilingNotification();
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info(PerformanceTestingBundle.message("startup.silent", new Object[0]));
            }
        }
    }

    private static Pair<String, List<String>> initializeProfilerSettingsForIndexing() {
        try {
            List lines = FileUtil.loadLines((File)ProjectLoaded.getTestFile());
            for (String line : lines) {
                if (!line.startsWith(INDEXING_PROFILER_PREFIX)) continue;
                String[] command = line.substring(INDEXING_PROFILER_PREFIX.length()).trim().split("\\s+", 2);
                String indexingActivity = command[0];
                ArrayList profilingParameters = command.length > 1 ? Arrays.asList(command[1].trim().split(",")) : new ArrayList();
                return new Pair((Object)indexingActivity, profilingParameters);
            }
        }
        catch (IOException ignored) {
            System.err.println(PerformanceTestingBundle.message("startup.script.read.error", new Object[0]));
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        return null;
    }

    private static File getTestFile() {
        File file = new File(fileNameProperty);
        if (!file.isFile()) {
            System.err.println(PerformanceTestingBundle.message("startup.noscript", file.getAbsolutePath()));
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        return file;
    }

    private static void showStartupProfilingNotification() {
        final File snapshotDir = new File(SystemProperties.getUserHome(), "snapshots");
        final Notification completeNotification = new Notification("PerformancePlugin", PerformanceTestingBundle.message("notification.title.startup.profiling.in.progress", new Object[0]), PerformanceTestingBundle.message("notification.message.cpu.snapshot.file", snapshotDir.getAbsolutePath()), NotificationType.INFORMATION);
        completeNotification.addAction(new AnAction(PerformanceTestingBundle.message("action.text.show.profile.location", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileUtil.createDirectory((File)snapshotDir);
                RevealFileAction.openDirectory((File)snapshotDir);
                completeNotification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/performancePlugin/ProjectLoaded$2", "actionPerformed"));
            }
        });
        Notifications.Bus.notify((Notification)completeNotification);
    }

    private static void subscribeToErrors() {
        final MessagePool messagePool = MessagePool.getInstance();
        LOG.info("Error watcher has started");
        messagePool.addListener(new MessagePoolListener(){

            public void newEntryAdded() {
                List errors = messagePool.getFatalErrors(true, true);
                if (!errors.isEmpty()) {
                    String throwableText = ((AbstractMessage)errors.get(0)).getThrowableText();
                    System.out.printf("##teamcity[testFailed name='%s' message='%s' details='%s']\n", FileUtilRt.getNameWithoutExtension((String)ProjectLoaded.getTestFile().getName()), "Exception occurred during the run", ProjectLoaded.processStringForTC(throwableText));
                    System.out.printf("##teamcity[buildProblem description='%s' identity='%s'] ", ProjectLoaded.processStringForTC("Errors during the test are not allowed. " + errors.size() + " were detected!"), ProjectLoaded.processStringForTC(FileUtilRt.getNameWithoutExtension((String)ProjectLoaded.getTestFile().getName())));
                    String rant = "\n\n=================================================================\nThere were IDE errors detected!\nExectuion of the script is CANCELLED. IDE will EXIT now!\n\nFix the errors and try again\n=================================================================\n\n\n";
                    System.out.println(rant);
                    Logger.getInstance(this.getClass()).warn(rant);
                    String dump = "Thread dump:\n" + ThreadDumper.dumpThreadsToString();
                    LOG.info(dump);
                    ApplicationManagerEx.getApplicationEx().exit(true, true);
                }
            }
        });
    }

    private static String processStringForTC(String line) {
        int MAX_DESCRIPTION_LENGTH = 10000;
        return line.substring(0, Math.min(10000, line.length() - 1)).replaceAll("\\|", "||").replaceAll("\\[", "|[").replaceAll("]", "|]").replaceAll("\n", "|n").replaceAll("'", "|'").replaceAll("\r", "|r");
    }

    public void componentsInitialized() {
        if (((ApplicationImpl)ApplicationManager.getApplication()).isLightEditMode()) {
            LightEditService.getInstance().getEditorManager().addListener(new LightEditorListener(){

                public void afterSelect(@Nullable LightEditorInfo editorInfo) {
                    StartUpPerformanceReporter.Companion.logStats("LightEditor");
                    ProjectLoaded.this.runActivity(LightEditService.getInstance().getProject());
                }
            });
        }
    }

    private void runScriptAfterDumb(Project project) {
        DumbService.getInstance((Project)project).smartInvokeLater(() -> this.myAlarm.addRequest(() -> {
            if (DumbService.isDumb((Project)project)) {
                this.runScriptAfterDumb(project);
            } else {
                this.runScript(project);
            }
        }, 500));
    }

    private void runScript(Project project) {
        PlaybackRunnerExtended playback = this.createRunner("%include " + ProjectLoaded.getTestFile(), new CommandLogger(), project);
        playback.setScriptDir(ProjectLoaded.getTestFile().getParentFile());
        playback.run();
        LOG.info(PerformanceTestingBundle.message("startup.finish", new Object[0]));
    }

    @NotNull
    protected PlaybackRunnerExtended createRunner(String script, CommandLogger commandLogger, Project project) {
        return new PlaybackRunnerExtended(script, commandLogger, project);
    }

    static {
        if (fileNameProperty != null) {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

                public void appStarting(@Nullable Project projectFromCommandLine) {
                    ProjectLoaded.subscribeToErrors();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/performancePlugin/ProjectLoaded", "runActivity"));
    }
}

