/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.ArrayList;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ShowAltEnter
extends AbstractCommand
implements Disposable {
    public static final String PREFIX = "%altEnter";
    private final Project myProject;

    public ShowAltEnter(@NotNull String text, int line, @NotNull Project project) {
        if (text == null) {
            ShowAltEnter.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ShowAltEnter.$$$reportNull$$$0(1);
        }
        super(text, line);
        this.myProject = project;
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ShowAltEnter.$$$reportNull$$$0(2);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String actionName = this.getText().substring(PREFIX.length()).trim();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor != null) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                if (psiFile != null) {
                    ShowIntentionsPass.IntentionsInfo intentions = ShowIntentionActionsHandler.calcIntentions((Project)this.myProject, (Editor)editor, (PsiFile)psiFile);
                    if (!actionName.isEmpty()) {
                        ArrayList combined = new ArrayList();
                        combined.addAll(intentions.intentionsToShow);
                        combined.addAll(intentions.inspectionFixesToShow);
                        combined.addAll(intentions.errorFixesToShow);
                        combined.addAll(intentions.guttersToShow);
                        combined.addAll(intentions.notificationActionsToShow);
                        Optional<HighlightInfo.IntentionActionDescriptor> singleIntention = combined.stream().filter(s -> s.getAction().getText().startsWith(actionName)).findFirst();
                        if (!singleIntention.isPresent()) {
                            actionCallback.reject(actionName + " is not found among " + ((Object)combined).toString());
                        }
                        singleIntention.ifPresent(c -> ShowIntentionActionsHandler.chooseActionAndInvoke((PsiFile)psiFile, (Editor)editor, (IntentionAction)c.getAction(), (String)c.getAction().getText()));
                    } else {
                        CachedIntentions cachedIntentions = CachedIntentions.create((Project)this.myProject, (PsiFile)psiFile, (Editor)editor, (ShowIntentionsPass.IntentionsInfo)intentions);
                        IntentionHintComponent.showIntentionHint((Project)this.myProject, (PsiFile)psiFile, (Editor)editor, (boolean)true, (CachedIntentions)cachedIntentions);
                    }
                    actionCallback.setDone();
                } else {
                    actionCallback.reject("PSI File is null");
                }
            } else {
                actionCallback.reject("Editor is not opened");
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            ShowAltEnter.$$$reportNull$$$0(3);
        }
        return promise;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/ShowAltEnter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/ShowAltEnter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

