/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class StoreIndices
extends AbstractCommand {
    public static final String PREFIX = "%storeIndices";
    private static final Logger LOG = Logger.getInstance(StoreIndices.class);
    private final Project myProject;
    public static Path storedIndex;

    public StoreIndices(String text, int line, Project project) {
        super(text, line);
        this.myProject = project;
    }

    public static Path getStoredIndex() throws IOException {
        if (storedIndex == null) {
            storedIndex = System.getProperty("performance.out.folder") != null ? Paths.get(System.getProperty("performance.out.folder"), new String[0]) : FileUtil.createTempDirectory((String)"stored_index", null).toPath();
        }
        return storedIndex;
    }

    protected Promise<Object> _execute(PlaybackContext context) {
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        LOG.info("dynamic.classpath: " + PropertiesComponent.getInstance((Project)this.myProject).getValue("dynamic.classpath"));
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(() -> {
            ((FileBasedIndexImpl)FileBasedIndex.getInstance()).flushIndexes();
            File indexDir = IndexInfrastructure.getIndexRootDir((ID)ID.findByName((String)"Stubs")).getParentFile();
            try {
                FileUtil.delete((Path)StoreIndices.getStoredIndex());
                FileUtil.copyDir((File)indexDir, (File)StoreIndices.getStoredIndex().toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            LOG.info("Indices have been successfully stored");
            actionCallback.setDone();
        });
        return Promises.toPromise((ActionCallback)actionCallback);
    }
}

