/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.performancePlugin.tracing.agent.AgentLogger;
import com.jetbrains.performancePlugin.tracing.agent.Config;
import com.jetbrains.performancePlugin.tracing.agent.TracingAgent;
import java.io.File;
import java.lang.instrument.Instrumentation;
import net.bytebuddy.agent.ByteBuddyAgent;

public class MethodTracing {
    public static final String toolWindowId = "Internal Method Tracing";
    public static final String configFileName = "method.tracing.config";
    static final Logger LOG = Logger.getInstance(MethodTracing.class);
    private static Instrumentation ourInstrumentation = null;
    private static final AgentLogger agentLogger = new AgentLogger(){

        @Override
        public void debug(String message) {
            LOG.debug(message);
        }

        @Override
        public void error(String message) {
            LOG.error(message);
        }

        @Override
        public void error(Throwable t) {
            LOG.debug(t);
        }
    };

    public static void instrument(Config config) {
        if (ourInstrumentation == null) {
            try {
                ourInstrumentation = ByteBuddyAgent.install();
                LOG.info("Tracing agent installed");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                throw e;
            }
        }
        TracingAgent.instrument(ourInstrumentation, config, agentLogger);
    }

    public static File configFile() {
        return new File(PathManager.getConfigPath(), configFileName);
    }
}

