/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.tracing.ui;

import com.intellij.util.ui.ColumnInfo;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class DataById<Data> {
    private final ConcurrentMap<String, Data> dataBuffer = new ConcurrentHashMap<String, Data>();
    private final Function<Data, String> idFunction;

    public DataById(Function<Data, String> function) {
        this.idFunction = function;
    }

    public String getId(Data data) {
        return this.idFunction.apply(data);
    }

    public Data getData(String id) {
        return (Data)this.dataBuffer.get(id);
    }

    public void forEachId(Consumer<String> action) {
        this.dataBuffer.keySet().forEach(action);
    }

    public void clear() {
        this.dataBuffer.clear();
    }

    public void refresh(List<Data> newData) {
        newData.forEach(d -> this.dataBuffer.put(this.getId(d), d));
    }

    public <T extends Comparable<T>> ColumnInfo<String, T> column(String name, final Function<Data, T> valueFunction) {
        return new ColumnInfo<String, T>(name){

            @Nullable
            public T valueOf(String id) {
                return (Comparable)valueFunction.apply(DataById.this.getData(id));
            }

            @Nullable
            public Comparator<String> getComparator() {
                return Comparator.comparing(id -> this.valueOf((String)id), Comparator.naturalOrder());
            }
        };
    }
}

