/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.MessagingLogger;
import org.jetbrains.debugger.UtilKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.io.webSocket.WebSocketProtocolHandler;
import org.jetbrains.io.webSocket.WebSocketProtocolHandshakeHandler;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.wip.BrowserWipVm;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.StandaloneWipVm;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.inspector.DetachedEventData;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J\u0018\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020!H\u0014J\u001e\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0016J\u001e\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J\u001e\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0004J6\u0010(\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100*2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0014J&\u0010+\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0004R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006,"}, d2={"Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "Lorg/jetbrains/wip/WipVm;", "url", "Lcom/intellij/util/Url;", "debugLogSuffix", "", "(Lcom/intellij/util/Url;Ljava/lang/String;)V", "currentPageTitle", "getDebugLogSuffix", "()Ljava/lang/String;", "getUrl", "()Lcom/intellij/util/Url;", "connectDebugger", "", "page", "Lcom/jetbrains/debugger/wip/PageConnection;", "context", "Lio/netty/channel/ChannelHandlerContext;", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "debugMessageQueue", "Lorg/jetbrains/debugger/MessagingLogger;", "connectToPage", "", "address", "Ljava/net/InetSocketAddress;", "connectionsJson", "Lio/netty/buffer/ByteBuf;", "connectedAddressToPresentation", "vm", "Lorg/jetbrains/debugger/Vm;", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "vmResult", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "handleExceptionOnGettingWebSockets", "e", "", "processPageConnections", "pageConnections", "", "sendGetJson", "intellij.javascript.chrome.connector"})
public class WipRemoteVmConnection
extends RemoteVmConnection<WipVm> {
    private String currentPageTitle;
    @Nullable
    private final Url url;
    @Nullable
    private final String debugLogSuffix;

    @NotNull
    protected Bootstrap createBootstrap() {
        return BuiltInServerManager.Companion.getInstance().createClientBootstrap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        Bootstrap $this$handler$iv = this.createBootstrap();
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, address, vmResult){
            final /* synthetic */ WipRemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address$inlined;
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.this$0 = wipRemoteVmConnection;
                this.$address$inlined = inetSocketAddress;
                this.$vmResult$inlined = asyncPromise;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Channel it = channel;
                boolean bl = false;
                it.pipeline().addLast(new ChannelHandler[]{(ChannelHandler)new HttpClientCodec(), (ChannelHandler)new HttpObjectAggregator(0xA00000), this.this$0.createChannelHandler(this.$address$inlined, (AsyncPromise<WipVm>)this.$vmResult$inlined)});
            }
        });
        return var3_3;
    }

    @NotNull
    protected ChannelHandler createChannelHandler(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, address, vmResult){
            final /* synthetic */ WipRemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ AsyncPromise $vmResult;

            public void channelActive(@NotNull ChannelHandlerContext context) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                super.channelActive(context);
                this.this$0.sendGetJson(this.$address, context, (AsyncPromise<WipVm>)this.$vmResult);
            }

            protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpResponse message) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                try {
                    context.pipeline().remove((ChannelHandler)this);
                    ByteBuf byteBuf = message.content();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"message.content()");
                    this.this$0.connectToPage(context, this.$address, byteBuf, (AsyncPromise<WipVm>)this.$vmResult);
                }
                catch (Throwable e) {
                    this.this$0.handleExceptionOnGettingWebSockets(e, (AsyncPromise<WipVm>)this.$vmResult);
                }
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }
            {
                this.this$0 = $outer;
                this.$address = $captured_local_variable$1;
                this.$vmResult = $captured_local_variable$2;
            }
        };
    }

    protected final void handleExceptionOnGettingWebSockets(@NotNull Throwable e, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        if (e instanceof MalformedJsonException) {
            String host;
            String string = JSDebuggerBundle.message((String)"error.websocket.message", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026error.websocket.message\")");
            String message = string;
            InetSocketAddress inetSocketAddress = this.getAddress();
            if (!(inetSocketAddress instanceof HttpInetSocketAddress)) {
                inetSocketAddress = null;
            }
            HttpInetSocketAddress httpInetSocketAddress = (HttpInetSocketAddress)inetSocketAddress;
            String string2 = host = httpInetSocketAddress != null ? httpInetSocketAddress.getOriginalHostName() : null;
            if (host != null && !NetUtil.isValidIpV4Address((String)host) && !NetUtil.isValidIpV6Address((String)host) && Intrinsics.areEqual((Object)host, (Object)"localhost") ^ true && Intrinsics.areEqual((Object)host, (Object)"localhost6") ^ true) {
                message = message + "\n\n" + JSDebuggerBundle.message((String)"error.websocket.nodejs.message", (Object[])new Object[0]);
            }
            vmResult.setError(message);
        } else {
            vmResult.setError(e);
        }
    }

    protected final void sendGetJson(@NotNull InetSocketAddress address, @NotNull ChannelHandlerContext context, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(address));
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
        ChannelFuture channelFuture = context.channel().writeAndFlush((Object)request);
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"context.channel().writeAndFlush(request)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(vmResult){
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.$vmResult$inlined = asyncPromise;
            }

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                boolean bl = false;
                if (!it2.isSuccess()) {
                    Throwable throwable = it2.cause();
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it.cause()");
                    this.$vmResult$inlined.setError(throwable);
                }
            }
        });
    }

    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        String string;
        StringBuilder stringBuilder;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
                Intrinsics.checkParameterIsNotNull((Object)vm, (String)"vm");
                stringBuilder = new StringBuilder().append(super.connectedAddressToPresentation(address, vm));
                string = this.currentPageTitle;
                if (string == null) break block2;
                String string2 = string;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = " \u2013 " + it;
                stringBuilder = stringBuilder2;
                string = string3;
                if (string != null) break block3;
            }
            string = "";
        }
        return stringBuilder.append(string).toString();
    }

    /*
     * Unable to fully structure code
     */
    protected boolean connectToPage(@NotNull ChannelHandlerContext context, @NotNull InetSocketAddress address, @NotNull ByteBuf connectionsJson, @NotNull AsyncPromise<WipVm> result) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)connectionsJson, (String)"connectionsJson");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        v0 = this.getDebugLogSuffix();
        if (v0 == null) {
            v0 = "";
        }
        v1 = debugMessageQueue = UtilKt.createDebugLogger((String)"js.debugger.wip.log", (String)v0);
        if (v1 != null) {
            var6_6 = v1;
            var7_7 = false;
            var8_9 = false;
            logger = var6_6;
            $i$a$-let-WipRemoteVmConnection$connectToPage$1 = false;
            logger.add(connectionsJson, "IN");
            result.onError((Consumer)new Consumer<Throwable>(logger){
                final /* synthetic */ MessagingLogger $logger;

                public final void accept(@NotNull Throwable it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$logger.add((CharSequence)("" + '\"' + it + '\"'), "Error");
                    this.$logger.close();
                }
                {
                    this.$logger = messagingLogger;
                }
            });
        }
        if (!connectionsJson.isReadable()) {
            v2 = JSDebuggerBundle.message((String)"error.websocket.malformed.message", (Object[])new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"JSDebuggerBundle.message\u2026ocket.malformed.message\")");
            result.setError(v2);
            return true;
        }
        var7_8 = (InputStream)new ByteBufInputStream(connectionsJson);
        var8_10 = Charsets.UTF_8;
        logger = false;
        var16_16 = new InputStreamReader(var7_8, var8_10);
        var17_17 = var16_16;
        reader = new JsonReader(var17_17);
        if (reader.peek() == JsonToken.BEGIN_ARRAY) {
            reader.beginArray();
        }
        pageConnections = new SmartList();
        while (reader.hasNext() && reader.peek() != JsonToken.END_DOCUMENT) {
            reader.beginObject();
            pageUrl = null;
            webSocketDebuggerUrl = null;
            title = null;
            type = null;
            id = null;
            block8: while (reader.hasNext()) {
                block13: {
                    block14: {
                        block16: {
                            block15: {
                                if (reader.nextName() == null) break block13;
                                switch (var13_20.hashCode()) {
                                    case 3355: {
                                        if (!var13_20.equals("id")) ** break;
                                        break block14;
                                    }
                                    case 110371416: {
                                        if (!var13_20.equals("title")) ** break;
                                        break;
                                    }
                                    case 3575610: {
                                        if (!var13_20.equals("type")) ** break;
                                        break block15;
                                    }
                                    case -346402009: {
                                        if (!var13_20.equals("webSocketDebuggerUrl")) ** break;
                                        break block16;
                                    }
                                    case 116079: {
                                        if (!var13_20.equals("url")) ** break;
                                        pageUrl = reader.nextString();
                                        continue block8;
                                    }
                                }
                                title = reader.nextString();
                                continue;
                            }
                            type = reader.nextString();
                            continue;
                        }
                        webSocketDebuggerUrl = reader.nextString();
                        continue;
                    }
                    id = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            pageConnections.add((Object)new PageConnection(pageUrl, title, type, webSocketDebuggerUrl, id, address));
        }
        return this.processPageConnections(context, debugMessageQueue, (List)pageConnections, result) == false;
    }

    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(pageConnections, (String)"pageConnections");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        SmartList debuggablePages = new SmartList();
        for (PageConnection p : pageConnections) {
            if (this.url == null) {
                debuggablePages.add((Object)p);
                continue;
            }
            String string = p.getUrl();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (!Urls.INSTANCE.equals(this.url, Urls.newFromEncoded((String)string), SystemInfo.isFileSystemCaseSensitive, true)) continue;
            this.connectDebugger(p, context, result, debugMessageQueue);
            return true;
        }
        if (this.url == null) {
            Intrinsics.checkExpressionValueIsNotNull((Object)RemoteVmConnectionKt.chooseDebuggee((Collection)((Collection)debuggablePages), (int)-1, (Function2)processPageConnections.1.INSTANCE).onSuccess((Consumer)new Consumer<PageConnection>(this, result, context, debugMessageQueue){
                final /* synthetic */ WipRemoteVmConnection this$0;
                final /* synthetic */ AsyncPromise $result;
                final /* synthetic */ ChannelHandlerContext $context;
                final /* synthetic */ MessagingLogger $debugMessageQueue;

                public final void accept(PageConnection it) {
                    String webSocketDebuggerUrl = it.getWebSocketDebuggerUrl();
                    if (webSocketDebuggerUrl == null) {
                        String string = JSDebuggerBundle.message((String)"js.debug.another.debugger.attached", (Object[])new Object[0]);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026other.debugger.attached\")");
                        this.$result.setError(string);
                        return;
                    }
                    WipRemoteVmConnection.access$setCurrentPageTitle$p(this.this$0, it.getTitle());
                    PageConnection pageConnection = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pageConnection, (String)"it");
                    this.this$0.connectDebugger(pageConnection, this.$context, (AsyncPromise<WipVm>)this.$result, this.$debugMessageQueue);
                }
                {
                    this.this$0 = wipRemoteVmConnection;
                    this.$result = asyncPromise;
                    this.$context = channelHandlerContext;
                    this.$debugMessageQueue = messagingLogger;
                }
            }).onError((Consumer)new Consumer<Throwable>(result){
                final /* synthetic */ AsyncPromise $result;

                public final void accept(Throwable it) {
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    this.$result.setError(throwable);
                }
                {
                    this.$result = asyncPromise;
                }
            }), (String)"chooseDebuggee(debuggabl\u2026r { result.setError(it) }");
        } else {
            String string = JSDebuggerBundle.message((String)"error.connection.no.page", (Object[])new Object[]{this.url});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSDebuggerBundle.message\u2026connection.no.page\", url)");
            result.setError(string);
        }
        return true;
    }

    protected void connectDebugger(@NotNull PageConnection page, @NotNull ChannelHandlerContext context, @NotNull AsyncPromise<WipVm> result, @Nullable MessagingLogger debugMessageQueue) {
        StandaloneWipVm standaloneWipVm;
        Intrinsics.checkParameterIsNotNull((Object)page, (String)"page");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(result, (String)"result");
        String string = page.getWebSocketDebuggerUrl();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)URI.create(string), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, null, (int)0x6400000);
        Channel channel = context.channel();
        if (Intrinsics.areEqual((Object)page.getType(), (Object)"node")) {
            DebugEventListener debugEventListener = this.getDebugEventListener();
            String string2 = page.getUrl();
            Channel channel2 = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
            standaloneWipVm = new NodeWipVm(debugEventListener, string2, channel2, debugMessageQueue);
        } else {
            DebugEventListener debugEventListener = this.getDebugEventListener();
            String string3 = page.getUrl();
            Channel channel3 = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)channel3, (String)"channel");
            standaloneWipVm = new BrowserWipVm(debugEventListener, string3, channel3, debugMessageQueue);
        }
        StandaloneWipVm vm = standaloneWipVm;
        vm.setTitle(page.getTitle());
        vm.getCommandProcessor().getEventMap().add((EventType)DetachedEventData.TYPE, (Function1)new Function1<DetachedEventData, Unit>(this){
            final /* synthetic */ WipRemoteVmConnection this$0;

            public final void invoke(@NotNull DetachedEventData it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)it.reason(), (Object)"targetCrashed")) {
                    this.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab crashed)", ConnectionStatus.DISCONNECTED);
                } else {
                    this.this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab was closed or Web Inspector was opened)", ConnectionStatus.DETACHED);
                }
            }
            {
                this.this$0 = wipRemoteVmConnection;
                super(1);
            }
        });
        ChannelPipeline channelPipeline = channel.pipeline();
        ChannelHandler[] channelHandlerArray = new ChannelHandler[3];
        WebSocketClientHandshaker webSocketClientHandshaker = handshaker;
        Intrinsics.checkExpressionValueIsNotNull((Object)webSocketClientHandshaker, (String)"handshaker");
        channelHandlerArray[0] = (ChannelHandler)new WebSocketProtocolHandshakeHandler(vm, result, handshaker, webSocketClientHandshaker){
            final /* synthetic */ StandaloneWipVm $vm;
            final /* synthetic */ AsyncPromise $result;
            final /* synthetic */ WebSocketClientHandshaker $handshaker;

            protected void completed() {
                this.$vm.initDomains();
                this.$result.setResult((Object)((Object)this.$vm));
                this.$vm.ready();
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
                this.$result.setError(cause);
                context.fireExceptionCaught(cause);
            }
            {
                this.$vm = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
                this.$handshaker = $captured_local_variable$2;
                super($super_call_param$3);
            }
        };
        channelHandlerArray[1] = (ChannelHandler)new WebSocketFrameAggregator(0x6400000);
        channelHandlerArray[2] = (ChannelHandler)new WebSocketProtocolHandler(vm){
            final /* synthetic */ StandaloneWipVm $vm;

            protected void textFrameReceived(@NotNull Channel channel, @NotNull TextWebSocketFrame message) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                this.$vm.textFrameReceived(message);
            }
            {
                this.$vm = $captured_local_variable$0;
            }
        };
        channelPipeline.addLast(channelHandlerArray);
        ChannelFuture channelFuture = handshaker.handshake(channel);
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"handshaker.handshake(channel)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(context){
            final /* synthetic */ ChannelHandlerContext $context$inlined;
            {
                this.$context$inlined = channelHandlerContext;
            }

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                boolean bl = false;
                if (!it2.isSuccess()) {
                    this.$context$inlined.fireExceptionCaught(it2.cause());
                }
            }
        });
    }

    @Nullable
    public final Url getUrl() {
        return this.url;
    }

    @Nullable
    public String getDebugLogSuffix() {
        return this.debugLogSuffix;
    }

    public WipRemoteVmConnection(@Nullable Url url, @Nullable String debugLogSuffix) {
        this.url = url;
        this.debugLogSuffix = debugLogSuffix;
    }

    public /* synthetic */ WipRemoteVmConnection(Url url, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            url = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(url, string);
    }

    public WipRemoteVmConnection() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ String access$getCurrentPageTitle$p(WipRemoteVmConnection $this) {
        return $this.currentPageTitle;
    }

    public static final /* synthetic */ void access$setCurrentPageTitle$p(WipRemoteVmConnection $this, String string) {
        $this.currentPageTitle = string;
    }
}

