/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit.codeInsight;

import com.intellij.codeInsight.template.Template;
import com.intellij.javascript.testFramework.codeInsight.AbstractJsGenerateAction;
import com.intellij.javascript.testFramework.codeInsight.GenerateActionContext;
import com.intellij.javascript.testFramework.codeInsight.JsGeneratorUtils;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitGenerateNewTestAction
extends AbstractJsGenerateAction {
    @Override
    @NotNull
    public String getHumanReadableDescription() {
        return "QUnit Test";
    }

    @Override
    public boolean isEnabled(@NotNull GenerateActionContext context) {
        Runnable generator;
        if (context == null) {
            QUnitGenerateNewTestAction.$$$reportNull$$$0(0);
        }
        return (generator = QUnitGenerateNewTestAction.createGenerator(context)) != null;
    }

    @Override
    public void actionPerformed(@NotNull GenerateActionContext context) {
        Runnable generator;
        if (context == null) {
            QUnitGenerateNewTestAction.$$$reportNull$$$0(1);
        }
        if ((generator = QUnitGenerateNewTestAction.createGenerator(context)) != null) {
            generator.run();
        }
    }

    @Nullable
    private static Runnable createGenerator(@NotNull GenerateActionContext context) {
        if (context == null) {
            QUnitGenerateNewTestAction.$$$reportNull$$$0(2);
        }
        QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
        QUnitFileStructure fileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure(context.getJsFile());
        return QUnitGenerateNewTestAction.createGenerator(context, fileStructure);
    }

    @Nullable
    private static Runnable createGenerator(@NotNull GenerateActionContext context, @NotNull QUnitFileStructure fileStructure) {
        if (context == null) {
            QUnitGenerateNewTestAction.$$$reportNull$$$0(3);
        }
        if (fileStructure == null) {
            QUnitGenerateNewTestAction.$$$reportNull$$$0(4);
        }
        if (fileStructure.hasQUnitSymbols()) {
            PsiElement psiElement = context.getPsiElementUnderCaret();
            if (psiElement == null) {
                return null;
            }
            return () -> {
                QUnitModuleStructure moduleStructureUnderCaret;
                int caretOffset = context.getDocumentCaretOffset();
                QUnitTestMethodStructure testMethodStructure = fileStructure.findTestMethodStructureContainingOffset(caretOffset);
                PsiElement element = psiElement;
                if (testMethodStructure != null) {
                    element = testMethodStructure.getCallExpression();
                }
                if ((moduleStructureUnderCaret = fileStructure.findModuleStructureContainingOffset(caretOffset)) != null) {
                    element = moduleStructureUnderCaret.getEnclosingCallExpression();
                }
                int suitableCaretOffset = JsGeneratorUtils.findSuitableOffsetForNewStatement(element, caretOffset);
                context.getCaretModel().moveToOffset(suitableCaretOffset);
                String name = JsPsiUtils.wrapWithMostFrequentQuote(context.getJsFile(), "${test name}");
                Template template = JsGeneratorUtils.createDefaultTemplate("test(" + name + ", function() {|});");
                context.startTemplate(template);
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStructure";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/testFramework/qunit/codeInsight/QUnitGenerateNewTestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createGenerator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

