/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.grammar;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.PuppetParser;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.lexer.PuppetTokenTypeSets;
import com.intellij.lang.puppet.util.PuppetConfigurationUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PuppetParserUtil
extends GeneratedParserUtilBase
implements PuppetTokenTypes {
    private static final Set<String> ourIncludeFunctions = ContainerUtil.set((Object[])new String[]{"include", "require", "contain", "hiera_include"});

    public static PsiBuilder adapt_builder_(IElementType root, PsiBuilder builder, PsiParser parser, TokenSet[] tokenSets) {
        PsiBuilder result = GeneratedParserUtilBase.adapt_builder_((IElementType)root, (PsiBuilder)builder, (PsiParser)parser, (TokenSet[])tokenSets);
        GeneratedParserUtilBase.ErrorState.get((PsiBuilder)result).braces = null;
        return result;
    }

    public static boolean isPuppet4(@NotNull PsiBuilder builder, int level) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(0);
        }
        return PuppetConfigurationUtil.getPuppetVersion(builder.getProject()) == PuppetLanguage.Version.PUPPET_4;
    }

    public static boolean isPuppet3(@NotNull PsiBuilder builder, int level) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(1);
        }
        return PuppetConfigurationUtil.getPuppetVersion(builder.getProject()) == PuppetLanguage.Version.PUPPET_3;
    }

    public static boolean consumeOneToken(@NotNull PsiBuilder builder, int level) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(2);
        }
        if (builder.eof()) {
            return false;
        }
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.error(PuppetBundle.message("puppet.parser.unknown.token", new Object[0]));
        return true;
    }

    public static boolean checkNoSpaceBefore(@NotNull PsiBuilder builder, int level) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(3);
        }
        return builder.rawLookup(-1) != TokenType.WHITE_SPACE && builder.rawLookup(0) != TokenType.WHITE_SPACE;
    }

    public static boolean checkHasSpaceBefore(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser parser) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(4);
        }
        if (parser == null) {
            PuppetParserUtil.$$$reportNull$$$0(5);
        }
        if (builder.rawLookup(-1) != TokenType.WHITE_SPACE && builder.rawLookup(0) != TokenType.WHITE_SPACE) {
            return false;
        }
        return parser.parse(builder, level);
    }

    public static boolean myPinParse(@NotNull PsiBuilder builder, int level, @NotNull GeneratedParserUtilBase.Parser delegate) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(6);
        }
        if (delegate == null) {
            PuppetParserUtil.$$$reportNull$$$0(7);
        }
        PuppetParserUtil.report_error_((PsiBuilder)builder, (boolean)delegate.parse(builder, level));
        return true;
    }

    public static boolean isIncludeClassFunction(@NotNull PsiBuilder b, int l) {
        if (b == null) {
            PuppetParserUtil.$$$reportNull$$$0(8);
        }
        return b.getTokenType() == NAME && ourIncludeFunctions.contains(b.getTokenText());
    }

    public static boolean passHeredocBodies(@NotNull PsiBuilder builder, int level) {
        if (builder == null) {
            PuppetParserUtil.$$$reportNull$$$0(9);
        }
        if (!PuppetParserUtil.isPuppet4(builder, level)) {
            return false;
        }
        boolean hasFoundSmth = false;
        while (builder.getTokenType() == PuppetTokenTypes.HEREDOC_BODY || builder.getTokenType() == PuppetTokenTypes.HEREDOC_ENDING) {
            hasFoundSmth = true;
            builder.advanceLexer();
        }
        return hasFoundSmth;
    }

    public static boolean isKeyword(@NotNull PsiBuilder b, int l) {
        if (b == null) {
            PuppetParserUtil.$$$reportNull$$$0(10);
        }
        if (PuppetTokenTypeSets.KEYWORDS.contains(b.getTokenType())) {
            b.advanceLexer();
            return true;
        }
        return false;
    }

    public static boolean parseFileContents(@NotNull PsiBuilder b, int l, GeneratedParserUtilBase.Parser parser) {
        if (b == null) {
            PuppetParserUtil.$$$reportNull$$$0(11);
        }
        assert (b instanceof GeneratedParserUtilBase.Builder);
        assert (((GeneratedParserUtilBase.Builder)b).parser instanceof PuppetParser);
        return ((PuppetParser)((GeneratedParserUtilBase.Builder)b).parser).parseFileContents(b, l, parser);
    }

    public static boolean recoverParameter(@NotNull PsiBuilder b, int l, GeneratedParserUtilBase.Parser parser) {
        if (b == null) {
            PuppetParserUtil.$$$reportNull$$$0(12);
        }
        return ((PuppetParser)((GeneratedParserUtilBase.Builder)b).parser).recoverParameter(b, l, parser);
    }

    public static boolean recoverTypedParameter(@NotNull PsiBuilder b, int l, GeneratedParserUtilBase.Parser parser) {
        if (b == null) {
            PuppetParserUtil.$$$reportNull$$$0(13);
        }
        return ((PuppetParser)((GeneratedParserUtilBase.Builder)b).parser).recoverTypedParameter(b, l, parser);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/grammar/PuppetParserUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPuppet4";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPuppet3";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeOneToken";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNoSpaceBefore";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkHasSpaceBefore";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "myPinParse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isIncludeClassFunction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "passHeredocBodies";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isKeyword";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "parseFileContents";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "recoverParameter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "recoverTypedParameter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

