/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DatabaseViewActions;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DbStorageFileType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AddDataSourceFromPath
extends DumbAwareAction {
    final DatabaseViewActions.DataSourceFactory myFactory;

    public AddDataSourceFromPath(@Nls @NotNull String text2, @Nls @NotNull String desc, @NotNull Icon icon, @NotNull DatabaseViewActions.DataSourceFactory factory) {
        if (text2 == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(0);
        }
        if (desc == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(2);
        }
        if (factory == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(3);
        }
        super(text2, desc, icon);
        this.myFactory = factory;
    }

    @NotNull
    private static String getPath(@Nullable String base, @NotNull String path) {
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(4);
        }
        String string = base == null || FileUtil.isAbsolute((String)path) ? path : FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{base, path}));
        if (string == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getRelative(@Nullable String base, @NotNull String path) {
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(6);
        }
        String string = base == null ? path : (String)ObjectUtils.chooseNotNull((Object)FileUtil.getRelativePath((File)new File(base), (File)new File(path)), (Object)path);
        if (string == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    private static String chooseFile(@NotNull Project project, @Nullable String cur) {
        if (project == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(8);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false);
        descriptor.setTitle(DatabaseBundle.message((String)"data.source.from.path.location", (Object[])new Object[0]));
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, cur == null ? null : LocalFileSystem.getInstance().findFileByPath(cur));
        return file == null ? null : file.getCanonicalPath();
    }

    public static void newDataSourceFromFileInput(final @NotNull Project project, final @Nullable String basePath, final @NotNull String path, @NotNull DatabaseViewActions.DataSourceFactory factory, @Nullable String groupName) {
        if (project == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(9);
        }
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(10);
        }
        if (factory == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(11);
        }
        DatabaseViewActions.DataSourceFactory adjustedFactory = (facade, manager, dataSource2) -> {
            dataSource2.setGroupName(groupName);
            factory.create(facade, (DataSourceManager<LocalDataSource>)manager, dataSource2);
            VirtualFileManager.getInstance().refreshWithoutFileWatcher(true);
        };
        new AddDataSourceFromUrl.MyDialog(project, adjustedFactory){
            {
                super(project3, factory);
                this.setTitle(DatabaseBundle.message((String)"new.data.source.title", (Object[])new Object[0]));
                this.getNameLabel().setText(UIUtil.replaceMnemonicAmpersand((String)DatabaseBundle.message((String)"new.data.source.path", (Object[])new Object[0])));
                JComponent parent2 = (JComponent)this.getNameField().getParent();
                GridLayoutManager layout = (GridLayoutManager)parent2.getLayout();
                GridConstraints constraints = layout.getConstraintsForComponent((Component)this.getNameField());
                Box panel2 = new Box(0);
                panel2.add(this.getNameField());
                FixedSizeButton button = new FixedSizeButton((JComponent)this.getNameField());
                panel2.add((Component)button);
                parent2.add((Component)panel2, constraints);
                if (!StringUtil.isEmpty((String)path)) {
                    this.getNameField().setText(path);
                }
                button.setAction(new AbstractAction(null, AllIcons.General.Ellipsis){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String file = AddDataSourceFromPath.chooseFile(project, AddDataSourceFromPath.getPath(basePath, this.getNameField().getText()));
                        if (file == null) {
                            return;
                        }
                        this.getNameField().setText(AddDataSourceFromPath.getRelative(basePath, file));
                    }
                });
            }

            @Override
            @NotNull
            protected String buildUrlForDriver(@NotNull DatabaseDriver driver) {
                if (driver == null) {
                    1.$$$reportNull$$$0(0);
                }
                String string = AddDataSourceFromPath.buildUrl(driver, AddDataSourceFromPath.getPath(basePath, this.getNameField().getText()));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            protected boolean useClipboardText(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(2);
                }
                return StringUtil.isEmpty((String)path);
            }

            @Override
            @Nullable
            protected DatabaseDriver selectDriver(@NotNull String str) {
                if (str == null) {
                    1.$$$reportNull$$$0(3);
                }
                String fullPath = AddDataSourceFromPath.getPath(basePath, str);
                Dbms family = this.getFamily(LocalFileSystem.getInstance().findFileByPath(fullPath));
                if (family == null) {
                    return null;
                }
                for (DatabaseDriver driver : this.myDrivers) {
                    Dbms dbms = DbImplUtil.getDbms(driver);
                    if (family != dbms) continue;
                    return driver;
                }
                return null;
            }

            @Nullable
            private Dbms getFamily(@Nullable VirtualFile file) {
                if (file == null) {
                    return null;
                }
                DbStorageFileType dbType = (DbStorageFileType)((Object)ObjectUtils.tryCast((Object)file.getFileType(), DbStorageFileType.class));
                return dbType == null ? null : dbType.getDbms();
            }

            @Override
            @NotNull
            protected Collection<? extends DatabaseDriver> getDatabaseDrivers() {
                Collection<? extends DatabaseDriver> drivers = DatabaseDriverManager.getInstance().getDrivers();
                List list = ContainerUtil.filter(drivers, o -> AddDataSourceFromPath.isGoodLocations(o.getSupportedLocations()));
                if (list == null) {
                    1.$$$reportNull$$$0(4);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "driver";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromPath$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "str";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildUrlForDriver";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDatabaseDrivers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "buildUrlForDriver";
                        break;
                    }
                    case 1: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "useClipboardText";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "selectDriver";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }.show();
    }

    private static boolean isGoodLocations(@NotNull EnumSet<StatelessJdbcUrlParser.LocationType> locations) {
        if (locations == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(12);
        }
        return locations.contains((Object)StatelessJdbcUrlParser.LocationType.DIRECTORY) || locations.contains((Object)StatelessJdbcUrlParser.LocationType.FILE);
    }

    @NotNull
    private static String buildUrl(@NotNull DatabaseDriver driver, @NotNull String path) {
        if (driver == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(13);
        }
        if (path == null) {
            AddDataSourceFromPath.$$$reportNull$$$0(14);
        }
        for (StatelessJdbcUrlParser parser2 : driver.getJDBCUrlParsers()) {
            if (!AddDataSourceFromPath.isGoodLocations(parser2.getPossibleLocations())) continue;
            JdbcUrlParser stateful = parser2.createStateful();
            for (String p2 : stateful.getParameters()) {
                String val = p2.equals("file") || p2.equals("path") ? path : stateful.getParameterDefValue(p2);
                stateful.setParameter(p2, StringUtil.notNullize((String)val));
            }
            String string = stateful.getUrlText();
            if (string == null) {
                AddDataSourceFromPath.$$$reportNull$$$0(15);
            }
            return string;
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/AddDataSourceFromPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelative";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRelative";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseFile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "newDataSourceFromFileInput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isGoodLocations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Here
    extends AddDataSourceFromPath {
        public Here(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                Here.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message((String)"data.source.add.in.path.text", (Object[])new Object[0]), DatabaseBundle.message((String)"data.source.add.in.path.description", (Object[])new Object[0]), DatabaseIcons.Dbms, factory);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                Here.$$$reportNull$$$0(1);
            }
            IdeView view2 = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            boolean enabled = !ScratchUtil.isScratch((VirtualFile)((VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE))) && view2 != null && view2.getDirectories().length != 0;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            PsiDirectory directory;
            Project project;
            if (e == null) {
                Here.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            IdeView view2 = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            PsiDirectory psiDirectory = directory = view2 == null ? null : view2.getOrChooseDirectory();
            if (directory == null) {
                return;
            }
            Here.newDataSourceFromFileInput(project, directory.getVirtualFile().getCanonicalPath(), "new_file", this.myFactory, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath$Here";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FromThat
    extends AddDataSourceFromPath {
        public FromThat(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                FromThat.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message((String)"as.data.source.text", (Object[])new Object[0]), DatabaseBundle.message((String)"as.data.source.description", (Object[])new Object[0]), DatabaseIcons.Dbms, factory);
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            if (e == null) {
                FromThat.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            IdeView view2 = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            boolean bl = enabled = view2 != null && project != null;
            if (enabled) {
                VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
                enabled = files != null && files.length == 1 && files[0].isInLocalFileSystem() && files[0].getFileType() instanceof DbStorageFileType;
            }
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                FromThat.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
            if (files == null || files.length != 1) {
                return;
            }
            FromThat.newDataSourceFromFileInput(project, null, StringUtil.notNullize((String)files[0].getCanonicalPath()), this.myFactory, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath$FromThat";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FromDialog
    extends AddDataSourceFromPath {
        public FromDialog(@NotNull DatabaseViewActions.DataSourceFactory factory) {
            if (factory == null) {
                FromDialog.$$$reportNull$$$0(0);
            }
            super(DatabaseBundle.message((String)"data.source.from.path.text", (Object[])new Object[0]), DatabaseBundle.message((String)"data.source.from.path.description", (Object[])new Object[0]), AllIcons.Actions.Menu_open, factory);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                FromDialog.$$$reportNull$$$0(1);
            }
            boolean enabled = DatabaseViewActions.getDbFacade(e) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            DbPsiFacade facade;
            if (e == null) {
                FromDialog.$$$reportNull$$$0(2);
            }
            if ((facade = DatabaseViewActions.getDbFacade(e)) == null) {
                return;
            }
            String path = AddDataSourceFromPath.chooseFile(facade.getProject(), null);
            if (path == null) {
                return;
            }
            FromDialog.newDataSourceFromFileInput(facade.getProject(), null, path, this.myFactory, DatabaseViewActions.getDbGroupName(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/AddDataSourceFromPath$FromDialog";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

