/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringDialogHelper;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.database.view.ui.DbTableDialog;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseObjectRefactoring
extends BaseRefactoringAction
implements DumbAware {
    public static final DataKey<Consumer<AbstractDbRefactoringDialog>> INTERCEPTOR = DataKey.create((String)"DatabaseObjectRefactoring.INTERCEPTOR");

    @Nullable
    public static DasObject getDasObject(@Nullable PsiElement element2) {
        if (element2 instanceof DasObject) {
            return (DasObject)element2;
        }
        JBIterable<DasObject> elements = DataGridPomTarget.unwrapElements(element2);
        if (elements != null) {
            return (DasObject)elements.first();
        }
        DasObject res2 = DatabaseObjectRefactoring.getDasObject(element2 == null ? null : element2.getReference());
        if (res2 == null) {
            res2 = (DasObject)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiObject.class, (boolean)false);
        }
        return res2;
    }

    @Nullable
    public static DasObject getDasObject(@Nullable PsiReference ref) {
        return ref == null ? null : (DasObject)ObjectUtils.tryCast((Object)ref.resolve(), DasObject.class);
    }

    @Nullable
    public static DasObject getDasObject(@Nullable Editor editor, @Nullable PsiFile file) {
        DasObject res2 = null;
        if (file != null && editor != null && (res2 = DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(editor.getCaretModel().getOffset()))) == null) {
            res2 = DatabaseObjectRefactoring.getDasObject(file.findElementAt(editor.getCaretModel().getOffset()));
        }
        return res2;
    }

    @Nullable
    public static BasicElement getBasicElement(@Nullable DasObject object, @NotNull DatabaseEditorContext context) {
        BasicElement res2;
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(0);
        }
        if ((res2 = DatabaseObjectRefactoring.extractBasicElement(object)) != null) {
            return res2;
        }
        if (object instanceof SqlElement) {
            Map<? extends DasObject, SmartPsiElementPointer<SqlElement>> mapping = context.getMapping();
            if (mapping != null) {
                for (Map.Entry<? extends DasObject, SmartPsiElementPointer<SqlElement>> entry : mapping.entrySet()) {
                    if (!((SqlElement)object).isEquivalentTo(entry.getValue().getElement())) continue;
                    return (BasicElement)entry.getKey();
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static BasicElement extractBasicElement(@Nullable DasObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BasicElement) {
            return (BasicElement)object;
        }
        if (object instanceof DbElement) {
            Object delegate = ((DbElement)object).getDelegate();
            return delegate instanceof BasicElement ? (BasicElement)delegate : null;
        }
        return null;
    }

    @Nullable
    public static @Nullable Pair<@Nullable BasicElement, DatabaseEditorContext> prepareForEditing(@Nullable PsiElement place, @Nullable DasObject object) {
        SqlFile file;
        boolean isSql;
        DatabaseEditorContext context = null;
        boolean bl = isSql = object instanceof SqlElement || object instanceof RenameableFakePsiElement;
        if (object == null && (file = (SqlFile)ObjectUtils.tryCast((Object)(isSql ? ((PsiElement)object).getContainingFile() : place.getContainingFile()), SqlFile.class)) != null) {
            context = DatabaseEditorContext.forFile(file, false);
        }
        if (context == null && object != null) {
            context = DbRefactoringHelper.createContext(object, place, false);
        }
        if (context == null) {
            return null;
        }
        BasicElement element2 = DatabaseObjectRefactoring.getBasicElement(object, context);
        return Pair.create((Object)element2, (Object)context);
    }

    @Nullable
    public static PsiElement getPlace(@Nullable Editor editor, @Nullable PsiFile file) {
        return file != null && editor != null ? file.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    @Nullable
    public static DasObject getDasObject(@NotNull DataContext context) {
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        PsiElement element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        DasObject res2 = DatabaseObjectRefactoring.getDasObject(editor, file);
        if (res2 == null && element2 != null) {
            res2 = DatabaseObjectRefactoring.getDasObject(element2);
        }
        return res2;
    }

    @NotNull
    public static JBIterable<DasObject> getDasObjects(@NotNull DataContext context) {
        if (context == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(2);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        JBIterable res2 = JBIterable.empty();
        if (editor != null && file != null) {
            res2 = JBIterable.from((Iterable)editor.getCaretModel().getAllCarets()).filterMap(caret -> DatabaseObjectRefactoring.getDasObject(file.findReferenceAt(caret.getOffset())));
        }
        JBIterable jBIterable = res2.isEmpty() ? JBIterable.of((Object)DatabaseObjectRefactoring.getDasObject(context)) : res2;
        if (jBIterable == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    public boolean isAvailableInEditorOnly() {
        return false;
    }

    public boolean isEnabledOnElement(@NotNull PsiElement element2) {
        DasObject object;
        if (element2 == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(4);
        }
        if ((object = DatabaseObjectRefactoring.getDasObject(element2)) instanceof DbElement && !DbImplUtil.canModify((DbElement)object)) {
            return false;
        }
        DatabaseEditorContext context = object == null ? null : DbRefactoringHelper.createContext(object, element2, true);
        return context != null && DbRefactoringHelper.isTableOrEditableTableChild(object, context) && !DataImporter.isBusy(object);
    }

    protected boolean isAvailableForLanguage(Language language) {
        return language instanceof SqlLanguage;
    }

    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(5);
        }
        if (elements.length != 1) {
            return false;
        }
        return this.isEnabledOnElement(elements[0]);
    }

    private static void showDialog(@Nullable PsiElement place, @Nullable BasicElement object, @Nullable DatabaseEditorContext context, @Nullable Consumer<AbstractDbRefactoringDialog> interceptor) {
        if (object == null || context == null || !DbRefactoringHelper.isTableOrEditableTableChild(object, context)) {
            return;
        }
        DbTableDialog dialog2 = new DbTableDialog(context);
        AbstractDbRefactoringDialog.ResultProcessor proc = DbRefactoringHelper.getResultProcessor(object, dialog2, place);
        dialog2.setResultProcessor(proc);
        dialog2.configureForModification(object, DbRefactoringHelper.isForceCreate(object, context));
        DbRefactoringDialogHelper.bootstrap(dialog2, (Computable<? extends DeObject>)((Computable)() -> dialog2.export(object, true)));
        if (interceptor != null) {
            interceptor.consume((Object)dialog2);
        } else {
            dialog2.finishAndShow();
        }
    }

    @Nullable
    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(6);
        }
        return new RefactoringActionHandler(){

            public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
                Pair<BasicElement, DatabaseEditorContext> info;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((info = DatabaseObjectRefactoring.prepareForEditing(DatabaseObjectRefactoring.getPlace(editor, file), DatabaseObjectRefactoring.getDasObject(editor, file))) == null) {
                    return;
                }
                DatabaseObjectRefactoring.showDialog(DatabaseObjectRefactoring.getPlace(editor, file), (BasicElement)info.first, (DatabaseEditorContext)info.second, (Consumer<AbstractDbRefactoringDialog>)((Consumer)INTERCEPTOR.getData(dataContext)));
            }

            public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elements == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (elements.length != 1) {
                    return;
                }
                Pair<BasicElement, DatabaseEditorContext> info = DatabaseObjectRefactoring.prepareForEditing(elements[0], DatabaseObjectRefactoring.getDasObject(elements[0]));
                if (info == null) {
                    return;
                }
                DatabaseObjectRefactoring.showDialog(elements[0], (BasicElement)info.first, (DatabaseEditorContext)info.second, (Consumer<AbstractDbRefactoringDialog>)((Consumer)INTERCEPTOR.getData(dataContext)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "elements";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/actions/DatabaseObjectRefactoring$1";
                objectArray[2] = "invoke";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static String getDesc(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(7);
        }
        String string = DatabaseBundle.message((String)"action.DatabaseObjectRefactoring.desc", (Object[])new Object[]{DatabaseObjectRefactoring.getKindTitle(kind)});
        if (string == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String getKindTitle(@NotNull ObjectKind kind) {
        if (kind == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(9);
        }
        String string = StringUtil.capitalizeWords((String)StringUtil.toLowerCase((String)kind.toString().replaceAll("[-_]", " ")), (boolean)true);
        if (string == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DatabaseObjectRefactoring.$$$reportNull$$$0(11);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        if (presentation.isEnabled()) {
            DasObject object = DatabaseObjectRefactoring.getDasObject(e.getDataContext());
            if (object != null) {
                presentation.setText(DatabaseObjectRefactoring.getDesc(object.getKind()));
            }
        } else {
            presentation.setVisible(false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/DatabaseObjectRefactoring";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/DatabaseObjectRefactoring";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasObjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesc";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBasicElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDasObject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDasObjects";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDesc";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getKindTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

