/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.actions.CodeInsightEditorAction;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.csv.CsvFileType;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolver;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.csv.ui.FormatsListAndPreviewPanel;
import com.intellij.database.csv.ui.preview.TableCsvFormatPreview;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.editor.CsvTableFileEditorProvider;
import com.intellij.database.editor.FragmentTableFileEditorProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditAsTableAction
extends DumbAwareAction {
    private static final String CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY = "editAsTableFormatDialogDimension";

    public void beforeActionPerformedUpdate(@NotNull AnActionEvent e) {
        if (e == null) {
            EditAsTableAction.$$$reportNull$$$0(0);
        }
        CodeInsightEditorAction.beforeActionPerformedUpdate((AnActionEvent)e);
        super.beforeActionPerformedUpdate(e);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isDml;
        boolean visible;
        String place;
        if (e == null) {
            EditAsTableAction.$$$reportNull$$$0(1);
        }
        Editor editor = "ContextToolbar".equals(place = e.getPlace()) ? (Editor)e.getData(CommonDataKeys.EDITOR) : EditAsTableAction.getEditor(e);
        VirtualFile fileFromEditor = editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
        VirtualFile file = fileFromEditor == null ? EditAsTableAction.getFileFromDataGrid(e) : fileFromEditor;
        Project project = e.getProject();
        if (project == null || file == null) {
            e.getPresentation().setText(this.getTemplatePresentation().getText());
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if ("ContextToolbar".equals(place)) {
            visible = FileTypeManager.getInstance().isFileOfType(file, (FileType)CsvFileType.INSTANCE);
            isDml = false;
        } else {
            boolean isCsv;
            Language language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
            TextRange selection = EditAsTableAction.getSelection(editor);
            boolean oneToken = selection != null && EditAsTableAction.isOneTokenSelection(editor, selection);
            isDml = selection != null && language instanceof SqlLanguageDialect;
            boolean bl = isCsv = language != null && language.isKindOf((Language)PlainTextLanguage.INSTANCE);
            if (isDml && oneToken) {
                isDml = false;
                isCsv = true;
            }
            boolean bl2 = visible = isDml || isCsv || !"EditorPopup".equals(place);
        }
        String text2 = fileFromEditor == null ? DatabaseBundle.message((String)"action.FileEditor.ChangeFormat.text", (Object[])new Object[0]) : this.getTemplatePresentation().getText() + (isDml ? "" : "...");
        e.getPresentation().setText(text2);
        e.getPresentation().setEnabled(true);
        e.getPresentation().setVisible(visible);
    }

    public static int getPreviewCharacterCount() {
        return Registry.intValue((String)"database.csv.preview.char.count", (int)10000);
    }

    @Nullable
    private static VirtualFile getFileFromDataGrid(AnActionEvent e) {
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        DocumentDataHookUp up = grid == null ? null : DataGridUtil.getDocumentDataHookUp(grid);
        return up instanceof CsvDocumentDataHookUp ? FileDocumentManager.getInstance().getFile(up.getDocument()) : null;
    }

    @Nullable
    private static Editor getEditor(AnActionEvent e) {
        Project project = e.getProject();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null && project != null) {
            return (Editor)ObjectUtils.chooseNotNull((Object)BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor, (boolean)false), (Object)editor);
        }
        return editor;
    }

    private static boolean isOneTokenSelection(@NotNull Editor e, @NotNull TextRange r) {
        if (e == null) {
            EditAsTableAction.$$$reportNull$$$0(2);
        }
        if (r == null) {
            EditAsTableAction.$$$reportNull$$$0(3);
        }
        if (e.getProject() == null) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)e.getProject()).getPsiFile(e.getDocument());
        if (file == null) {
            return false;
        }
        PsiElement elem = file.findElementAt(r.getStartOffset() + r.getLength() / 2);
        if (elem == null) {
            return false;
        }
        return elem.getTextRange().contains(r);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Language language;
        Document document;
        if (e == null) {
            EditAsTableAction.$$$reportNull$$$0(4);
        }
        String place = e.getPlace();
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Editor editor = "ContextToolbar".equals(place) ? (Editor)e.getData(CommonDataKeys.EDITOR) : EditAsTableAction.getEditor(e);
        VirtualFile fileFromEditor = editor == null ? null : FileDocumentManager.getInstance().getFile(editor.getDocument());
        VirtualFile file = fileFromEditor == null ? EditAsTableAction.getFileFromDataGrid(e) : fileFromEditor;
        Document document2 = document = file == null ? null : FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return;
        }
        TextRange selection = EditAsTableAction.getSelection(editor);
        if (selection != null && (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file)) instanceof SqlLanguageDialect && !EditAsTableAction.isOneTokenSelection(editor, selection)) {
            FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection, (SqlLanguageDialect)language);
            return;
        }
        CsvFormat format = this.showDataFormatEditorDialog(project, file, document, selection);
        if (format != null) {
            IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> {
                if (selection == null && file instanceof VirtualFileWithId && (EditorUtil.isRealFileEditor((Editor)editor) || fileFromEditor == null)) {
                    CsvTableFileEditorProvider.openEditor(project, file, format);
                } else {
                    FragmentTableFileEditorProvider.openFragmentEditor(project, file, selection == null ? TextRange.from((int)0, (int)document.getTextLength()) : selection, format);
                }
            });
        }
    }

    @Nullable
    private static TextRange getSelection(@Nullable Editor editor) {
        if (editor == null) {
            return null;
        }
        TextRange range = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (range.isEmpty()) {
            if (editor.getProject() == null) {
                return null;
            }
            SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(editor.getDocument()), SqlFile.class);
            if (file == null || !file.getSqlLanguage().getDbms().isPostgres()) {
                return null;
            }
            PsiElement element2 = file.findElementAt(editor.getCaretModel().getOffset());
            IElementType type = element2 == null ? null : element2.getNode().getElementType();
            return type != null && type.toString().equals("#SQL_RAW_INPUT") ? element2.getTextRange() : null;
        }
        return range.isEmpty() ? null : range;
    }

    @Nullable
    private CsvFormat showDataFormatEditorDialog(@NotNull Project project, @NotNull VirtualFile file, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            EditAsTableAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            EditAsTableAction.$$$reportNull$$$0(6);
        }
        if (document == null) {
            EditAsTableAction.$$$reportNull$$$0(7);
        }
        Disposable disposable2 = Disposer.newDisposable();
        String text2 = range == null ? EditAsTableAction.getLimitedText(document) : range.subSequence(document.getCharsSequence()).toString();
        CsvFormatsSelectionUI formatsForm = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable2);
        CsvFormat format = CsvFormatResolver.getFormat(project, file, CsvFormatResolver.FormatGetter.STATE, CsvFormatResolver.FormatGetter.FILE, CsvFormatResolver.FormatGetter.CONTENT);
        formatsForm.select(format);
        CsvFormat selectedFormat = formatsForm.getSelectedFormat();
        TableCsvFormatPreview preview = new TableCsvFormatPreview(project, Objects.requireNonNull(selectedFormat), text2, disposable2);
        FormatsListAndPreviewPanel panel2 = new FormatsListAndPreviewPanel(formatsForm, preview);
        panel2.setPreferredSize((Dimension)JBUI.size((int)800, (int)600));
        DialogBuilder dialog2 = new DialogBuilder(project).title(this.getTemplatePresentation().getText() + ": '" + file.getName() + "'" + (range != null ? " Fragment" : "") + " Format").centerPanel((JComponent)panel2).dimensionKey(CSV_FORMAT_DIALOG_DIMENSION_SERVICE_KEY);
        dialog2.setHelpId("edit.as.table.format.configuration.dialog");
        Disposer.register((Disposable)dialog2, (Disposable)disposable2);
        return dialog2.showAndGet() ? formatsForm.getSelectedFormat() : null;
    }

    @NotNull
    private static String getLimitedText(@NotNull Document document) {
        if (document == null) {
            EditAsTableAction.$$$reportNull$$$0(8);
        }
        String string = document.getText().substring(0, Math.min(document.getTextLength(), EditAsTableAction.getPreviewCharacterCount()));
        if (string == null) {
            EditAsTableAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/EditAsTableAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/EditAsTableAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLimitedText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformedUpdate";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOneTokenSelection";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDataFormatEditorDialog";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLimitedText";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

