/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.DbConsoleRootType;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.intentions.RunQueryInConsoleIntentionAction;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OpenConsoleAction
extends DumbAwareAction {
    public OpenConsoleAction() {
        super(DatabaseIcons.ConsoleRun);
    }

    public void update(@NotNull AnActionEvent e) {
        JBIterable<DbElement> elements;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(0);
        }
        boolean enabled = !(elements = OpenConsoleAction.getElements(e)).filterMap(o -> DbImplUtil.getMaybeLocalDataSource((DasDataSource)o.getDataSource())).isEmpty();
        boolean visible = enabled || e.isFromActionToolbar();
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(1);
        }
        JBIterable<DbElement> elements = OpenConsoleAction.getElements(e);
        List namespaces = elements.filterMap(o -> (DbElement)JBIterable.generate((Object)o, p2 -> p2.getParent()).filter(p2 -> p2 instanceof DasNamespace || p2 instanceof DasDataSource).first()).unique().filter(o -> DbImplUtil.getMaybeLocalDataSource((DasDataSource)o.getDataSource()) != null).toList();
        this.actionPerformedInner(e, namespaces);
    }

    protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
        Project project;
        if (e == null) {
            OpenConsoleAction.$$$reportNull$$$0(2);
        }
        if (namespaces == null) {
            OpenConsoleAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List<PersistenceConsoleProvider.Runner> runners = OpenConsoleAction.getRunners(project, namespaces);
        RunQueryInConsoleIntentionAction.chooseAndRunRunners(DatabaseBundle.message((String)"action.Jdbc.OpenConsole.consoles", (Object[])new Object[0]), runners, (Editor)e.getData(CommonDataKeys.EDITOR), e);
    }

    @NotNull
    private static List<PersistenceConsoleProvider.Runner> getRunners(@NotNull Project project, @NotNull List<DbElement> namespaces) {
        if (project == null) {
            OpenConsoleAction.$$$reportNull$$$0(4);
        }
        if (namespaces == null) {
            OpenConsoleAction.$$$reportNull$$$0(5);
        }
        JBIterable namespacesIt = JBIterable.from(namespaces);
        DbElement single = (DbElement)namespacesIt.single();
        Set allowedIds = namespacesIt.map(o -> o.getDataSource().getUniqueId()).toSet();
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        PairConsumer consumer2 = (element2, file) -> {
            DasNamespace namespace = (DasNamespace)ObjectUtils.tryCast((Object)element2, DasNamespace.class);
            DatabaseEditorHelper.openConsoleForFile(project, (DasDataSource)element2.getDataSource(), namespace, file);
        };
        for (JdbcConsole console : JdbcConsoleProvider.getRunningConsoles(project)) {
            if (!allowedIds.contains(console.getDataSource().getUniqueId()) || !DbConsoleRootType.isConsoleFile(console.getVirtualFile())) continue;
            result.add(DatabaseRunners.createConsoleRunner(console, () -> consumer2.consume((Object)single, (Object)console.getVirtualFile())));
        }
        if (single != null) {
            result.addAll(DatabaseRunners.createDataSourceConsolesRunner(single.getDataSource(), (Consumer<? super VirtualFile>)((Consumer)file -> consumer2.consume((Object)single, file))).getSubRunners());
        } else {
            namespacesIt.unique(o -> o.getDataSource()).map(o -> DatabaseRunners.createDataSourceConsolesRunner(o.getDataSource(), (Consumer<? super VirtualFile>)((Consumer)file -> consumer2.consume(o, file)))).addAllTo(result);
        }
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            OpenConsoleAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static JBIterable<DbElement> getElements(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                OpenConsoleAction.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable byPsi = JBIterable.of((Object[])((Object[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY))).filterMap(psi -> {
            if (psi instanceof DbElement) {
                return (DbElement)psi;
            }
            if (psi instanceof DatabaseStructure.FamilyGroup) {
                return (DbElement)psi.getParent();
            }
            return null;
        });
        JBIterable byFile = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filterMap(file -> {
            if (file instanceof DatabaseElementVirtualFileImpl) {
                return ((DatabaseElementVirtualFileImpl)((Object)file)).findElement(project);
            }
            if (DbConsoleRootType.isConsoleFile(file)) {
                return DbConsoleRootType.getDataSource(project, file);
            }
            return null;
        });
        JBIterable jBIterable = byPsi.append((Iterable)byFile);
        if (jBIterable == null) {
            OpenConsoleAction.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/OpenConsoleAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformedInner";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CreateNew
    extends OpenConsoleAction {
        @Override
        protected void actionPerformedInner(@NotNull AnActionEvent e, @NotNull List<DbElement> namespaces) {
            if (e == null) {
                CreateNew.$$$reportNull$$$0(0);
            }
            if (namespaces == null) {
                CreateNew.$$$reportNull$$$0(1);
            }
            for (DbElement namespace : namespaces) {
                DatabaseEditorHelper.openConsoleFile(namespace, true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "namespaces";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/actions/OpenConsoleAction$CreateNew";
            objectArray[2] = "actionPerformedInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

