/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.SchemaScripts;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunExtensionScriptActionGroup
extends ActionGroup
implements DumbAware {
    private static final String SCRIPTS_DIRECTORY = "schema";

    @NotNull
    protected String getScriptsDirectory() {
        return SCRIPTS_DIRECTORY;
    }

    @NotNull
    protected PluginId getPluginId() {
        PluginId pluginId = DatabasePluginId.get();
        if (pluginId == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(0);
        }
        return pluginId;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(SchemaScripts.areAvailableIn(e.getDataContext()));
    }

    @NotNull
    public @NotNull AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = (AnAction[])StreamEx.of(SchemaScripts.getScriptFiles(this.getPluginId(), this.getScriptsDirectory())).map(x$0 -> new RunScriptAction((File)x$0)).toArray((Object[])AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            RunExtensionScriptActionGroup.$$$reportNull$$$0(2);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/RunExtensionScriptActionGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RunScriptAction
    extends DumbAwareAction {
        private final File myScript;

        private RunScriptAction(File script) {
            if (script == null) {
                RunScriptAction.$$$reportNull$$$0(0);
            }
            super(StringUtil.escapeMnemonics((String)script.getName()), DatabaseBundle.message((String)"action.RunScriptAction.description", (Object[])new Object[0]), null);
            this.myScript = script;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RunScriptAction.$$$reportNull$$$0(1);
            }
            SchemaScripts.runScript(e.getDataContext(), this.myScript, RunExtensionScriptActionGroup.this.getPluginId());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "script";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/actions/RunExtensionScriptActionGroup$RunScriptAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EditScriptsAction
    extends DumbAwareAction {
        private EditScriptsAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile virtualFile;
            Project project;
            if (e == null) {
                EditScriptsAction.$$$reportNull$$$0(0);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            File dir = SchemaScripts.getScriptsDirectory(DatabasePluginId.get(), RunExtensionScriptActionGroup.SCRIPTS_DIRECTORY);
            VirtualFile virtualFile2 = virtualFile = dir == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            if (virtualFile == null) {
                return;
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/RunExtensionScriptActionGroup$EditScriptsAction", "actionPerformed"));
        }
    }
}

