/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.template.TextDecomposition;
import com.intellij.database.dataSource.url.ui.CheckBoxParamEditor;
import com.intellij.database.dataSource.url.ui.ComboBoxParamEditor;
import com.intellij.database.dataSource.url.ui.DatabaseParamEditor;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypesRegistry
implements TextDecomposition.PatternFactory {
    private static final ExtensionPointName<TypeDescriptorFactory> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.urlParamEditorProvider");
    public static final TypesRegistry INSTANCE = new TypesRegistry();
    public static final String HOST_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String IPV6_COLON_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}";
    public static final String IPV6_DOT_QUAD_PATTERN = "(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    public static final String IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}";
    public static final String HOST_N_IPV6_PATTERN = "(?:\\p{XDigit}{0,4}:){0,7}\\p{XDigit}{1,4}|(?:\\p{XDigit}{0,4}:){1,6}\\p{Digit}{1,3}(?:\\.\\p{Digit}{1,3}){3}|[\\p{L}\\p{M}\\p{N}[-_.]]+";
    public static final String PARAMETER_PATTERN = "[^;=&]+";
    public static final String PORT_PATTERN = "[\\p{N}]{1,5}";
    public static final String DB_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    public static final String FILE_PATH_PATTERN = "(?!//)[^;?&]+?|/";
    public static final String USER_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    public static final String PASSWORD_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    public static final String PATH_PATTERN = "(?!//)[^;?&]+?|/";
    public static final String IDENTIFIER_PATTERN = "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+";
    private final Map<String, TypeDescriptor> myTypes = new HashMap<String, TypeDescriptor>();

    private TypesRegistry() {
        this.put(new TextFieldTypeDescriptor("identifier", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", "Identifier"));
        this.put(new TextFieldTypeDescriptor("param", PARAMETER_PATTERN, "Parameter"));
        this.put(new TextFieldTypeDescriptor("user", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", "User"));
        this.put(new TextFieldTypeDescriptor("password", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", "Password"));
        this.put(new TextFieldTypeDescriptor("host", HOST_PATTERN, "Host"));
        this.put(new TextFieldTypeDescriptor("host_ipv6", HOST_N_IPV6_PATTERN, "Host"));
        this.put(new TextFieldTypeDescriptor("ipv6", IPV6_PATTERN, "Host"));
        this.put(new TextFieldTypeDescriptor("port", PORT_PATTERN, "Port", ParamEditor.FieldSize.SMALL, new AnAction[0]));
        this.put(new DatabaseTypeDescriptor("database", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", "Database"));
        this.put(new TextFieldTypeDescriptor("file", "(?!//)[^;?&]+?|/", "File", ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbAction(true), TypesRegistry.getCreateDbAction()));
        this.put(new TextFieldTypeDescriptor("path", "(?!//)[^;?&]+?|/", "Path", ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbAction(false)));
        this.put(new TextFieldTypeDescriptor("path_db", "(?!//)[^;?&]+?|/", "Path", ParamEditor.FieldSize.LARGE, TypesRegistry.getSelectDbPathFileAction()));
        this.put(new TextCBTypeDescriptor("true_box", "true", "", "[\\p{L}\\p{M}\\p{N}[-_.#+$]]+", "true", "false|", "True box"));
        this.put(new ComboBoxTypeDescriptor("variants", "Variants"));
        for (TypeDescriptorFactory factory : (TypeDescriptorFactory[])EP_NAME.getExtensions()) {
            factory.createTypeDescriptor((Consumer<? super TypeDescriptor>)((Consumer)o -> this.put((TypeDescriptor)o)));
        }
    }

    @Override
    @Nullable
    public Pattern getPattern(@NotNull String type, @Nullable String configuration, @Nullable String patternOverride) {
        TypeDescriptor descriptor;
        if (type == null) {
            TypesRegistry.$$$reportNull$$$0(0);
        }
        return (descriptor = this.get(type)) == null ? null : descriptor.getPattern(configuration, patternOverride);
    }

    public void put(@NotNull TypeDescriptor desc) {
        if (desc == null) {
            TypesRegistry.$$$reportNull$$$0(1);
        }
        TypeDescriptor prev = this.myTypes.put(desc.getName(), desc);
        assert (prev == null);
    }

    @Nullable
    public TypeDescriptor get(@NotNull String type) {
        if (type == null) {
            TypesRegistry.$$$reportNull$$$0(2);
        }
        type = StringUtil.trimStart((String)type, (String)"#");
        return this.myTypes.get(type);
    }

    public static AnAction getSelectDbPathFileAction() {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, false);
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Choose Database File Or Path");
        return new ParamEditorBase.FMChooseAction(descriptor){

            @Override
            protected void setFile(@NotNull ParamEditorBase editor, @NotNull VirtualFile file) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file.isDirectory()) {
                    super.setFile(editor, file);
                    return;
                }
                editor.setText(file.getParent().getPath());
                editor.getInterchange().putProperty("database", file.getNameWithoutExtension());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/dataSource/url/TypesRegistry$1";
                objectArray[2] = "setFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static AnAction getSelectDbAction(boolean file) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(file, !file, false, false, false, false);
        descriptor.setHideIgnored(false);
        descriptor.setTitle("Choose Database " + (file ? "File" : "Path"));
        return new ParamEditorBase.FMChooseAction(descriptor);
    }

    private static AnAction getCreateDbAction() {
        FileSaverDescriptor descriptor = new FileSaverDescriptor("New Database", "Choose database file path and name", new String[0]);
        return new ParamEditorBase.FMSaveAction(descriptor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "get";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class BaseTypeDescriptor
    implements TypeDescriptor {
        private final String myRegex;
        private final String myName;
        private final String myDefaultCaption;

        protected BaseTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(2);
            }
            this.myRegex = regex;
            this.myName = name;
            this.myDefaultCaption = defaultCaption;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        protected static String formatFieldCaption(@NotNull String caption) {
            if (caption == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(4);
            }
            String string = caption + ":";
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        protected String formatCaption(@NotNull String param) {
            if (param == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(6);
            }
            String string = param.equals(this.myName) ? this.myDefaultCaption : StringUtil.capitalize((String)param);
            if (string == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public ParamEditor createField(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(8);
            }
            if (interchange == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(9);
            }
            ParamEditor paramEditor = this.createFieldImpl(this.formatCaption(caption), configuration, interchange);
            if (paramEditor == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(10);
            }
            return paramEditor;
        }

        @NotNull
        protected abstract ParamEditor createFieldImpl(@NotNull String var1, @Nullable String var2, @NotNull DataInterchange var3);

        @Override
        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange interchange) {
            if (interchange == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(11);
            }
            List<ParamEditor> list = Collections.emptyList();
            if (list == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(12);
            }
            return list;
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration, @Nullable String patternOverride) {
            Pattern pattern = Pattern.compile(patternOverride != null ? patternOverride : this.myRegex);
            if (pattern == null) {
                BaseTypeDescriptor.$$$reportNull$$$0(13);
            }
            return pattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "param";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$BaseTypeDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatFieldCaption";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "formatCaption";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createField";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createSatellites";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 13: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "formatFieldCaption";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "formatCaption";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createField";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createSatellites";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: 
                case 10: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DatabaseTypeDescriptor
    extends BaseTypeDescriptor {
        DatabaseTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(2);
            }
            super(name, regex, defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            DatabaseDialectEx dialect;
            if (caption == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(3);
            }
            if (interchange == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(4);
            }
            if (!(dialect = DbImplUtil.getDatabaseDialect(DbImplUtil.getDbms(interchange.getDriver()))).supportsLoadDatabaseList()) {
                return new TextParamEditor(interchange, DatabaseTypeDescriptor.formatFieldCaption(caption), ParamEditor.FieldSize.MEDIUM, new AnAction[0]);
            }
            return new DatabaseParamEditor(DatabaseTypeDescriptor.formatFieldCaption(caption), interchange);
        }

        @Override
        @NotNull
        public ParamEditor createField(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(5);
            }
            if (interchange == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(6);
            }
            if (configuration != null) {
                caption = configuration;
            }
            ParamEditor paramEditor = super.createField(caption, configuration, interchange);
            if (paramEditor == null) {
                DatabaseTypeDescriptor.$$$reportNull$$$0(7);
            }
            return paramEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$DatabaseTypeDescriptor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createField";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldImpl";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createField";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TextFieldTypeDescriptor
    extends BaseTypeDescriptor {
        private final ParamEditor.FieldSize myFieldSize;
        private final AnAction[] myActions;

        TextFieldTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption) {
            if (name == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (defaultCaption == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(2);
            }
            this(name, regex, defaultCaption, ParamEditor.FieldSize.MEDIUM, new AnAction[0]);
        }

        TextFieldTypeDescriptor(@NotNull String name, @NotNull String regex, @NotNull String defaultCaption, @NotNull ParamEditor.FieldSize fieldSize, AnAction ... actions) {
            if (name == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(3);
            }
            if (regex == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(4);
            }
            if (defaultCaption == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(5);
            }
            if (fieldSize == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(6);
            }
            if (actions == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(7);
            }
            super(name, regex, defaultCaption);
            this.myActions = actions;
            this.myFieldSize = fieldSize;
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(8);
            }
            if (interchange == null) {
                TextFieldTypeDescriptor.$$$reportNull$$$0(9);
            }
            return new TextParamEditor(interchange, TextFieldTypeDescriptor.formatFieldCaption(caption), this.myFieldSize, this.myActions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldSize";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$TextFieldTypeDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFieldImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TextCBTypeDescriptor
    extends BaseTypeDescriptor {
        private final String myTrueValue;
        private final String myFalseValue;
        private final Pattern myTrueRegexp;
        private final Pattern myFalseRegexp;

        TextCBTypeDescriptor(@NotNull String name, @NotNull String trueValue, @NotNull String falseValue, @NotNull String regex, @NotNull String trueRegex, @NotNull String falseRegex, @NotNull String defaultCaption) {
            if (name == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (trueValue == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(1);
            }
            if (falseValue == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(2);
            }
            if (regex == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(3);
            }
            if (trueRegex == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(4);
            }
            if (falseRegex == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(5);
            }
            if (defaultCaption == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(6);
            }
            super(name, regex, defaultCaption);
            this.myTrueValue = trueValue;
            this.myFalseValue = falseValue;
            this.myTrueRegexp = PatternBuilder.compile(trueRegex);
            this.myFalseRegexp = PatternBuilder.compile(falseRegex);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(7);
            }
            if (interchange == null) {
                TextCBTypeDescriptor.$$$reportNull$$$0(8);
            }
            return new CheckBoxParamEditor(interchange, caption, this.myTrueValue, this.myFalseValue, this.myTrueRegexp, this.myFalseRegexp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueRegex";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseRegex";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$TextCBTypeDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFieldImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ComboBoxTypeDescriptor
    extends BaseTypeDescriptor {
        ComboBoxTypeDescriptor(@NotNull String name, @NotNull String defaultCaption) {
            if (name == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(0);
            }
            if (defaultCaption == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(1);
            }
            super(name, "", defaultCaption);
        }

        @Override
        @NotNull
        protected ParamEditor createFieldImpl(@NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
            if (caption == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(2);
            }
            if (interchange == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(3);
            }
            return new ComboBoxParamEditor(interchange, ComboBoxTypeDescriptor.formatFieldCaption(caption), configuration);
        }

        @Override
        @NotNull
        public Pattern getPattern(@Nullable String configuration, @Nullable String patternOverride) {
            Pattern pattern = ComboBoxParamEditor.getPattern(configuration);
            Pattern pattern2 = pattern == null ? super.getPattern(configuration, patternOverride) : pattern;
            if (pattern2 == null) {
                ComboBoxTypeDescriptor.$$$reportNull$$$0(4);
            }
            return pattern2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultCaption";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caption";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interchange";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/url/TypesRegistry$ComboBoxTypeDescriptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createFieldImpl";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface TypeDescriptorFactory {
        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptor> var1);
    }

    public static interface TypeDescriptor {
        @NotNull
        public String getName();

        @NotNull
        public ParamEditor createField(@NotNull String var1, @Nullable String var2, @NotNull DataInterchange var3);

        @NotNull
        public Collection<ParamEditor> createSatellites(@NotNull DataInterchange var1);

        @NotNull
        public Pattern getPattern(@Nullable String var1, @Nullable String var2);
    }

    public static interface ParamEditor
    extends Disposable {
        @NotNull
        public String getText();

        public void setText(@NotNull String var1);

        public void addFocusListener(@NotNull FocusListener var1);

        @NotNull
        public JComponent getComponent();

        @Nullable
        public String getCaption();

        public FieldSize getFieldSize();

        public void setChangeListener(@NotNull Runnable var1);

        public JComponent getEditorComponent();

        public static enum FieldSize {
            SMALL,
            MEDIUM,
            LARGE;

        }
    }
}

