/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.DomainWrapper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPositionWidget;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.MutationType;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.DatabaseDialects;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.TransactionAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridScrollPositionManager;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarInfo;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridUtil {
    public static final Logger LOG = Logger.getInstance(DataGridUtil.class);
    public static final int CSV_VALUE_SQL_TYPE = 239;
    public static final String FAILED_TO_LOAD_PREFIX = "<failed to load>";

    private DataGridUtil() {
    }

    @Nullable
    public static DataGrid getDataGrid(DataContext dataContext) {
        FileEditor editor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
        if (editor instanceof TableEditorBase) {
            return ((TableEditorBase)editor).getDataGrid();
        }
        return (DataGrid)DatabaseDataKeys.DATA_GRID_KEY.getData(dataContext);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(0);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(1);
        }
        if (popupActions == null) {
            DataGridUtil.$$$reportNull$$$0(2);
        }
        return DataGridUtil.createDataGrid(project, dataHookUp, popupActions, true);
    }

    @NotNull
    public static DataGrid createDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp, @NotNull ActionGroup popupActions, boolean installListeners) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(3);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(4);
        }
        if (popupActions == null) {
            DataGridUtil.$$$reportNull$$$0(5);
        }
        TableResultPanel panel2 = new TableResultPanel(project, dataHookUp, popupActions);
        if (installListeners) {
            panel2.installDataHookUpListeners();
        }
        TableResultPanel tableResultPanel = panel2;
        if (tableResultPanel == null) {
            DataGridUtil.$$$reportNull$$$0(6);
        }
        return tableResultPanel;
    }

    public static DataGrid createPreviewDataGrid(@NotNull Project project, @NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> dataHookUp) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(7);
        }
        if (dataHookUp == null) {
            DataGridUtil.$$$reportNull$$$0(8);
        }
        ActionGroup popup = (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.Csv.PreviewPopupGroup");
        return new TableResultPanel(project, dataHookUp, popup, popup, ActionGroup.EMPTY_GROUP, ActionGroup.EMPTY_GROUP, null, false);
    }

    @NotNull
    public static ModelIndex<DataConsumer.Column> findColumn(@NotNull DataGrid dataGrid, @Nullable String name) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(9);
        }
        GridModel gridModel = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        for (ModelIndex c2 : gridModel.getColumnIndices().asIterable()) {
            DataConsumer.Column column = (DataConsumer.Column)gridModel.getColumn(c2);
            if (column == null || !Comparing.strEqual((String)name, (String)column.name)) continue;
            ModelIndex modelIndex = c2;
            if (modelIndex == null) {
                DataGridUtil.$$$reportNull$$$0(10);
            }
            return modelIndex;
        }
        ModelIndex<DataConsumer.Column> modelIndex = ModelIndex.forColumn(dataGrid, -1);
        if (modelIndex == null) {
            DataGridUtil.$$$reportNull$$$0(11);
        }
        return modelIndex;
    }

    public static void updateWidgets(@Nullable DataGrid grid) {
        GridPositionWidget.Listener listener2 = (GridPositionWidget.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GridPositionWidget.TOPIC);
        if (grid == null) {
            listener2.closed();
            return;
        }
        listener2.changed(grid);
    }

    @NotNull
    public static String getSqlType(@NotNull DataGrid grid, @Nullable DataConsumer.Column column) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(12);
        }
        if (column == null) {
            return "";
        }
        String typeNameSafe = StringUtil.notNullize((String)column.typeName);
        DatabaseGridDataHookUp hookUp = DataGridUtil.getDatabaseHookUp(grid);
        if (hookUp == null) {
            String string = typeNameSafe;
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column);
        if (dasColumn != null) {
            String string = dasColumn.getDataType().getSpecification();
            if (string == null) {
                DataGridUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        DataType type = DataTypeFactory.of(column.schema, typeNameSafe, column.precision, column.scale, null, null, false, false, column.type);
        String string = hookUp.getDatabaseDialect().getTypeName(type);
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    public static void focusDataGrid(DataGrid grid) {
        if (grid != null) {
            JComponent toFocus = grid.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)toFocus).requestFocus((Component)toFocus, true);
        }
    }

    public static void setupProgressIndicatingAuditor(final @NotNull DataGrid grid) {
        DataRequest.OwnerEx ownerEx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(16);
        }
        if ((ownerEx = (DataRequest.OwnerEx)ObjectUtils.tryCast(grid.getDataHookup(), DataRequest.OwnerEx.class)) == null) {
            return;
        }
        ownerEx.getMessageBus().addAuditor(new DataAuditor.Adapter(){

            @Override
            public void print(@NotNull DataRequest.Context context, @Nullable String message2) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (message2 != null && message2.contains("retrieved starting")) {
                    return;
                }
                ((StatusBarInfo)DataGridUtil.getProject(grid).getMessageBus().syncPublisher(StatusBar.Info.TOPIC)).setInfo(message2);
            }

            @Override
            public void jobSubmitted(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(2);
                }
                DataGridUtil.setProgressMessage(grid, "Connecting...");
            }

            @Override
            public void requestStarted(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                DataGridUtil.setProgressMessage(grid, "Processing...");
            }

            @Override
            public void beforeStatement(@NotNull DataRequest.Context context) {
                if (context == null) {
                    1.$$$reportNull$$$0(4);
                }
                DataGridUtil.setProgressMessage(grid, "Querying...");
            }

            @Override
            public void jobFinished(@NotNull DataRequest request, @NotNull DataProducer producer) {
                if (request == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (producer == null) {
                    1.$$$reportNull$$$0(6);
                }
                DataGridUtil.setProgressMessage(grid, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "request";
                        break;
                    }
                    case 2: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "producer";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobSubmitted";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "requestStarted";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeStatement";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "jobFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void setProgressMessage(@NotNull DataGrid grid, @Nullable String message2) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(17);
        }
        DbUIUtil.invokeLaterIfNeeded(() -> {
            JBLoadingPanel loadingPanel = grid.getLoadingPanel();
            if (message2 != null) {
                loadingPanel.startLoading();
            } else {
                loadingPanel.stopLoading();
            }
            loadingPanel.setLoadingText(message2);
        });
    }

    @Contract(value="null->null;!null->_")
    public static DasTable getDatabaseTable(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseTable() : null;
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@Nullable DataGrid grid, @Nullable DataConsumer.Column column) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseColumn(column) : null;
    }

    @NotNull
    public static DatabaseDialectEx getDatabaseDialect(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DatabaseDialectEx databaseDialectEx = hookup != null ? hookup.getDatabaseDialect() : DatabaseDialects.getGenericDialect();
        if (databaseDialectEx == null) {
            DataGridUtil.$$$reportNull$$$0(18);
        }
        return databaseDialectEx;
    }

    @NotNull
    public static Dbms getDbms(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        Dbms dbms = hookup == null ? Dbms.UNKNOWN : ((LocalDataSource)hookup.getSession().getTarget()).getDbms();
        if (dbms == null) {
            DataGridUtil.$$$reportNull$$$0(19);
        }
        return dbms;
    }

    @NotNull
    public static SqlLanguageDialect getSqlDialect(@Nullable DataGrid grid) {
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(DataGridUtil.getDbms(grid));
        if (sqlLanguageDialect == null) {
            DataGridUtil.$$$reportNull$$$0(20);
        }
        return sqlLanguageDialect;
    }

    @Contract(value="null->null;!null->_")
    public static DbDataSource getDatabaseSystem(@Nullable DataGrid grid) {
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDataSource() : null;
    }

    public static int getResultSetIndex(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookup = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookup != null ? dataBusHookup.getResultSetIndex() : 1;
    }

    @Contract(value="null->null;!null->_")
    public static String getQueryText(@Nullable DataGrid grid) {
        DataBusGridDataHookUp dataBusHookUp = DataGridUtil.getDataBusHookUp(grid);
        return dataBusHookUp != null ? dataBusHookUp.getQueryText() : null;
    }

    public static DataBusGridDataHookUp getDataBusHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DataBusGridDataHookUp.class);
    }

    public static DatabaseGridDataHookUp getDatabaseHookUp(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DatabaseGridDataHookUp.class);
    }

    public static DataGridSessionClient getDataGridClient(@Nullable DataGrid grid) {
        return DataGridUtil.getHookUp(grid, DataGridSessionClient.class);
    }

    @Contract(value="null,_->null;!null,_->_")
    public static <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T getHookUp(@Nullable DataGrid grid, Class<T> clazz) {
        GridDataHookUp hookup = grid != null ? grid.getDataHookup() : null;
        return (T)((GridDataHookUp)ObjectUtils.tryCast(hookup, clazz));
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable DataGrid grid) {
        return grid == null ? null : DataGridUtil.getVirtualFile(grid.getDataHookup());
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookup) {
        if (hookup instanceof DocumentDataHookUp) {
            Document document = ((DocumentDataHookUp)hookup).getDocument();
            return FileDocumentManager.getInstance().getFile(document);
        }
        if (hookup instanceof DatabaseTableGridDataHookUp) {
            return ((DatabaseTableGridDataHookUp)hookup).getVirtualFile();
        }
        return null;
    }

    @Nullable
    public static DocumentDataHookUp getDocumentDataHookUp(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(21);
        }
        return DataGridUtil.getHookUp(grid, DocumentDataHookUp.class);
    }

    public static void addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(22);
        }
        DataGridUtil.addGridHeaderComponent(dataGrid, virtualFile, "Console.EditorTableResult.Group");
    }

    public static void addGridHeaderComponent(@NotNull DataGrid dataGrid, @Nullable VirtualFile virtualFile, @NotNull String actionGroupName) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(23);
        }
        if (actionGroupName == null) {
            DataGridUtil.$$$reportNull$$$0(24);
        }
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actions = (ActionGroup)actionManager.getAction(actionGroupName);
        ActionGroup secondaryActions = (ActionGroup)actionManager.getAction("Console.TableResult.Group.Secondary");
        ActionToolbar toolbar2 = actionManager.createActionToolbar("EditorToolbar", actions, true);
        ActionToolbar toolbarSecondary = actionManager.createActionToolbar("EditorToolbar", secondaryActions, true);
        toolbar2.setTargetComponent((JComponent)((Object)dataGrid.getComponent()));
        toolbarSecondary.setTargetComponent((JComponent)((Object)dataGrid.getComponent()));
        toolbarSecondary.setReservePlaceAutoPopupIcon(false);
        EditorHeaderComponent header = new EditorHeaderComponent();
        header.setBorder((Border)JBUI.Borders.empty());
        toolbar2.getComponent().setBorder((Border)new CustomLineBorder(JBColor.border(), 0, 0, 1, 0));
        toolbarSecondary.getComponent().setBorder((Border)new CustomLineBorder(JBColor.border(), 0, 0, 1, 0));
        header.add((Component)toolbar2.getComponent(), "Center");
        header.add((Component)toolbarSecondary.getComponent(), "East");
        dataGrid.setTopComponent((Component)header);
        if (dataGrid.isFilteringSupported()) {
            dataGrid.setFilterComponent(dataGrid.getFilterPanel());
        }
        DatabaseEditorHelper.configureEditorHeader(DataGridUtil.getProject(dataGrid), virtualFile, (JComponent)header);
    }

    public static void configureNumericEditor(@NotNull DataGrid grid, @NotNull Editor editor) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(25);
        }
        if (editor == null) {
            DataGridUtil.$$$reportNull$$$0(26);
        }
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        EditorImpl editorImpl = (EditorImpl)editor;
        boolean regular = !grid.getResultView().isTransposed();
        int textAlignment = regular ? 1 : 0;
        int scrollbarOrientation = regular ? 0 : 1;
        editorImpl.setHorizontalTextAlignment(textAlignment);
        editorImpl.setVerticalScrollbarOrientation(scrollbarOrientation);
    }

    public static boolean canBuildWhereClause(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(27);
        }
        GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
        List columns = model.getColumns();
        DasTable table = DataGridUtil.getDatabaseTable(grid);
        return !DbImplUtil.getWhereClauseColumns(table, columns, DataGridUtil.getDbms(grid)).isEmpty();
    }

    public static ActionGroup getGridPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.PopupGroup");
    }

    public static ActionGroup getGridColumnHeaderPopupActions() {
        return (ActionGroup)ActionManager.getInstance().getAction("Console.TableResult.ColumnHeaderPopup");
    }

    public static DataConsumer createEDTSafeWrapper(final @NotNull DataConsumer handler, @NotNull Disposable disposableParent) {
        if (handler == null) {
            DataGridUtil.$$$reportNull$$$0(28);
        }
        if (disposableParent == null) {
            DataGridUtil.$$$reportNull$$$0(29);
        }
        final MergingUpdateQueue queue = new MergingUpdateQueue("DataConsumer[EDT]", 300, true, MergingUpdateQueue.ANY_COMPONENT, disposableParent);
        return new DataConsumer(){
            DataConsumer.Column[] columns;

            @Override
            public void setColumns(final @NotNull DataRequest.Context context, final int resultSetIndex, final DataConsumer.Column @NotNull [] columns, final int firstRowNum) {
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (columns == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.columns = columns;
                queue.queue(new Update("init"){

                    public void run() {
                        handler.setColumns(context, resultSetIndex, columns, firstRowNum);
                    }
                });
            }

            @Override
            public void updateColumns(final @NotNull DataRequest.Context context, final @NotNull DataConsumer.Column[] columns) {
                if (context == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (columns == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.columns = columns;
                queue.queue(new Update("updateColumns"){

                    public void run() {
                        handler.updateColumns(context, columns);
                    }
                });
            }

            @Override
            public void addRows(final @NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
                if (context == null) {
                    2.$$$reportNull$$$0(4);
                }
                Dbms dbms = (Dbms)ObjectUtils.chooseNotNull((Object)TransactionAction.getDbms(context.request.owner), (Object)Dbms.UNKNOWN);
                ObjectFormatter.convertRows(rows, Arrays.asList(this.columns), dbms);
                class AddRows
                extends Update {
                    final List<List<DataConsumer.Row>> rows;

                    AddRows(List<DataConsumer.Row> rows) {
                        super(new Object());
                        this.rows = new SmartList();
                        this.rows.add(rows);
                    }

                    public boolean canEat(Update update2) {
                        if (update2 instanceof AddRows) {
                            this.rows.addAll(((AddRows)update2).rows);
                            return true;
                        }
                        return false;
                    }

                    public void run() {
                        List combined = this.rows.size() == 1 ? this.rows.get(0) : ContainerUtil.concat((List[])this.rows.toArray(new List[0]));
                        handler.addRows(context, combined);
                    }
                }
                queue.queue((Update)new AddRows(rows));
            }

            @Override
            public void afterLastRowAdded(final @NotNull DataRequest.Context context, final int total) {
                if (context == null) {
                    2.$$$reportNull$$$0(5);
                }
                this.columns = null;
                queue.queue(new Update("afterLastRowAdded"){

                    public void run() {
                        handler.afterLastRowAdded(context, total);
                    }
                });
                queue.flush();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columns";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setColumns";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateColumns";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addRows";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterLastRowAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        DataConsumer.Column column;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(30);
        }
        if (columnIdx == null) {
            DataGridUtil.$$$reportNull$$$0(31);
        }
        if (DbImplUtil.isRowId(column = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx))) {
            return ReservedCellValue.COMPUTED;
        }
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column);
        return DataGridUtil.getDefaultNullValue(dasColumn);
    }

    @Nullable
    public static DasColumn getDatabaseColumn(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(32);
        }
        if (columnIdx == null) {
            DataGridUtil.$$$reportNull$$$0(33);
        }
        DataConsumer.Column column = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        return hookup != null ? hookup.getDatabaseColumn(column) : null;
    }

    @NotNull
    public static List<RowMutation> mergeAll(@NotNull List<? extends CellMutation> mutations, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        if (mutations == null) {
            DataGridUtil.$$$reportNull$$$0(34);
        }
        if (model == null) {
            DataGridUtil.$$$reportNull$$$0(35);
        }
        ArrayList<? extends CellMutation> copy = new ArrayList<CellMutation>(mutations);
        ArrayList<RowMutation> rowMutations = new ArrayList<RowMutation>();
        while (!copy.isEmpty()) {
            rowMutations.add(DataGridUtil.merge(copy, model));
        }
        List<RowMutation> list = rowMutations.stream().filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    private static RowMutation merge(@NotNull List<? extends CellMutation> mutations, @NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model) {
        CellMutation item;
        if (mutations == null) {
            DataGridUtil.$$$reportNull$$$0(37);
        }
        if (model == null) {
            DataGridUtil.$$$reportNull$$$0(38);
        }
        if ((item = (CellMutation)ContainerUtil.getFirstItem(mutations)) == null) {
            throw new IllegalStateException("Shouldn't call merge() when there is no pending changes");
        }
        mutations.remove(item);
        List toMerge = ContainerUtil.filter(mutations, item::canMergeByRowWith);
        mutations.removeAll(toMerge);
        RowMutation merged = item.createRowMutation(model);
        for (CellMutation mutation : toMerge) {
            if (merged == null) {
                merged = mutation.createRowMutation(model);
                continue;
            }
            merged = merged.merge(mutation.createRowMutation(model));
        }
        return merged;
    }

    @Nullable
    public static ReservedCellValue getDefaultNullValue(@Nullable DasColumn dasColumn) {
        EnumSet<ReservedCellValue> opts = DbImplUtil.getSpecialValues(dasColumn);
        return opts.contains((Object)ReservedCellValue.GENERATED) ? ReservedCellValue.GENERATED : (opts.contains((Object)ReservedCellValue.COMPUTED) ? ReservedCellValue.COMPUTED : (opts.contains((Object)ReservedCellValue.DEFAULT) ? ReservedCellValue.DEFAULT : (opts.contains((Object)ReservedCellValue.NULL) ? ReservedCellValue.NULL : null)));
    }

    public static Project getProject(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(39);
        }
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)((Object)grid.getComponent())));
    }

    public static boolean isFailedToLoad(Object value2) {
        return value2 instanceof String && StringUtil.startsWith((CharSequence)((String)value2), (CharSequence)FAILED_TO_LOAD_PREFIX);
    }

    public static boolean showIgnoreUnsubmittedChangesYesNoDialog(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(40);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String title = "Ignore Unsubmitted Changes";
        String message2 = "Changes are not submitted. Data will be lost. Continue?";
        return 0 == Messages.showYesNoDialog((Component)((Object)grid.getComponent()), (String)message2, (String)title, (Icon)AllIcons.General.NotificationWarning);
    }

    public static void showCannotApplyCellEditorChanges(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(41);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String title = "Cannot Apply Changes";
        String message2 = "This table is read-only. Changes cannot be applied.";
        Messages.showInfoMessage((Component)((Object)grid.getComponent()), (String)message2, (String)title);
    }

    @NotNull
    public static CharOut extractSelectedValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor.Text extractor) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(42);
        }
        if (extractor == null) {
            DataGridUtil.$$$reportNull$$$0(43);
        }
        return DataGridUtil.extractValues(dataGrid, extractor, CharOut.Util.newSink(), true, true);
    }

    public static void extractSelectedValues(DataGrid dataGrid, DataExtractor.Text extractor, CharOut out) {
        DataGridUtil.extractValues(dataGrid, extractor, out, true, true);
    }

    @NotNull
    public static CharOut extractValues(@NotNull DataGrid dataGrid, @NotNull DataExtractor.Text extractor, @NotNull CharOut out, boolean selection, boolean transpositionAllowed) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(44);
        }
        if (extractor == null) {
            DataGridUtil.$$$reportNull$$$0(45);
        }
        if (out == null) {
            DataGridUtil.$$$reportNull$$$0(46);
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        int[] columns = (selection ? dataGrid.getSelectionModel().getSelectedColumns() : model.getColumnIndices()).asArray();
        List<DataConsumer.Row> rows = selection ? DataGridUtil.getSelectedRows(dataGrid) : model.getRows();
        Dbms dbms = DataGridUtil.getDbms(dataGrid);
        boolean transposed = transpositionAllowed && dataGrid.getResultView().isTransposed();
        ExtractorsUtil.extract(out, dbms, ExtractionConfigKt.builder().setTransposed(transposed).build(), model.getColumns(), extractor, rows, columns);
        CharOut charOut = out;
        if (charOut == null) {
            DataGridUtil.$$$reportNull$$$0(47);
        }
        return charOut;
    }

    @NotNull
    public static List<DataConsumer.Row> getSelectedRows(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(48);
        }
        ModelIndexSet rowIndices = dataGrid.getSelectionModel().getSelectedRows();
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        List<DataConsumer.Row> rows = model.getRows(rowIndices);
        List<DataConsumer.Row> list = rows.isEmpty() ? model.getRows() : rows;
        if (list == null) {
            DataGridUtil.$$$reportNull$$$0(49);
        }
        return list;
    }

    @NotNull
    public static List<CellMutation> createMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @Nullable Object value2) {
        if (rows == null) {
            DataGridUtil.$$$reportNull$$$0(50);
        }
        if (columns == null) {
            DataGridUtil.$$$reportNull$$$0(51);
        }
        return DataGridUtil.createMutations(rows, columns, (Function<? super ModelIndex<DataConsumer.Row>, MutationType>)((Function)row -> MutationType.MODIFY), value2);
    }

    @NotNull
    public static List<CellMutation> createMutations(@NotNull ModelIndexSet<DataConsumer.Row> rows, @NotNull ModelIndexSet<DataConsumer.Column> columns, @NotNull Function<? super ModelIndex<DataConsumer.Row>, MutationType> mutationTypeProvider, @Nullable Object value2) {
        if (rows == null) {
            DataGridUtil.$$$reportNull$$$0(52);
        }
        if (columns == null) {
            DataGridUtil.$$$reportNull$$$0(53);
        }
        if (mutationTypeProvider == null) {
            DataGridUtil.$$$reportNull$$$0(54);
        }
        ArrayList<CellMutation> mutations = new ArrayList<CellMutation>();
        for (ModelIndex rowIdx : rows.asIterable()) {
            for (ModelIndex columnIdx : columns.asIterable()) {
                mutations.add(new CellMutation(rowIdx, columnIdx, (MutationType)((Object)mutationTypeProvider.fun((Object)rowIdx)), value2));
            }
        }
        ArrayList<CellMutation> arrayList = mutations;
        if (arrayList == null) {
            DataGridUtil.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    @NotNull
    public static Domain unwrap(@NotNull Domain domain) {
        if (domain == null) {
            DataGridUtil.$$$reportNull$$$0(56);
        }
        Domain domain2 = domain instanceof DomainWrapper ? ((DomainWrapper)((Object)domain)).unwrap() : domain;
        if (domain2 == null) {
            DataGridUtil.$$$reportNull$$$0(57);
        }
        return domain2;
    }

    public static int min(@NotNull IndexSet<?> set) {
        OptionalInt min;
        if (set == null) {
            DataGridUtil.$$$reportNull$$$0(58);
        }
        return (min = set.asList().stream().mapToInt(Index::asInteger).min()).isPresent() ? min.getAsInt() : -1;
    }

    @NotNull
    public static String getRowName(@NotNull DataGrid grid, int relativeIndex) {
        GridDataHookUp dataHookup;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(59);
        }
        boolean trueRows = (dataHookup = grid.getDataHookup()) instanceof CsvDocumentDataHookUp && ((CsvDocumentDataHookUp)dataHookup).getFormat().rowNumbers;
        ModelIndex<DataConsumer.Row> rowIndex = trueRows ? ViewIndex.forRow(grid, relativeIndex).toModel(grid) : ModelIndex.forRow(grid, relativeIndex);
        DataConsumer.Row row = grid.getDataModel(DataAccessType.DATABASE_DATA).getRow(rowIndex);
        String string = row instanceof NamedRow ? ((NamedRow)row).name : String.valueOf(row == null ? "N/A" : Integer.valueOf(grid.isInsertedRow(rowIndex) ? DataGridUtil.getInsertedRowIdx(grid, relativeIndex) : row.rowNum));
        if (string == null) {
            DataGridUtil.$$$reportNull$$$0(60);
        }
        return string;
    }

    @Nullable
    public static String getResultSetName(@NotNull AnActionEvent e) {
        if (e == null) {
            DataGridUtil.$$$reportNull$$$0(61);
        }
        DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
        JdbcConsole console = JdbcConsole.findConsole(e);
        return DataGridUtil.getResultSetName(grid, console);
    }

    @Nullable
    public static String getResultSetName(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(62);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(63);
        }
        return DataGridUtil.getResultSetName(grid, DataGridUtil.findGridRelatedConsole(project, grid));
    }

    @Nullable
    public static String getResultSetName(@Nullable DataGrid grid, @Nullable JdbcConsole console) {
        DasTable table;
        DasTable dasTable = table = grid == null ? null : DataGridUtil.getDatabaseTable(grid);
        return table != null ? table.getName() : (console != null && grid != null ? DataGridUtil.getNameFromConsole(console, grid) : null);
    }

    @Nullable
    private static String getNameFromConsole(@NotNull JdbcConsole console, @NotNull DataGrid dataGrid) {
        RunnerLayoutUi ui;
        if (console == null) {
            DataGridUtil.$$$reportNull$$$0(64);
        }
        if (dataGrid == null) {
            DataGridUtil.$$$reportNull$$$0(65);
        }
        Content content = (ui = console.getUi()) == null ? null : ui.getContentManager().getContent((JComponent)((Object)dataGrid.getComponent()));
        return content == null ? null : content.getDisplayName();
    }

    private static int getInsertedRowIdx(@NotNull DataGrid grid, int relativeIndex) {
        ModelIndex<DataConsumer.Row> rowIdx;
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(66);
        }
        DataConsumer.Row row = (rowIdx = DataGridUtil.getLastNotInsertedRow(grid)) == null ? null : grid.getDataModel(DataAccessType.DATABASE_DATA).getRow(rowIdx);
        int humanReadable = relativeIndex + 1;
        if (row == null) {
            return humanReadable;
        }
        int difference = relativeIndex - rowIdx.asInteger();
        return difference < 0 ? humanReadable : row.rowNum + difference;
    }

    @Nullable
    private static ModelIndex<DataConsumer.Row> getLastNotInsertedRow(@NotNull DataGrid grid) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(67);
        }
        List rows = grid.getDataModel(DataAccessType.DATABASE_DATA).getRowIndices().asList();
        for (int i2 = rows.size() - 1; i2 >= 0; --i2) {
            ModelIndex index2 = (ModelIndex)rows.get(i2);
            if (grid.isInsertedRow(index2)) continue;
            return index2;
        }
        return null;
    }

    @Nullable
    private static JdbcConsole findGridRelatedConsole(@NotNull Project project, @NotNull DataGrid grid) {
        if (project == null) {
            DataGridUtil.$$$reportNull$$$0(68);
        }
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(69);
        }
        List<JdbcConsole> consoles = JdbcConsole.getActiveConsoles(project);
        for (JdbcConsole console : consoles) {
            RunnerLayoutUi ui = console.getUi();
            Content content = ui == null ? null : ui.getContentManager().getContent((JComponent)((Object)grid.getComponent()));
            if (content == null) continue;
            return console;
        }
        return null;
    }

    public static void saveAndRestoreSelection(@NotNull DataGrid grid, Runnable runnable) {
        if (grid == null) {
            DataGridUtil.$$$reportNull$$$0(70);
        }
        GridSelection selection = grid.getSelectionModel().store();
        GridScrollPositionManager.GridScrollPosition scrollPosition = GridScrollPositionManager.get(grid.getResultView(), grid).store();
        runnable.run();
        DbUIUtil.invokeLater(() -> {
            grid.getSelectionModel().restore(selection);
            GridScrollPositionManager.get(grid.getResultView(), grid).restore(scrollPosition);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 47: 
            case 49: 
            case 55: 
            case 57: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 47: 
            case 49: 
            case 55: 
            case 57: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHookUp";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 47: 
            case 49: 
            case 55: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 9: 
            case 22: 
            case 23: 
            case 42: 
            case 44: 
            case 48: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 12: 
            case 16: 
            case 17: 
            case 21: 
            case 25: 
            case 27: 
            case 30: 
            case 32: 
            case 39: 
            case 40: 
            case 41: 
            case 59: 
            case 63: 
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroupName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnIdx";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutations";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutationTypeProvider";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DataGridUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataGrid";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findColumn";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeAll";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "extractValues";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createMutations";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrap";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 47: 
            case 49: 
            case 55: 
            case 57: 
            case 60: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewDataGrid";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findColumn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setupProgressIndicatingAuditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setProgressMessage";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentDataHookUp";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addGridHeaderComponent";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "configureNumericEditor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canBuildWhereClause";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createEDTSafeWrapper";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultNullValue";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getDatabaseColumn";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "mergeAll";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getProject";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showIgnoreUnsubmittedChangesYesNoDialog";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "showCannotApplyCellEditorChanges";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "extractSelectedValues";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "extractValues";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRows";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createMutations";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "unwrap";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getRowName";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getResultSetName";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromConsole";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getInsertedRowIdx";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getLastNotInsertedRow";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findGridRelatedConsole";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "saveAndRestoreSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 36: 
            case 47: 
            case 49: 
            case 55: 
            case 57: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

