/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.graph;

import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphObservable<V> {
    private final List<Consumer<Throwable>> myListeners;
    private final MultiMap<GraphObserver, GraphObserver> myMap;
    private final GraphObserver<V, ?> myRoot;
    private final V myInitializer;

    private GraphObservable(@NotNull MultiMap<GraphObserver, GraphObserver> map2, @NotNull GraphObserver<V, ?> root2, @Nullable V initializer) {
        if (map2 == null) {
            GraphObservable.$$$reportNull$$$0(0);
        }
        if (root2 == null) {
            GraphObservable.$$$reportNull$$$0(1);
        }
        this.myMap = map2;
        this.myRoot = root2;
        this.myInitializer = initializer;
        this.myListeners = new ArrayList<Consumer<Throwable>>();
        ObserverListener listener2 = new ObserverListener(this);
        for (GraphObserver observer : map2.keySet()) {
            observer.addListener(listener2);
        }
    }

    @NotNull
    public CompletionStage<?> init() {
        CompletionStage completionStage = this.myRoot.notifyChanged(this.myInitializer).thenCompose(o -> GraphObservable.notifyObservers(this.myRoot, this, new HashSet(), o).whenComplete((o1, e1) -> this.changed((Throwable)e1)));
        if (completionStage == null) {
            GraphObservable.$$$reportNull$$$0(2);
        }
        return completionStage;
    }

    public void addListener(@NotNull Consumer<Throwable> consumer2) {
        if (consumer2 == null) {
            GraphObservable.$$$reportNull$$$0(3);
        }
        this.myListeners.add(consumer2);
    }

    private void changed(@Nullable Throwable throwable) {
        this.myListeners.forEach(listener2 -> listener2.consume((Object)AsyncUtil.unwrap(throwable)));
    }

    @NotNull
    private Collection<GraphObserver> next(@NotNull GraphObserver<?, ?> first2) {
        if (first2 == null) {
            GraphObservable.$$$reportNull$$$0(4);
        }
        Collection collection = this.myMap.get(first2);
        if (collection == null) {
            GraphObservable.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static <V> CompletionStage<?> notifyObservers(@NotNull GraphObserver<?, ?> observer, @NotNull GraphObservable<V> observable, @NotNull Set<GraphObserver<?, ?>> set, @Nullable Object o) {
        if (observer == null) {
            GraphObservable.$$$reportNull$$$0(6);
        }
        if (observable == null) {
            GraphObservable.$$$reportNull$$$0(7);
        }
        if (set == null) {
            GraphObservable.$$$reportNull$$$0(8);
        }
        if (set.contains(observer)) {
            throw new IllegalStateException();
        }
        set.add(observer);
        Collection<GraphObserver> next = super.next(observer);
        if (next.isEmpty()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                GraphObservable.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }
        CompletableFuture[] futures = (CompletableFuture[])next.stream().map(graphObserver -> graphObserver.notifyChanged(o).thenCompose(obj -> GraphObservable.notifyObservers(graphObserver, observable, set, obj))).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
        if (completableFuture == null) {
            GraphObservable.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/graph/GraphObservable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/graph/GraphObservable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyObservers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "next";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyObservers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder<V> {
        private final List<GraphObserver<?, ?>> myObservers = new ArrayList();
        private GraphObserver<V, ?> myRoot;
        private V myInitializer;

        @NotNull
        public Builder<V> add(@NotNull List<? extends GraphObserver<?, ?>> observers) {
            if (observers == null) {
                Builder.$$$reportNull$$$0(0);
            }
            for (GraphObserver<?, ?> observer : observers) {
                this.add(observer);
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder<V> add(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myObservers.add(observer);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder<V> root(@NotNull GraphObserver<V, ?> root2) {
            if (root2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            this.myRoot = root2;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public Builder<V> initializer(@Nullable V initializer) {
            this.myInitializer = initializer;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder;
        }

        @NotNull
        public GraphObservable<V> build() {
            MultiMap map2 = new MultiMap();
            for (GraphObserver<?, ?> observer : this.myObservers) {
                List<GraphObserver<?, ?>> next = this.next(observer);
                for (GraphObserver<?, ?> nextObserver : next) {
                    map2.putValue(observer, nextObserver);
                }
            }
            return new GraphObservable(map2, this.myRoot, this.myInitializer);
        }

        @NotNull
        private List<GraphObserver<?, ?>> next(@NotNull GraphObserver<?, ?> observer) {
            if (observer == null) {
                Builder.$$$reportNull$$$0(7);
            }
            ArrayList list = new ArrayList();
            for (GraphObserver<?, ?> current : this.myObservers) {
                if (observer == current || !observer.dependsOn(current)) continue;
                list.add(current);
            }
            ArrayList arrayList = list;
            if (arrayList == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "observers";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dbimport/graph/GraphObservable$Builder";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "observer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dbimport/graph/GraphObservable$Builder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "root";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initializer";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "next";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "root";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "next";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ObserverListener<V>
    implements EventListener {
        private final GraphObservable<V> myObservable;

        public ObserverListener(@NotNull GraphObservable<V> observable) {
            if (observable == null) {
                ObserverListener.$$$reportNull$$$0(0);
            }
            this.myObservable = observable;
        }

        public void changed(GraphObserver<?, ?> observer, Object object) {
            GraphObservable.notifyObservers(observer, (GraphObservable)this.myObservable, new HashSet(), object).whenComplete((o, e) -> ((GraphObservable)this.myObservable).changed(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "com/intellij/database/dbimport/graph/GraphObservable$ObserverListener", "<init>"));
        }
    }

    public static interface GraphObserver<IN, OUT> {
        public void addListener(@NotNull ObserverListener<?> var1);

        @NotNull
        public CompletionStage<OUT> notifyChanged(@Nullable IN var1);

        public boolean dependsOn(@NotNull GraphObserver<?, ?> var1);
    }
}

