/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.google.common.collect.ImmutableList;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.serialization.ExportException;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelExporter {
    private static final Logger LOG = Logger.getInstance(ModelExporter.class);
    public boolean persistent;
    public TIntObjectHashMap<Couple<Version>> versions;

    public void saveModel(@NotNull BasicModel model, @NotNull HierarchicalStreamWriter writer, @Nullable TreePattern scope) throws ExportException {
        if (model == null) {
            ModelExporter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            ModelExporter.$$$reportNull$$$0(1);
        }
        ModelMem modelMem = model.read(r -> this.exportModel((BasicModel)r, scope));
        this.serializeModel(modelMem, writer);
    }

    public ModelMem exportModel(@NotNull BasicModel model, @Nullable TreePattern scope) {
        if (model == null) {
            ModelExporter.$$$reportNull$$$0(2);
        }
        ModelMem mm = new ModelMem();
        mm.setDbms(model.getDbms());
        mm.setVersion(ModelSerializationVersions.CURRENT_VERSION);
        Map<BasicElement, Integer> nodes2 = this.orderNodes(model.getRoot(), scope);
        for (BasicElement node : nodes2.keySet()) {
            ModelElementMem om = this.exportElement(node, nodes2);
            mm.getNodes().add(om);
        }
        return mm;
    }

    private Map<BasicElement, Integer> orderNodes(BasicRoot root2, @Nullable TreePattern scope) {
        int counter = 0;
        JBTreeTraverser<BasicElement> traverser = ModelExporter.traverser(root2, scope);
        LinkedHashMap<BasicElement, Integer> nodes2 = new LinkedHashMap<BasicElement, Integer>();
        for (BasicElement object : traverser.bfsTraversal()) {
            Integer id = ++counter;
            nodes2.put(object, id);
        }
        return nodes2;
    }

    @NotNull
    private static JBTreeTraverser<BasicElement> traverser(BasicRoot root2, @Nullable TreePattern scope) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(e -> e.getChildren()).withRoot((Object)root2)).expand(e -> DataSourceSchemaMapping.isIntrospected(scope, e));
        if (jBTreeTraverser == null) {
            ModelExporter.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    private ModelElementMem exportElement(BasicElement element2, Map<BasicElement, Integer> nodes2) {
        Integer parentId;
        Integer id = nodes2.get(element2);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        BasicElement parentElement = element2.getParent();
        Integer n = parentId = parentElement != null ? nodes2.get(parentElement) : null;
        assert (element2 instanceof BasicRoot == (parentElement == null));
        ImmutableList<MutableNameAndValue> properties = this.exportElementProperties(element2);
        String elementName = element2 instanceof BasicNamedElement ? element2.getRealName() : null;
        return new ModelElementMem(id, parentId, element2.getKind().code(), elementName, (List<MutableNameAndValue>)properties);
    }

    private ImmutableList<MutableNameAndValue> exportElementProperties(BasicElement element2) {
        ImmutableList.Builder b2 = new ImmutableList.Builder();
        element2.exportProperties((name, value2) -> {
            if (value2 != null) {
                if (this.acceptsProperty(element2, name) && !name.equalsIgnoreCase("name")) {
                    b2.add((Object)new MutableNameAndValue(name, (String)value2));
                }
            } else {
                LOG.warn("Attempted to export null property " + name + " when exporting element " + element2.identity());
            }
        });
        return b2.build();
    }

    protected boolean acceptsProperty(BasicElement element2, String name) {
        return true;
    }

    protected void serializeModel(@NotNull ModelMem mem, @NotNull HierarchicalStreamWriter writer) {
        if (mem == null) {
            ModelExporter.$$$reportNull$$$0(4);
        }
        if (writer == null) {
            ModelExporter.$$$reportNull$$$0(5);
        }
        writer.startNode("database-model");
        writer.addAttribute("serializer", "dbm");
        writer.addAttribute("dbms", mem.getDbms().getName());
        writer.addAttribute("family-id", mem.getDbms().getName());
        if (!this.persistent) {
            writer.addAttribute("format-version", ModelSerializationVersions.CURRENT_VERSION.toString());
        }
        for (Map.Entry<String, String> property : mem.getProperties().entrySet()) {
            writer.addAttribute(property.getKey(), property.getValue());
        }
        if (!this.persistent) {
            for (ModelElementMem object : mem.getNodes()) {
                this.serializeNode(object, writer, null);
            }
        } else {
            List[] index2 = new List[mem.getNodes().size() + 1];
            for (ModelElementMem node : mem.getNodes()) {
                int idx = (Integer)ObjectUtils.notNull((Object)node.getParentId(), (Object)0);
                ArrayList<ModelElementMem> children2 = index2[idx];
                if (children2 == null) {
                    children2 = index2[idx] = new ArrayList<ModelElementMem>();
                }
                children2.add(node);
            }
            for (ModelElementMem root2 : ModelExporter.children(index2, null)) {
                this.serializeNode(root2, writer, (Function<ModelElementMem, Iterable<ModelElementMem>>)((Function)n -> ModelExporter.children(index2, n)));
            }
        }
        writer.endNode();
    }

    private static Iterable<ModelElementMem> children(List<ModelElementMem>[] index2, ModelElementMem obj) {
        int idx = obj == null ? 0 : Objects.requireNonNull(obj.getId());
        return (Iterable)ObjectUtils.notNull(index2[idx], Collections.emptyList());
    }

    private void serializeNode(ModelElementMem node, HierarchicalStreamWriter writer, Function<ModelElementMem, Iterable<ModelElementMem>> children2) {
        writer.startNode(node.getKind());
        if (!this.persistent) {
            writer.addAttribute("id", Integer.toString(Objects.requireNonNull(node.getId())));
            Integer parentId = node.getParentId();
            if (parentId != null) {
                writer.addAttribute("parent", Integer.toString(parentId));
            }
        } else {
            Couple parentVersions;
            Couple versions = this.versions == null ? null : (Couple)this.versions.get(((Integer)ObjectUtils.notNull((Object)node.getId(), (Object)0)).intValue());
            Couple couple = parentVersions = this.versions == null ? null : (Couple)this.versions.get(((Integer)ObjectUtils.notNull((Object)node.getParentId(), (Object)0)).intValue());
            if (Objects.equals(versions, parentVersions)) {
                versions = null;
            }
            if (versions != null && !((Version)versions.first).equals((Object)Version.ZERO)) {
                writer.addAttribute("from-version", ((Version)versions.first).toString());
            }
            if (versions != null && !((Version)versions.second).equals((Object)Version.INFINITY)) {
                writer.addAttribute("to-version", ((Version)versions.second).toString());
            }
        }
        if (node.getName() != null) {
            writer.addAttribute("name", node.getName());
        }
        for (MutableNameAndValue property : node.getProperties()) {
            if (property.getName().equalsIgnoreCase("name")) continue;
            ModelExporter.serializeProperty(property, writer);
        }
        if (this.persistent && children2 != null) {
            for (ModelElementMem child : (Iterable)children2.fun((Object)node)) {
                this.serializeNode(child, writer, children2);
            }
        }
        writer.endNode();
    }

    private static void serializeProperty(MutableNameAndValue property, HierarchicalStreamWriter writer) {
        writer.startNode(property.getName());
        writer.setValue(property.getValue());
        writer.endNode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/ModelExporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/ModelExporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportModel";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

