/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.session;

import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageBusSessionState
implements DatabaseSession.State {
    private final long myStart;
    private final long myActivation;
    private final boolean myAllowReset;
    private final List<DatabaseSession.State.Work> myWork;
    private final AtomicLong myDeactivation;

    public MessageBusSessionState() {
        this(0L, 0L, ContainerUtil.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private MessageBusSessionState(long start2, long activation, @NotNull List<DatabaseSession.State.Work> list) {
        void work;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(0);
        }
        this(start2, activation, (List<DatabaseSession.State.Work>)work, false);
    }

    /*
     * WARNING - void declaration
     */
    private MessageBusSessionState(long start2, long activation, @NotNull List<DatabaseSession.State.Work> list, boolean bl) {
        void allowReset;
        void work;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(1);
        }
        this.myStart = start2;
        this.myWork = work;
        this.myActivation = activation;
        this.myAllowReset = allowReset;
        this.myDeactivation = new AtomicLong(0L);
    }

    @Override
    public boolean isIdle() {
        return this.getNonFinishedWork().isEmpty();
    }

    @Override
    public boolean isFinalized() {
        return this.myAllowReset;
    }

    @Override
    public boolean isEmpty() {
        return this.myWork.isEmpty() || this.myActivation == 0L;
    }

    @Override
    public long getStartTime() {
        return this.myStart;
    }

    @Override
    public long getTimeSpentMs() {
        return this.isIdle() ? this.findLastFinishTime() - this.myActivation : System.currentTimeMillis() - (this.myActivation == 0L ? this.myStart : this.myActivation);
    }

    @Override
    @NotNull
    public List<DatabaseSession.State.Work> getWork() {
        List<DatabaseSession.State.Work> list = this.myWork;
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public MessageBusSessionState update() {
        return new MessageBusSessionState(this.myStart, this.myActivation, this.myWork, this.isIdle());
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getWorkFor(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            MessageBusSessionState.$$$reportNull$$$0(3);
        }
        return this.getMostRecentWork((Condition<DatabaseSession.State.Work>)((Condition)w -> w.getRequest().owner == owner));
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getWorkFor(@NotNull DataRequest request) {
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(4);
        }
        return this.getMostRecentWork((Condition<DatabaseSession.State.Work>)((Condition)w -> w.getRequest() == request));
    }

    @Override
    @Nullable
    public DatabaseSession.State.Work getMostRecentWork(@NotNull List<? extends DataRequest> requests) {
        if (requests == null) {
            MessageBusSessionState.$$$reportNull$$$0(5);
        }
        return this.getMostRecentWork((Condition<DatabaseSession.State.Work>)((Condition)w -> requests.contains((Object)w.getRequest())));
    }

    @NotNull
    public MessageBusSessionState resetIfEmpty() {
        MessageBusSessionState messageBusSessionState = this.myAllowReset ? new MessageBusSessionState(0L, 0L, ContainerUtil.emptyList()) : this;
        if (messageBusSessionState == null) {
            MessageBusSessionState.$$$reportNull$$$0(6);
        }
        return messageBusSessionState;
    }

    @NotNull
    public MessageBusSessionState plus(@NotNull DataRequest request, long time) {
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(7);
        }
        return this.plus(new Work(request, DatabaseSession.State.WorkState.SUBMITTED, PendingStatus.INSTANCE, time, 0L));
    }

    @NotNull
    public MessageBusSessionState error(@NotNull DataRequest request, @Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull String message2) {
        Work work;
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(8);
        }
        if (message2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(9);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, w -> w.getRequest() == request)) == null ? this : this.remove(request).add(work.error(navigator, message2));
    }

    @NotNull
    public MessageBusSessionState warning(@NotNull DataRequest request, @NotNull String message2) {
        Work work;
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(10);
        }
        if (message2 == null) {
            MessageBusSessionState.$$$reportNull$$$0(11);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, w -> w.getRequest() == request)) == null ? this : this.remove(request).add(work.warning(message2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageBusSessionState activate(long startTime, @NotNull DataRequest dataRequest) {
        void request;
        if (dataRequest == null) {
            MessageBusSessionState.$$$reportNull$$$0(12);
        }
        long activation = this.myActivation == 0L ? startTime : this.myActivation;
        Work work = (Work)ContainerUtil.find(this.myWork, arg_0 -> MessageBusSessionState.lambda$activate$5((DataRequest)request, arg_0));
        return work == null ? this : this.remove((DataRequest)request).add(work.running(startTime)).withProperties(this.myStart, activation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MessageBusSessionState deactivate(long finishTime, @NotNull DataRequest dataRequest) {
        void request;
        Work work;
        if (dataRequest == null) {
            MessageBusSessionState.$$$reportNull$$$0(13);
        }
        return (work = (Work)ContainerUtil.find(this.myWork, arg_0 -> MessageBusSessionState.lambda$deactivate$6((DataRequest)request, arg_0))) == null ? this : this.remove((DataRequest)request).add(work.stopped(finishTime));
    }

    @NotNull
    private MessageBusSessionState withProperties(long startTime, long activation) {
        return new MessageBusSessionState(startTime, activation, this.myWork);
    }

    @Nullable
    private DatabaseSession.State.Work getMostRecentWork(@NotNull Condition<DatabaseSession.State.Work> condition) {
        if (condition == null) {
            MessageBusSessionState.$$$reportNull$$$0(14);
        }
        List workByOwner = ContainerUtil.filter(this.myWork, condition);
        List sorted = ContainerUtil.sorted((Collection)workByOwner, (w1, w2) -> {
            DatabaseSession.State.WorkState s2;
            DatabaseSession.State.WorkState s1 = w1.getState();
            return s1 == (s2 = w2.getState()) ? Long.compare(((Work)w2).myFinished, ((Work)w1).myFinished) : (s1 == DatabaseSession.State.WorkState.RUNNING ? -1 : (s2 == DatabaseSession.State.WorkState.FINISHED ? -1 : 1));
        });
        return (DatabaseSession.State.Work)ContainerUtil.getFirstItem((List)sorted);
    }

    private long findLastFinishTime() {
        long value2 = this.myDeactivation.get();
        if (value2 != 0L) {
            return value2;
        }
        List sorted = ContainerUtil.sorted(this.myWork, Comparator.comparingLong(w -> ((Work)w).myFinished).reversed());
        Work first2 = (Work)ContainerUtil.getFirstItem((List)sorted);
        if (first2 != null) {
            this.myDeactivation.compareAndSet(0L, first2.myFinished);
        }
        return this.myDeactivation.get();
    }

    @NotNull
    private MessageBusSessionState remove(@NotNull DataRequest request) {
        if (request == null) {
            MessageBusSessionState.$$$reportNull$$$0(15);
        }
        List work = ContainerUtil.filter(this.myWork, w -> w.getRequest() != request);
        return new MessageBusSessionState(this.myStart, this.myActivation, work);
    }

    @NotNull
    private MessageBusSessionState plus(@NotNull Work newWork) {
        if (newWork == null) {
            MessageBusSessionState.$$$reportNull$$$0(16);
        }
        List work = ContainerUtil.concat(this.myWork, Collections.singletonList(newWork));
        return new MessageBusSessionState(this.myWork.isEmpty() ? newWork.getStartTime() : this.myStart, this.myActivation, work);
    }

    @NotNull
    private MessageBusSessionState add(@NotNull Work newWork) {
        if (newWork == null) {
            MessageBusSessionState.$$$reportNull$$$0(17);
        }
        List work = ContainerUtil.concat(this.myWork, Collections.singletonList(newWork));
        return new MessageBusSessionState(this.myStart, this.myActivation, work);
    }

    @NotNull
    private List<DatabaseSession.State.Work> getNonFinishedWork() {
        List list = ContainerUtil.filter(this.myWork, w -> !((Work)w).isFinished());
        if (list == null) {
            MessageBusSessionState.$$$reportNull$$$0(18);
        }
        return list;
    }

    private static /* synthetic */ boolean lambda$deactivate$6(DataRequest request, DatabaseSession.State.Work w) {
        return w.getRequest() == request;
    }

    private static /* synthetic */ boolean lambda$activate$5(DataRequest request, DatabaseSession.State.Work w) {
        return w.getRequest() == request;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "work";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newWork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWork";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resetIfEmpty";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonFinishedWork";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWorkFor";
                break;
            }
            case 5: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMostRecentWork";
                break;
            }
            case 7: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "warning";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProblemStatus
    implements DatabaseSession.State.WorkStatus {
        private final DatabaseSession.State.WorkStatusType myType;
        private final DataRequest.CoupledWithEditor.ErrorNavigator myNavigator;
        private final String myMessage;

        ProblemStatus(@NotNull DatabaseSession.State.WorkStatusType type, @Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull String message2) {
            if (type == null) {
                ProblemStatus.$$$reportNull$$$0(0);
            }
            if (message2 == null) {
                ProblemStatus.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.myNavigator = navigator;
            this.myMessage = message2;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = this.myType;
            if (workStatusType == null) {
                ProblemStatus.$$$reportNull$$$0(2);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return this.myNavigator;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState$ProblemStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState$ProblemStatus";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SuccessStatus
    implements DatabaseSession.State.WorkStatus {
        static final SuccessStatus INSTANCE = new SuccessStatus();

        private SuccessStatus() {
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = DatabaseSession.State.WorkStatusType.SUCCESS;
            if (workStatusType == null) {
                SuccessStatus.$$$reportNull$$$0(0);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/session/MessageBusSessionState$SuccessStatus", "getType"));
        }
    }

    private static class PendingStatus
    implements DatabaseSession.State.WorkStatus {
        static final PendingStatus INSTANCE = new PendingStatus();

        private PendingStatus() {
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatusType getType() {
            DatabaseSession.State.WorkStatusType workStatusType = DatabaseSession.State.WorkStatusType.UNKNOWN;
            if (workStatusType == null) {
                PendingStatus.$$$reportNull$$$0(0);
            }
            return workStatusType;
        }

        @Override
        @Nullable
        public DataRequest.CoupledWithEditor.ErrorNavigator getErrorNavigator() {
            return null;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/session/MessageBusSessionState$PendingStatus", "getType"));
        }
    }

    private static class Work
    implements DatabaseSession.State.Work {
        private final long myStart;
        private final DataRequest myRequest;
        private final DatabaseSession.State.WorkState myState;
        private final long myFinished;
        private final DatabaseSession.State.WorkStatus myStatus;

        /*
         * WARNING - void declaration
         */
        Work(@NotNull DataRequest request, @NotNull DatabaseSession.State.WorkState state, @NotNull DatabaseSession.State.WorkStatus status, long start2, long l) {
            void finished;
            if (request == null) {
                Work.$$$reportNull$$$0(0);
            }
            if (state == null) {
                Work.$$$reportNull$$$0(1);
            }
            if (status == null) {
                Work.$$$reportNull$$$0(2);
            }
            this.myStart = start2;
            this.myRequest = request;
            this.myState = state;
            this.myFinished = finished;
            this.myStatus = status;
        }

        @Override
        @NotNull
        public DataRequest getRequest() {
            DataRequest dataRequest = this.myRequest;
            if (dataRequest == null) {
                Work.$$$reportNull$$$0(3);
            }
            return dataRequest;
        }

        @NotNull
        public Work running(long time) {
            return new Work(this.myRequest, DatabaseSession.State.WorkState.RUNNING, this.myStatus, time, 0L);
        }

        @NotNull
        public Work error(@Nullable DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull String message2) {
            if (message2 == null) {
                Work.$$$reportNull$$$0(4);
            }
            return new Work(this.myRequest, DatabaseSession.State.WorkState.RUNNING, new ProblemStatus(DatabaseSession.State.WorkStatusType.ERROR, navigator, message2), this.myStart, 0L);
        }

        @NotNull
        public Work warning(@NotNull String message2) {
            if (message2 == null) {
                Work.$$$reportNull$$$0(5);
            }
            return new Work(this.myRequest, DatabaseSession.State.WorkState.RUNNING, new ProblemStatus(DatabaseSession.State.WorkStatusType.WARNING, null, message2), this.myStart, 0L);
        }

        @NotNull
        public Work stopped(long time) {
            DatabaseSession.State.WorkStatus status = this.myStatus.getType() == DatabaseSession.State.WorkStatusType.UNKNOWN ? (this.myState == DatabaseSession.State.WorkState.SUBMITTED ? this.myStatus : SuccessStatus.INSTANCE) : this.myStatus;
            return new Work(this.myRequest, DatabaseSession.State.WorkState.FINISHED, status, this.myStart, this.myState == DatabaseSession.State.WorkState.FINISHED ? this.myFinished : time);
        }

        @Override
        public long getTimeSpentMs() {
            return this.isFinished() ? this.myFinished - this.myStart : System.currentTimeMillis() - this.myStart;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkState getState() {
            DatabaseSession.State.WorkState workState = this.myState;
            if (workState == null) {
                Work.$$$reportNull$$$0(6);
            }
            return workState;
        }

        @Override
        @NotNull
        public DatabaseSession.State.WorkStatus getStatus() {
            DatabaseSession.State.WorkStatus workStatus = this.myStatus;
            if (workStatus == null) {
                Work.$$$reportNull$$$0(7);
            }
            return workStatus;
        }

        boolean isFinished() {
            return this.myFinished != 0L;
        }

        long getStartTime() {
            return this.myStart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/session/MessageBusSessionState$Work";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/session/MessageBusSessionState$Work";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequest";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "error";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "warning";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

