/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.script.generator.DefaultScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.editors.DdlPreview;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelTraverserEx
extends DdlPreview.ModelTraverser {
    private static final Condition<DeObject> NORMAL_EXPAND = object -> object.lightExported;
    private final Condition<DeObject> myModifiedChildExpand;
    private final SchemaApplyHelper myApplyHelper;
    private final ScriptGenerator myScriptGenerator;
    private final TableDialogSettings.Settings mySettings;
    private final EditorModelBase myModelBase;
    private final DeModel myModel;
    private ScriptingOptions myOptions;

    public ModelTraverserEx(@NotNull TableDialogSettings.Settings settings, @NotNull EditorModelBase modelBase, final @NotNull DeModel model, @Nullable DbDataSource dataSource2) {
        if (settings == null) {
            ModelTraverserEx.$$$reportNull$$$0(0);
        }
        if (modelBase == null) {
            ModelTraverserEx.$$$reportNull$$$0(1);
        }
        if (model == null) {
            ModelTraverserEx.$$$reportNull$$$0(2);
        }
        super(modelBase.getModel());
        this.myOptions = DefaultScriptingOptions.INSTANCE;
        this.mySettings = settings;
        this.myModelBase = modelBase;
        this.myModel = model;
        this.myModifiedChildExpand = new Condition<DeObject>(){

            public boolean value(DeObject object) {
                Collection<DeObject> ignoreChildren2;
                DeTable deEdited;
                DeTable table = (DeTable)ObjectUtils.tryCast((Object)object, DeTable.class);
                DeTable deTable = deEdited = table == null ? null : table.getEditedDeObject();
                if (deEdited == null) {
                    return NORMAL_EXPAND.value((Object)object);
                }
                Collection<DeObject> ignoreChildren1 = this.getIgnoredChildren(table);
                return !table.isAlteredIgnoringChild(deEdited, ignoreChildren1, ignoreChildren2 = this.getIgnoredChildren(deEdited));
            }

            @NotNull
            private Collection<DeObject> getIgnoredChildren(@Nullable DeTable deEdited) {
                Set set = deEdited != null ? JBIterable.from(deEdited.indices).append(deEdited.foreignKeys).append((Iterable)((Object)deEdited.keys)).filter(this::filterInternalDeclarations).toSet() : Collections.emptySet();
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private boolean filterInternalDeclarations(DeObject object) {
                SqlElement child = GenericEditingResultProcessor.getSqlElement(object, model.getExportHelper().getContext());
                SqlElement parent2 = GenericEditingResultProcessor.getSqlElement(object.getParent(), model.getExportHelper().getContext());
                return child == null || parent2 == null || !PsiTreeUtil.isAncestor((PsiElement)parent2, (PsiElement)child, (boolean)false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ModelTraverserEx$1", "getIgnoredChildren"));
            }
        };
        this.myApplyHelper = new SchemaApplyHelper(model.getExportHelper().getContext(), model);
        this.myScriptGenerator = ScriptGenerators.INSTANCE.byModel(this.myApplyHelper.getTargetModel());
    }

    @Override
    @NotNull
    public ScriptingResult generate() {
        Project project = this.myModel.getExportHelper().getContext().getProject();
        ScriptingResult scriptingResult = this.myScriptGenerator.makeScript(project, this.createTask());
        if (scriptingResult == null) {
            ModelTraverserEx.$$$reportNull$$$0(3);
        }
        return scriptingResult;
    }

    @Override
    public void setOptions(@NotNull ScriptingOptions options) {
        if (options == null) {
            ModelTraverserEx.$$$reportNull$$$0(4);
        }
        this.myOptions = options;
    }

    @Override
    @Nullable
    public ScriptingTask getTask() {
        return this.createTask();
    }

    @NotNull
    public ScriptingTask createTask() {
        BasicModel baseModel = SchemaApplyHelper.unwrapDeModel(this.myModel);
        boolean create = this.myModel.getDeModel() == null || baseModel == null || this.mySettings.codeType != TableDialogSettings.Settings.CodeType.ALTER_CODE;
        BasicModModel model = this.myApplyHelper.getTargetModel();
        if (create) {
            ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder((BasicModel)model, ScriptCategory.CREATE_COMPLETE);
            model.modify(BasicModRoot.class, r -> {
                this.myApplyHelper.markDirty();
                for (DdlPreview.ObjectAction action2 : this.traverse()) {
                    assert (action2.action == DdlPreview.ObjectAction.Action.CREATE);
                    BasicModElement target = this.myApplyHelper.apply(action2.object);
                    builder.getElements().add(target);
                }
                ObjectPath objectPath = SearchPath.getCurrent((SearchPath)this.myModel.getExportHelper().getContext().getSearchPath());
                BasicNamespace current = (BasicNamespace)QNameUtil.findByPath(model, objectPath).filter(BasicNamespace.class).first();
                builder.setCurrentNamespace(current);
                this.myApplyHelper.cleanup();
            });
            builder.setOptions(this.myOptions);
            ScriptingSingleModelTask scriptingSingleModelTask = builder.build();
            if (scriptingSingleModelTask == null) {
                ModelTraverserEx.$$$reportNull$$$0(5);
            }
            return scriptingSingleModelTask;
        }
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(baseModel, model);
        model.modify(BasicModRoot.class, r -> {
            this.myApplyHelper.markDirty();
            for (DdlPreview.ObjectAction action2 : this.traverse()) {
                BasicModElement target;
                BasicElement source = action2.action == DdlPreview.ObjectAction.Action.CREATE ? null : action2.object.unwrap();
                BasicModElement basicModElement = target = action2.action == DdlPreview.ObjectAction.Action.DROP ? null : this.myApplyHelper.apply(action2.object);
                assert (action2.action != DdlPreview.ObjectAction.Action.ALTER || source != null && target != null);
                ModelTraverserEx.processCorrespondence(builder.getCorrespondence(), ElementDelta.create(source, target));
                if (action2.action != DdlPreview.ObjectAction.Action.ALTER) continue;
                this.appendRecursive(action2.object, builder.getCorrespondence());
            }
            ObjectPath objectPath = SearchPath.getCurrent((SearchPath)this.myModel.getExportHelper().getContext().getSearchPath());
            BasicNamespace current = (BasicNamespace)QNameUtil.findByPath(baseModel, objectPath).filter(BasicNamespace.class).first();
            builder.setCurrentNamespace(current);
            this.myApplyHelper.cleanup();
        });
        builder.setOptions(this.myOptions);
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)this.myModel.getExportHelper().getContext().getDataSource());
        if (ds != null) {
            builder.setCodeStyleFrom(ds);
        }
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            ModelTraverserEx.$$$reportNull$$$0(6);
        }
        return scriptingAlterTask;
    }

    private void appendRecursive(DeObject object, Collection<ElementDelta<?>> correspondence) {
        BasicElement s;
        HashSet existing = new HashSet();
        for (DeObject child : object.getChildren()) {
            ContainerUtil.addIfNotNull(existing, (Object)child.getEditedDeObject());
            BasicElement t = this.myApplyHelper.getAlreadyApplied(child);
            if (t == null) continue;
            s = child.unwrap();
            ModelTraverserEx.processCorrespondence(correspondence, ElementDelta.create(s, t));
            if (s == null) continue;
            this.appendRecursive(child, correspondence);
        }
        DeObject source = object.getEditedDeObject();
        if (source != null) {
            for (DeObject child : source.getChildren()) {
                if (existing.contains(child) || (s = child.unwrap()) == null) continue;
                ModelTraverserEx.processCorrespondence(correspondence, ElementDelta.create(s, null));
            }
        }
    }

    private static void processCorrespondence(Collection<ElementDelta<?>> correspondence, ElementDelta<BasicElement> delta) {
        correspondence.add(delta);
        BasicElement o = (BasicElement)ObjectUtils.coalesce((Object)delta.getSourceElement(), (Object)delta.getTargetElement());
        if (o != null) {
            DbImplUtil.getModelHelper(o).ddlPreviewProcessCorrespondence(correspondence, delta);
        }
    }

    @Override
    @NotNull
    public JBIterable<DdlPreview.ObjectAction> traverse() {
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)this.model.traverser().withRoots(this.getRoots())).expandAndSkip(this.getExpansionMethod())).filter(DeObject.class).intercept(this.getActionGenerator());
        if (jBIterable == null) {
            ModelTraverserEx.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    private Function<Iterator<? extends DeObject>, Iterator<? extends DdlPreview.ObjectAction>> getActionGenerator() {
        Function function2 = iterator -> JBIterable.once((Iterator)iterator).flatten((Function)new GenericEditingResultProcessor.AppendDroppedSiblings(this.mySettings)).iterator();
        if (function2 == null) {
            ModelTraverserEx.$$$reportNull$$$0(8);
        }
        return function2;
    }

    @NotNull
    private JBIterable<? extends DeObject> getRoots() {
        JBIterable jBIterable = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.ALTER_CODE ? this.myModel.getModelRoots().filter(DeObject.class) : this.myModelBase.getEditedObjects();
        if (jBIterable == null) {
            ModelTraverserEx.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    private Condition<DeObject> getExpansionMethod() {
        boolean isReplace = this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.REPLACE_DDL;
        boolean isAppend = this.mySettings.finalAction == TableDialogSettings.Settings.FinalAction.APPEND_DDL;
        boolean isCreateNewCode = this.mySettings.codeType == TableDialogSettings.Settings.CodeType.CREATE_NEW_CODE;
        Condition<DeObject> condition = isReplace || isAppend && isCreateNewCode ? this.myModifiedChildExpand : NORMAL_EXPAND;
        if (condition == null) {
            ModelTraverserEx.$$$reportNull$$$0(10);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ModelTraverserEx";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ModelTraverserEx";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "traverse";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionGenerator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpansionMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

