/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbElement;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.actions.DumpAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.text.TextResultView;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.view.ui.DumpDataDialog;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpDataForm {
    private static final List<DataConsumer.Column> PREVIEW_COLUMNS = Arrays.asList(new DataConsumer.Column(0, "id", 4, "int", "java.lang.Integer"), new DataConsumer.Column(1, "first_name", 12, "varchar", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "varchar", "java.lang.String"), new DataConsumer.Column(3, "birth", 12, "varchar", "java.lang.String"));
    private static final List<DataConsumer.Row> PREVIEW_ROWS = Arrays.asList(DataConsumer.Row.create(0, new Object[]{10001, "Georgi", "Facello", "M", "1953-09-02"}), DataConsumer.Row.create(1, new Object[]{10002, "Bezalel", "Simmel", "F", "1964-06-02"}), DataConsumer.Row.create(2, new Object[]{10003, "Parto", "Bamford", "M", "1959-12-03"}), DataConsumer.Row.create(3, new Object[]{10004, "Chirstian", "Koblick", "M", "1954-05-01"}), DataConsumer.Row.create(4, new Object[]{10005, "Kyoichi", "Maliniak", "M", "1955-01-21"}), DataConsumer.Row.create(5, new Object[]{10006, "Anneke", "Preusig", "F", "1953-04-20"}), DataConsumer.Row.create(6, new Object[]{10007, "Tzvetan", "Zielinski", "F", "1957-05-23"}), DataConsumer.Row.create(7, new Object[]{10008, "Saniya", "Kalloufi", "M", "1958-02-19"}), DataConsumer.Row.create(8, new Object[]{10009, "Sumant", "Peac", "F", "1952-04-19"}), DataConsumer.Row.create(9, new Object[]{10010, "Duangkaew", "Piveteau", "F", "1963-06-01"}));
    private static final List<DataConsumer.Column> MONGO_PREVIEW_COLUMNS = Arrays.asList(new DataConsumer.Column(0, "_id", 1111, "objectId", "org.bson.types.ObjectId"), new DataConsumer.Column(1, "first_name", 12, "string", "java.lang.String"), new DataConsumer.Column(2, "last_name", 12, "string", "java.lang.String"), new DataConsumer.Column(3, "gender", 12, "string", "java.lang.String"), new DataConsumer.Column(4, "phones", 1111, "array", "java.lang.List"));
    private static final List<DataConsumer.Row> MONGO_PREVIEW_ROWS = Arrays.asList(DataConsumer.Row.create(0, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e5e7711f704714f53ebf2af"), "Georgi", "Facello", "M", Arrays.asList("136-73018", "458-97405")}), DataConsumer.Row.create(1, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6a"), "Bezalel", "Simmel", "F", Collections.singletonList("869-28540")}), DataConsumer.Row.create(2, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401e"), "Parto", "Bamford", "M", Arrays.asList("752-48018", "752-25445")}), DataConsumer.Row.create(3, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5e580fcbbdfc015d7d5d401f"), "Chirstian", "Koblick", "M", Collections.emptyList()}), DataConsumer.Row.create(4, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a70"), "Kyoichi", "Maliniak", "M", Collections.singletonList("985-85742")}), DataConsumer.Row.create(5, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6e"), "Anneke", "Preusig", "F", Collections.emptyList()}), DataConsumer.Row.create(6, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a6c"), "Tzvetan", "Zielinski", "F", Collections.singletonList("574-76427")}), DataConsumer.Row.create(7, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a79"), "Saniya", "Kalloufi", "M", Collections.singletonList("362-98543")}), DataConsumer.Row.create(8, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7a"), "Sumant", "Peac", "F", Arrays.asList("462-24753", "324524")}), DataConsumer.Row.create(9, new Object[]{new MongoJdbcHelper.MongoObjectIdValue("5ca4bbcea2dd94ee58162a7c"), "Duangkaew", "Piveteau", "F", Collections.singletonList("356-08750")}));
    private static final int MAX_ROWS_FOR_PREVIEW = 10;
    private static final int MAX_SOURCE_HEIGHT = 100;
    private static final Logger LOG = Logger.getInstance(DumpDataForm.class);
    private static final Set<String> EXTRACTORS_NO_TRANSPOSE = ContainerUtil.set((Object[])new String[]{"SQL-Insert-Statements.sql.groovy", "JSON-Groovy.json.groovy"});
    private final DumpDataDialog myDialog;
    private final Project myProject;
    private final DumpAction.DumpSource mySource;
    private final EditorEx myViewer;
    public JPanel myPanel;
    private JBCheckBox myAddComputed;
    private JBCheckBox myAddGenerated;
    private JBCheckBox myAddTableDefinition;
    private LabeledComponent<JComponent> myPreviewLabeledComponent;
    private JBCheckBox myTranspose;
    private JBLabel myAddColumnsLabel;
    private LabeledComponent<JBTextField> myFileName;
    private LabeledComponent<TextFieldWithBrowseButton> myOutputDirectory;
    private LabeledComponent<ComboBox<DataExtractorFactory>> myExtractorCombobox;
    private LabeledComponent<JBScrollPane> mySourceLabeledComponent;
    private JBCheckBox myAddColumnHeader;
    private JBCheckBox myAddRowHeader;

    public DumpDataForm(@NotNull DumpDataDialog dialog2, @NotNull Project project, @NotNull String defaultName, @NotNull DumpAction.DumpSource source) {
        if (dialog2 == null) {
            DumpDataForm.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DumpDataForm.$$$reportNull$$$0(1);
        }
        if (defaultName == null) {
            DumpDataForm.$$$reportNull$$$0(2);
        }
        if (source == null) {
            DumpDataForm.$$$reportNull$$$0(3);
        }
        this.myDialog = dialog2;
        this.myProject = project;
        this.mySource = source;
        this.$$$setupUI$$$();
        String sourceText = DumpDataForm.getSourceText(this.mySource);
        if (sourceText == null) {
            this.mySourceLabeledComponent.setVisible(false);
        } else {
            JEditorPane pane = new JEditorPane();
            pane.setMargin((Insets)JBUI.insets((int)5));
            pane.setEditable(false);
            pane.setText(sourceText);
            pane.setBackground(UIUtil.getPanelBackground());
            JBScrollPane scrollPane = (JBScrollPane)this.mySourceLabeledComponent.getComponent();
            scrollPane.setViewportView((Component)pane);
            if (scrollPane.getPreferredSize().height > 100) {
                scrollPane.setPreferredSize(new Dimension(-1, 100));
            }
        }
        ArrayList<DataExtractorFactory> factories = new ArrayList<DataExtractorFactory>();
        factories.addAll(DataExtractorFactories.getLegacy());
        factories.addAll(DataExtractorFactories.getCsvFormats());
        List scripts = DataExtractorFactories.getScripts();
        scripts = ContainerUtil.sorted(scripts, Comparator.comparing(s -> StringUtil.toLowerCase((String)s.getName())));
        factories.addAll(scripts);
        String currentFactoryName = DataExtractorProperties.getCurrentExtractorFactory(this.myProject).getName();
        ComboBox comboBox = (ComboBox)this.myExtractorCombobox.getComponent();
        comboBox.setSwingPopup(false);
        comboBox.setModel(new DefaultComboBoxModel<DataExtractorFactory>(factories.toArray(new DataExtractorFactory[0])));
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", DataExtractorFactories::getDisplayName));
        DataExtractorFactory currentFactory = (DataExtractorFactory)ContainerUtil.find(factories, factory -> currentFactoryName.equals(factory.getName()));
        comboBox.setSelectedItem((Object)currentFactory);
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateCheckboxes();
                this.updateFileExtension();
            }
        });
        this.updateCheckboxes();
        this.myAddComputed.setSelected(!DataExtractorProperties.isSkipComputed());
        this.myAddComputed.addItemListener(e -> this.settingsChanged());
        this.myAddGenerated.setSelected(!DataExtractorProperties.isSkipGeneratedColumns());
        this.myAddGenerated.addItemListener(e -> this.settingsChanged());
        this.myAddTableDefinition.setSelected(DataExtractorProperties.isIncludeCreateTable());
        this.myAddTableDefinition.addItemListener(e -> this.settingsChanged());
        this.myTranspose.setSelected(this.mySource instanceof DumpAction.DataGridSource && ((DumpAction.DataGridSource)this.mySource).getGrid().getResultView().isTransposed());
        this.myTranspose.addItemListener(e -> this.settingsChanged());
        this.myAddColumnHeader.addItemListener(e -> this.settingsChanged());
        this.myAddRowHeader.addItemListener(e -> this.settingsChanged());
        ((TextFieldWithBrowseButton)this.myOutputDirectory.getComponent()).addBrowseFolderListener(DatabaseBundle.message((String)"settings.database.DumpDialog.FileChooser.Title", (Object[])new Object[0]), null, project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        ((TextFieldWithBrowseButton)this.myOutputDirectory.getComponent()).setText(DataExtractorProperties.getOutputDir());
        ((JBTextField)this.myFileName.getComponent()).setText(defaultName + "." + currentFactory.getFileExtension());
        ((JBTextField)this.myFileName.getComponent()).addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                String fileName = ((JBTextField)DumpDataForm.this.myFileName.getComponent()).getText();
                String name = FileUtilRt.getNameWithoutExtension((String)fileName);
                ((JBTextField)DumpDataForm.this.myFileName.getComponent()).select(0, name.length());
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.myFileName.setVisible(DumpAction.getSize(source) == 1);
        this.myViewer = TextResultView.createEditor(this.myProject, "dumpDataPreview");
        Disposer.register((Disposable)dialog2.getDisposable(), () -> EditorFactory.getInstance().releaseEditor((Editor)this.myViewer));
        this.myPreviewLabeledComponent.setComponent(this.myViewer.getComponent());
        comboBox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.settingsChanged();
            }
        });
    }

    @Nullable
    private static String getSourceText(@Nullable DumpAction.DumpSource source) {
        if (source instanceof DumpAction.DataGridSource) {
            DasTable table = DataGridUtil.getDatabaseTable(((DumpAction.DataGridSource)source).getGrid());
            return table == null ? null : QNameUtil.getQualifiedName((DasObject)table);
        }
        if (source instanceof DumpAction.DbTablesSource) {
            StringBuilder sb = new StringBuilder();
            for (Object target : ((DumpAction.DbTablesSource)source).getTables()) {
                if (!(target instanceof DbElement)) continue;
                if (sb.length() != 0) {
                    sb.append("\n");
                }
                sb.append(QNameUtil.getQualifiedName((DbElement)target));
            }
            return sb.length() == 0 ? null : sb.toString();
        }
        return null;
    }

    @NotNull
    public JTextField getFileNameField() {
        JTextField jTextField = (JTextField)this.myFileName.getComponent();
        if (jTextField == null) {
            DumpDataForm.$$$reportNull$$$0(4);
        }
        return jTextField;
    }

    @NotNull
    public JTextField getOutputDirectoryField() {
        JTextField jTextField = ((TextFieldWithBrowseButton)this.myOutputDirectory.getComponent()).getTextField();
        if (jTextField == null) {
            DumpDataForm.$$$reportNull$$$0(5);
        }
        return jTextField;
    }

    @NotNull
    public ComboBox<DataExtractorFactory> getExtractorComboBox() {
        ComboBox comboBox = (ComboBox)this.myExtractorCombobox.getComponent();
        if (comboBox == null) {
            DumpDataForm.$$$reportNull$$$0(6);
        }
        return comboBox;
    }

    private void updateFileExtension() {
        DataExtractorFactory factory = this.getFactory();
        String fileName = ((JBTextField)this.myFileName.getComponent()).getText();
        if (factory == null || !this.myFileName.isVisible() || StringUtil.isEmptyOrSpaces((String)fileName)) {
            return;
        }
        if (FileUtilRt.extensionEquals((String)fileName, (String)factory.getFileExtension())) {
            return;
        }
        String name = FileUtilRt.getNameWithoutExtension((String)fileName);
        ((JBTextField)this.myFileName.getComponent()).setText(name + "." + factory.getFileExtension());
    }

    private void updateCheckboxes() {
        DataExtractorFactory factory = this.getFactory();
        if (factory == null) {
            return;
        }
        this.myTranspose.setEnabled(DumpDataForm.supportsTranspose(factory));
        this.myAddTableDefinition.setEnabled(DumpDataForm.supportsAddTableDefinition(factory));
        boolean supportsComputedOrGenerated = DumpDataForm.supportsAddComputedOrGeneratedColumns(factory);
        this.myAddColumnsLabel.setEnabled(supportsComputedOrGenerated);
        this.myAddComputed.setEnabled(supportsComputedOrGenerated);
        this.myAddGenerated.setEnabled(supportsComputedOrGenerated);
        this.myAddColumnHeader.setEnabled(factory instanceof DataExtractorFactories.Format);
        this.myAddRowHeader.setEnabled(factory instanceof DataExtractorFactories.Format);
        if (factory instanceof DataExtractorFactories.Format) {
            CsvFormat format = ((DataExtractorFactories.Format)factory).getFormat();
            this.myAddColumnHeader.setSelected(format.headerRecord != null);
            this.myAddRowHeader.setSelected(format.rowNumbers);
        }
    }

    @Nullable
    private DataExtractorFactory getFactory() {
        return (DataExtractorFactory)ObjectUtils.tryCast((Object)((ComboBox)this.myExtractorCombobox.getComponent()).getSelectedItem(), DataExtractorFactory.class);
    }

    private static boolean supportsAddComputedOrGeneratedColumns(DataExtractorFactory factory) {
        return factory instanceof DataExtractorFactories.SqlInserts;
    }

    private static boolean supportsTranspose(DataExtractorFactory factory) {
        return !(factory instanceof DataExtractorFactories.SqlInserts) && !(factory instanceof DataExtractorFactories.SqlUpdates) && !(factory instanceof DataExtractorFactories.Xlsx) && (!(factory instanceof DataExtractorFactories.Script) || !EXTRACTORS_NO_TRANSPOSE.contains(factory.getName()));
    }

    private static boolean supportsAddTableDefinition(DataExtractorFactory factory) {
        return factory instanceof DataExtractorFactories.SqlInserts;
    }

    private void settingsChanged() {
        this.saveState();
        ApplicationManager.getApplication().invokeLater(() -> this.updatePreview(), ModalityState.stateForComponent((Component)this.myDialog.getWindow()));
    }

    void updatePreview() {
        DataExtractor extractor;
        List<DataConsumer.Column> columns;
        List<DataConsumer.Row> rows;
        DataGrid grid = this.mySource instanceof DumpAction.DataGridSource ? ((DumpAction.DataGridSource)this.mySource).getGrid() : null;
        DasTable table = grid != null ? DataGridUtil.getDatabaseTable(grid) : null;
        Dbms dbms = DumpAction.getDbms(this.mySource);
        if (grid != null) {
            GridModel model = grid.getDataModel(DataAccessType.DATABASE_DATA);
            rows = model.getRows(ModelIndexSet.forRows(grid, IntStream.range(0, Math.min(10, model.getRowCount())).toArray()));
            columns = model.getColumns();
        } else {
            rows = dbms.isMongo() ? MONGO_PREVIEW_ROWS : PREVIEW_ROWS;
            columns = dbms.isMongo() ? MONGO_PREVIEW_COLUMNS : PREVIEW_COLUMNS;
        }
        DataExtractorFactory extractorFactory = this.getFactory();
        DataExtractor dataExtractor = extractorFactory == null ? null : (extractor = extractorFactory.createExtractor(this.myProject, dbms, grid != null ? grid.getObjectFormatter() : null, table));
        if (extractor == null) {
            LOG.error("Cannot create data extractor. DataExtractorFactory: " + (extractorFactory == null ? "unknown" : extractorFactory.getName()));
            TextResultView.updateEditorText(this.myViewer, this.myProject, "", (Language)PlainTextLanguage.INSTANCE);
            return;
        }
        if (extractor instanceof DataExtractor.Binary) {
            TextResultView.updateEditorText(this.myViewer, this.myProject, "Extractor is binary. Preview is not available", (Language)PlainTextLanguage.INSTANCE);
            return;
        }
        StringBuilder sb = new StringBuilder();
        ExtractorsUtil.extract(CharOut.Util.newSink(sb), DumpAction.getDbms(this.mySource), this.getExtractorConfig(), columns, (DataExtractor.Text)extractor, rows, grid != null ? grid.getVisibleColumns().asArray() : new int[]{});
        TextResultView.updateEditorText(this.myViewer, this.myProject, sb.toString(), this.guessLanguage());
    }

    @NotNull
    private Language guessLanguage() {
        DataExtractorFactory selectedFactory = this.getFactory();
        return DumpDataForm.guessLanguage(selectedFactory == null ? null : selectedFactory.getFileExtension());
    }

    @NotNull
    private static Language guessLanguage(@Nullable String extension) {
        if (extension == null) {
            PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
            if (plainTextLanguage == null) {
                DumpDataForm.$$$reportNull$$$0(7);
            }
            return plainTextLanguage;
        }
        Language language = (Language)ObjectUtils.notNull((Object)LanguageUtil.getFileTypeLanguage((FileType)FileTypeRegistry.getInstance().getFileTypeByExtension(extension)), (Object)PlainTextLanguage.INSTANCE);
        if (language == null) {
            DumpDataForm.$$$reportNull$$$0(8);
        }
        return language;
    }

    public ExtractionConfig getExtractorConfig() {
        return new ExtractionConfig(this.myAddTableDefinition.isSelected(), this.myTranspose.isSelected(), this.myAddComputed.isSelected(), this.myAddGenerated.isSelected(), this.myAddColumnHeader.isSelected(), this.myAddRowHeader.isSelected());
    }

    public void saveState() {
        DataExtractorProperties.setSkipComputed(!this.myAddComputed.isSelected());
        DataExtractorProperties.setSkipGeneratedColumns(!this.myAddGenerated.isSelected());
        DataExtractorProperties.setIncludeCreateTable(this.myAddTableDefinition.isSelected());
        DataExtractorProperties.setOutputDir(((TextFieldWithBrowseButton)this.myOutputDirectory.getComponent()).getText());
        DataExtractorFactory factory = this.getFactory();
        if (factory != null) {
            DataExtractorProperties.setCurrentExtractorFactory(this.myProject, factory);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox6;
        LabeledComponent labeledComponent5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 3, 1, 0, 3, 3, 3, null, new Dimension(400, 500), null));
        this.myPreviewLabeledComponent = labeledComponent5 = new LabeledComponent();
        labeledComponent5.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent5.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Preview"));
        jPanel2.add((Component)labeledComponent5, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 2, 1, 8, 2, 1, 3, new Dimension(400, -1), new Dimension(400, -1), new Dimension(400, -1)));
        this.myAddComputed = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.ComputedColumns"));
        jPanel3.add((Component)jBCheckBox6, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 0, null, null, null));
        this.myAddColumnsLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddColumns"));
        jPanel3.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAddGenerated = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.GeneratedColumns"));
        jPanel3.add((Component)jBCheckBox5, new GridConstraints(3, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 3, 1, 1, 0, 1, 2, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(8, 2, 1, 2, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        this.myTranspose = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Transpose"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddTableDefinition = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddTableDefinition"));
        jPanel3.add((Component)jBCheckBox3, new GridConstraints(7, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myFileName = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setComponentClass("com.intellij.ui.components.JBTextField");
        labeledComponent4.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.FileName"));
        jPanel3.add((Component)labeledComponent4, new GridConstraints(9, 0, 1, 4, 0, 1, 3, 3, null, null, null));
        this.myOutputDirectory = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.SaveTo"));
        jPanel3.add((Component)labeledComponent3, new GridConstraints(10, 0, 1, 4, 0, 1, 3, 3, null, null, null));
        this.myExtractorCombobox = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.ComboBox");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Extractor"));
        jPanel3.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 4, 8, 0, 3, 3, null, new Dimension(295, -1), new Dimension(295, -1)));
        this.mySourceLabeledComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.ui.components.JBScrollPane");
        labeledComponent.setLabelInsets(new Insets(0, 0, 5, 0));
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.Source"));
        jPanel3.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 4, 1, 1, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 2, null, new Dimension(-1, 10), null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(11, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myAddColumnHeader = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddColumnHeader"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.myAddRowHeader = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DumpDataForm.class).getString("settings.database.DumpDialog.AddRowHeader"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 4, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DumpDataForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DumpDataForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputDirectoryField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorComboBox";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

