/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCompletionScopeProcessor
extends SqlScopeProcessor {
    @Nullable
    private final SqlElement myRefElement;
    @Nullable
    private final ObjectKind myPrimaryKind;
    private final boolean myAddColumns;
    @NotNull
    private final CamelHumpMatcher myAdjustedMatcher;
    @NotNull
    private final Consumer<LookupElement> myResultSet;
    private final boolean myMissingFrom;
    private final boolean myFilterPgRoutines;
    @NotNull
    private final SqlType myQualifierType;
    @NotNull
    private final Set<ObjectKind> myExpectedTypesStrict;
    @Nullable
    private final BiConsumer<? super DasObject, PsiElement> myAcceptedElementConsumer;
    private final CompletionParameters myCompletionParameters;
    boolean myEmpty;
    boolean myTablesBlocked;
    @NotNull
    private final NotNullLazyValue<Collection<SqlType>> myExpectedSqlTypes;
    private boolean myHasAcceptedCompletionVariants;
    @NotNull
    private final Set<ObjectPath> addedPaths;

    public SqlCompletionScopeProcessor(@NotNull SqlLanguageDialectEx dialect, @NotNull List<DbDataSource> dataSources2, @Nullable SqlElement refElement, boolean addColumns, @NotNull CamelHumpMatcher adjustedMatcher, @NotNull Consumer<LookupElement> resultSet, boolean missingFrom, boolean filterPgRoutines, @NotNull SqlType qualifierType, @NotNull Set<ObjectKind> expectedTypesStrict, @NotNull CompletionParameters completionParameters, @Nullable BiConsumer<? super DasObject, PsiElement> acceptedElementConsumer) {
        if (dialect == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(0);
        }
        if (dataSources2 == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(1);
        }
        if (adjustedMatcher == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(3);
        }
        if (qualifierType == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(4);
        }
        if (expectedTypesStrict == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(5);
        }
        if (completionParameters == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(6);
        }
        super(null, dialect, dataSources2, (PsiElement)refElement);
        this.myHasAcceptedCompletionVariants = false;
        this.addedPaths = new HashSet<ObjectPath>();
        this.myRefElement = refElement;
        this.myPrimaryKind = refElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)refElement).getReferenceElementType().getTargetKind() : null;
        this.myAddColumns = addColumns;
        this.myAdjustedMatcher = adjustedMatcher;
        this.myResultSet = resultSet;
        this.myMissingFrom = missingFrom;
        this.myFilterPgRoutines = filterPgRoutines;
        this.myQualifierType = qualifierType;
        this.myExpectedTypesStrict = expectedTypesStrict;
        this.myAcceptedElementConsumer = acceptedElementConsumer;
        this.myCompletionParameters = completionParameters;
        this.myEmpty = true;
        this.myExpectedSqlTypes = this.place == null ? NotNullLazyValue.createConstantValue((Object)ContainerUtil.emptyList()) : new NotNullLazyValue<Collection<SqlType>>(){
            SmartPsiElementPointer myPointer;
            {
                this.myPointer = SmartPointerManager.createPointer((PsiElement)SqlCompletionScopeProcessor.this.place);
            }

            @NotNull
            protected Collection<SqlType> compute() {
                Collection<SqlType> collection = SqlFunctionsUtil.evaluateExpectedTypesForArgument(this.myPointer.getElement());
                if (collection == null) {
                    1.$$$reportNull$$$0(0);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/completion/SqlCompletionScopeProcessor$1", "compute"));
            }
        };
    }

    public final CompletionParameters getCompletionParameters() {
        return this.myCompletionParameters;
    }

    public boolean hasAcceptedCompletionVariants() {
        return this.myHasAcceptedCompletionVariants;
    }

    @Override
    public boolean isResultEmpty() {
        return this.myEmpty;
    }

    @Override
    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(7);
        }
        if (event == IGNORE_TYPE && ((Set)associated).contains(ObjectKind.TABLE)) {
            this.myTablesBlocked = true;
        }
        super.handleEvent(event, associated);
    }

    @Override
    public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element2, @Nullable SqlType sqlType, @Nullable Boolean forcedCaseSens, @NotNull ResolveState state) {
        Consumer<LookupElement> consumer2;
        if (element2 == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(8);
        }
        if (state == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(9);
        }
        if (!(this.myCompletionParameters.getInvocationCount() > 1 || target == null || target.getKind() != ObjectKind.DATABASE && target.getKind() != ObjectKind.SCHEMA || this.getExpectedTypes().contains(target.getKind()))) {
            return true;
        }
        if (SqlFileImpl.isEmptyFakeNamespace(target)) {
            return true;
        }
        if (this.myAddColumns && target instanceof DasTable) {
            for (DasColumn column : DasUtil.getColumns((DasObject)target)) {
                if (this.myAcceptedElementConsumer != null) {
                    this.myAcceptedElementConsumer.accept((DasObject)column, null);
                }
                if (!this.myAdjustedMatcher.prefixMatches(column.getName())) continue;
                boolean added = this.addLookupElement(column, null, this.myResultSet, null, false);
                this.myEmpty = added && this.myEmpty;
                this.myHasAcceptedCompletionVariants = added;
            }
        }
        PsiElement qualifier = SqlImplUtil.getQualifier(state);
        if (target != null) {
            if (this.myAcceptedElementConsumer != null) {
                this.myAcceptedElementConsumer.accept((DasObject)target, qualifier);
            }
            if (!this.myAdjustedMatcher.prefixMatches(target.getName())) {
                return true;
            }
        } else if (element2 instanceof SqlReferenceExpression) {
            String name;
            SqlIdentifier identifier = ((SqlReferenceExpression)element2).getIdentifier();
            String prefix = identifier == null ? null : identifier.getNamePrefix();
            String string = name = prefix == null ? ((SqlReferenceExpression)element2).getName() : prefix + ((SqlReferenceExpression)element2).getName();
            if (!this.myAdjustedMatcher.prefixMatches(name)) {
                return true;
            }
        } else {
            return true;
        }
        boolean weightDown = false;
        if (!this.checkType(ObjectUtils.notNull((Object)target, (Object)element2), sqlType)) {
            if (!(this.myMissingFrom && this.myTablesBlocked && this.checkType(ObjectUtils.notNull((Object)target, (Object)element2), sqlType, this.getInitialExpectedTypes(), Collections.emptySet(), false))) {
                return true;
            }
            weightDown = true;
        }
        if (this.myFilterPgRoutines && target instanceof DasRoutine) {
            DasArgument arg;
            if (target instanceof DbElement) {
                target = (DasObject)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), DasRoutine.class);
            }
            if ((arg = (DasArgument)SqlFunctionsUtil.getAcceptedArguments(target).single()) == null || !SqlFunctionsUtil.isAssignable((DasTypedObject)arg, this.myQualifierType, this.dialect)) {
                return true;
            }
        }
        Consumer<LookupElement> consumer3 = consumer2 = weightDown ? e -> this.myResultSet.consume((Object)PrioritizedLookupElement.withPriority((LookupElement)e, (double)0.0)) : this.myResultSet;
        if (target instanceof ReservedEntity && (sqlType != null || ((ReservedEntity)target).kind == ObjectKind.OBJECT_TYPE)) {
            consumer2.consume((Object)SqlCompletionUtil.createEntityLookupItem(element2.getContainingFile(), target.getName(), sqlType, target.getKind(), SqlCompletionScopeProcessor.shouldPreserveCase(target, element2, forcedCaseSens)));
            this.myEmpty = false;
            this.myHasAcceptedCompletionVariants = true;
        } else {
            Object delegate = target instanceof DbElement ? ((DbElement)target).getDelegate() : null;
            boolean addDot = !this.checkType(element2, sqlType, this.myExpectedTypesStrict, this.getIgnoredTypes(), true);
            Object lookupElement = delegate instanceof PsiElement ? delegate : element2;
            boolean added = this.addLookupElement(lookupElement, qualifier, consumer2, (PsiElement)this.myRefElement, addDot);
            this.myEmpty = added && this.myEmpty;
            this.myHasAcceptedCompletionVariants = added;
        }
        return true;
    }

    private boolean addLookupElement(@NotNull Object lookupElement, @Nullable PsiElement qualifier, @NotNull Consumer<LookupElement> consumer2, @Nullable PsiElement context, boolean addDot) {
        if (lookupElement == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(11);
        }
        Consumer actualConsumer = this.addLookupPath(lookupElement, qualifier) ? consumer2 : EmptyConsumer.getInstance();
        double forcePriority = lookupElement instanceof DasObject && ((DasObject)lookupElement).getKind() == this.myPrimaryKind ? 50.0 : 0.0;
        return SqlCompletionUtil.addLookupElement(this.dialect, this.place != null ? SqlImplUtil.getDbms(this.place) : this.dialect.getDbms(), lookupElement, qualifier, (Consumer<? super LookupElement>)actualConsumer, addDot, forcePriority, context, (Collection)this.myExpectedSqlTypes.getValue());
    }

    @Nullable
    private boolean addLookupPath(@Nullable Object lookupElement, @Nullable PsiElement qualifier) {
        if (!(lookupElement instanceof DasObject)) {
            return true;
        }
        DasObject dasLookup = (DasObject)lookupElement;
        if (qualifier == null) {
            return this.addedPaths.add(ObjectPaths.of(dasLookup));
        }
        if (!(qualifier instanceof DasObject)) {
            return true;
        }
        ObjectPath qualifierPath = ObjectPaths.of((DasObject)qualifier);
        ObjectPath path = ObjectPath.create((String)dasLookup.getName(), (ObjectKind)dasLookup.getKind(), (boolean)DbSqlUtil.isQuoted(dasLookup), (String)ObjectPaths.getIdentity(dasLookup), (ObjectPath)qualifierPath);
        return this.addedPaths.add(path);
    }

    private static boolean shouldPreserveCase(@NotNull DasObject target, @NotNull PsiElement element2, @Nullable Boolean forcedCaseSens) {
        Casing casing;
        if (target == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(12);
        }
        if (element2 == null) {
            SqlCompletionScopeProcessor.$$$reportNull$$$0(13);
        }
        if (forcedCaseSens == Boolean.TRUE) {
            return true;
        }
        PsiFile containingFile = element2.getContainingFile();
        return containingFile instanceof CasingProvider && Casing.EXACT.equals((Object)(casing = ((CasingProvider)containingFile).getCasing(target.getKind(), target)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjustedMatcher";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypesStrict";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/completion/SqlCompletionScopeProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleEvent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTarget";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldPreserveCase";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

