/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.database.Dbms;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.Case;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.completion.SqlCompletionUtil;
import com.intellij.sql.completion.SqlQualifiedResolveResult;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.editor.SqlEditorOptions;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlPrefixedElement;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlInsertHandlers {
    public static final InsertHandler<LookupElement> TEMPLATE_SAFE_INSERT_HANDLER = new TemplateSafeInsertHandler("", false);
    public static final InsertHandler<LookupElement> DOT_INSERT_HANDLER = (context, item) -> {
        if (context.getCompletionChar() != '.') {
            boolean alreadyDot;
            String text2 = context.getDocument().getText();
            boolean bl = alreadyDot = text2.length() > context.getTailOffset() && text2.charAt(context.getTailOffset()) == '.';
            if (!alreadyDot) {
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)".");
            }
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            AutoPopupController.getInstance((Project)context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    };
    public static final InsertHandler<LookupElement> INSIDE_QUOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            LeafPsiElement leaf;
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            Document document = context.getDocument();
            CharSequence text2 = document.getCharsSequence();
            int end2 = context.getTailOffset();
            SqlReferenceExpression reference = (SqlReferenceExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), SqlReferenceExpression.class, (boolean)false);
            if (reference != null && !reference.isQuotedIdentifier()) {
                return;
            }
            SqlReferenceExpression anchor = reference;
            if (anchor == null && (leaf = (LeafPsiElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), LeafPsiElement.class, (boolean)false)) != null && leaf.getElementType() == SqlTokens.SQL_UNCLOSED_TOKEN) {
                anchor = leaf;
            }
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)context.getFile());
            char closeQuote = this.guessQuote((PsiElement)anchor, NamingServices.getNamingService(dbms).closeQuote());
            if (end2 >= text2.length() || text2.charAt(end2) != closeQuote) {
                document.insertString(end2, (CharSequence)String.valueOf(closeQuote));
            }
            context.getEditor().getCaretModel().moveToOffset(context.getEditor().getCaretModel().getOffset() + 1);
            context.setTailOffset(end2 + 1);
        }

        private char guessQuote(@Nullable PsiElement anchor, char dialectQuote) {
            if (anchor == null) {
                return dialectQuote;
            }
            String text2 = (String)ContainerUtil.getLastItem((List)StringUtil.split((String)anchor.getText(), (String)"."));
            char c2 = text2 == null ? (char)' ' : (char)text2.charAt(0);
            return c2 == '\"' || c2 == '\'' ? c2 : dialectQuote;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$1";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final InsertHandler<LookupElement> ADD_TABLE_ALIAS_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int offset;
            PsiFile file;
            PsiReference reference;
            if (context == null) {
                2.$$$reportNull$$$0(0);
            }
            if (item == null) {
                2.$$$reportNull$$$0(1);
            }
            if (!((reference = (file = context.getFile()).findReferenceAt((offset = context.getTailOffset()) - 1)) instanceof SqlReferenceImpl) || ((SqlReferenceImpl)reference).getReferenceElementType() != SqlCompositeElementTypes.SQL_TABLE_REFERENCE) {
                return;
            }
            PsiElement element2 = reference.getElement();
            if (!(element2 instanceof SqlReferenceExpression)) {
                return;
            }
            PsiElement resolveResult = ((SqlReferenceExpression)element2).resolve();
            if (!(resolveResult instanceof DasTable)) {
                return;
            }
            String aliasName = SqlNamesGenerator.suggestAliasName(((DasTable)resolveResult).getName(), element2);
            context.getDocument().insertString(offset, (CharSequence)(" " + aliasName));
            context.getEditor().getCaretModel().moveToOffset(offset + aliasName.length() + 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$2";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> INSIDE_QUOT_DOT_INSERT_HANDLER = SqlInsertHandlers.chainHandlers(INSIDE_QUOT_INSERT_HANDLER, DOT_INSERT_HANDLER);
    public static final InsertHandler<LookupElement> QUOT_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int endOff;
            boolean rightIsQuote;
            String toInsertQuoted;
            if (context == null) {
                3.$$$reportNull$$$0(0);
            }
            if (item == null) {
                3.$$$reportNull$$$0(1);
            }
            if (this.isForBuiltInFunction(item)) {
                return;
            }
            Dbms dbms = SqlImplUtil.getDbms((PsiElement)context.getFile());
            NamingService namingService = NamingServices.getNamingService(dbms);
            String toInsert = item.getLookupString();
            SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings(context.getFile());
            String openQuotes = settings.getQuotesPriority();
            String string = settings.QUOTE_IDENTIFIER == 0 ? namingService.enquoteName(toInsert, openQuotes) : (toInsertQuoted = dbms != Dbms.UNKNOWN ? namingService.nameToScript(toInsert, false, openQuotes) : toInsert);
            if (toInsert.equals(toInsertQuoted)) {
                return;
            }
            Document document = context.getDocument();
            CharSequence text2 = document.getCharsSequence();
            int start2 = context.getStartOffset();
            int end2 = context.getTailOffset();
            char leftChar = start2 > 0 ? text2.charAt(start2 - 1) : (char)'\u0000';
            char rightExpected = ((Character)ObjectUtils.notNull((Object)namingService.closeQuote(leftChar), (Object)Character.valueOf('\u0000'))).charValue();
            boolean leftIsQuote = rightExpected != '\u0000';
            char rightChar = end2 < document.getTextLength() ? text2.charAt(end2) : (char)'\u0000';
            boolean bl = rightIsQuote = namingService.closeQuotes().indexOf(rightChar) != -1;
            if (!leftIsQuote) {
                document.insertString(start2, (CharSequence)toInsertQuoted.substring(0, 1));
            }
            int n = endOff = !leftIsQuote ? 1 : 0;
            if (leftIsQuote && (!rightIsQuote || rightExpected != rightChar)) {
                document.insertString(end2 + endOff, (CharSequence)String.valueOf(rightExpected));
            } else if (!leftIsQuote) {
                document.insertString(end2 + endOff, (CharSequence)toInsertQuoted.substring(toInsertQuoted.length() - 1));
            }
            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
        }

        private boolean isForBuiltInFunction(@NotNull LookupElement item) {
            if (item == null) {
                3.$$$reportNull$$$0(2);
            }
            return item.getObject() instanceof SqlFunctionDefinition.Prototype;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/sql/completion/SqlInsertHandlers$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isForBuiltInFunction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> QUOT_DOT_INSERT_HANDLER = SqlInsertHandlers.chainHandlers(QUOT_INSERT_HANDLER, DOT_INSERT_HANDLER);
    public static final InsertHandler<LookupElement> NEW_LINE_INSERT_HANDLER = new InsertHandler<LookupElement>(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            int lineEnd;
            if (context == null) {
                4.$$$reportNull$$$0(0);
            }
            if (item == null) {
                4.$$$reportNull$$$0(1);
            }
            String text2 = context.getDocument().getText();
            boolean insert = true;
            int offset = context.getTailOffset();
            if (text2.length() > offset && (lineEnd = context.getDocument().getLineEndOffset(context.getDocument().getLineNumber(offset))) > offset && !StringUtil.isEmptyOrSpaces((String)context.getDocument().getText(TextRange.create((int)offset, (int)lineEnd)))) {
                insert = false;
            }
            if (insert) {
                context.getDocument().insertString(offset, (CharSequence)"\n");
                context.getEditor().getCaretModel().moveToOffset(offset + 1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "item";
                    break;
                }
            }
            objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$4";
            objectArray[2] = "handleInsert";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final InsertHandler<LookupElement> DUMMY_HANDLER = (context, item) -> {};
    static final InsertHandler<LookupElement> WHITESPACE_PROTECTED = new TemplateSafeInsertHandler(",;", false);
    static final InsertHandler<LookupElement> WHITESPACE_POPUP_PROTECTED = new TemplateSafeInsertHandler(",;", true);
    public static final InsertHandler<LookupElement> ADD_RPAREN_LOOKUP_HANDLER = (context, item) -> {
        if (context.getCompletionChar() != ')') {
            SqlValuesExpression values2;
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            context.commitDocument();
            int offset = context.getTailOffset();
            PsiElement at = context.getFile().findElementAt(offset > 1 ? offset - 1 : offset);
            SqlElement tcl = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)at, SqlTableColumnsList.class);
            if (tcl == null) {
                tcl = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)at, SqlReferenceList.class);
            }
            if ((values2 = (SqlValuesExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)tcl, SqlValuesExpression.class)) != null) {
                return;
            }
            SqlReferenceList list = (SqlReferenceList)PsiTreeUtil.getParentOfType((PsiElement)at, SqlReferenceList.class);
            if (list != null) {
                ASTNode right = list.getNode().findChildByType((IElementType)SqlCommonTokens.SQL_RIGHT_PAREN);
                String what = right == null ? ") " : " ";
                int where = right == null ? offset : right.getStartOffset() + 1;
                document.insertString(where, (CharSequence)what);
                editor.getCaretModel().moveToOffset(where + what.length());
                AutoPopupController.getInstance((Project)at.getProject()).autoPopupMemberLookup(editor, null);
            }
        }
    };

    public static InsertHandler<LookupElement> chainHandlers(InsertHandler<LookupElement> ... handlers) {
        if (handlers.length == 0) {
            return DUMMY_HANDLER;
        }
        if (handlers.length == 1) {
            return handlers[0];
        }
        if (handlers.length == 2) {
            if (handlers[0] == null) {
                return handlers[1];
            }
            if (handlers[1] == null) {
                return handlers[0];
            }
        }
        return (context, item) -> {
            for (InsertHandler handler : handlers) {
                if (handler == null) continue;
                handler.handleInsert(context, item);
                context.commitDocument();
            }
        };
    }

    @NotNull
    public static InsertHandler<LookupElement> createQualifierHandler(NamingService namingService) {
        return SqlInsertHandlers.createQualifierHandler(namingService, false, ContainerUtil.emptyList());
    }

    @NotNull
    public static InsertHandler<LookupElement> createQualifierHandler(final NamingService namingService, final boolean qualifyWholeList, final List<PsiElement> customQualifiers) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                SqlIdentifier identifier;
                List<String> forcedContext;
                if (context == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    5.$$$reportNull$$$0(1);
                }
                context.commitDocument();
                if (!context.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
                    return;
                }
                int offset = context.getTailOffset();
                PsiElement element2 = CompletionUtil.getTargetElement((LookupElement)item);
                DasObject obj = (DasObject)ObjectUtils.tryCast((Object)element2, DasObject.class);
                if (obj == null) {
                    return;
                }
                SqlQualifiedResolveResult resolveResult = (SqlQualifiedResolveResult)((Object)ObjectUtils.tryCast((Object)item.getObject(), SqlQualifiedResolveResult.class));
                List<String> list = forcedContext = resolveResult == null ? null : resolveResult.getQualification();
                if (forcedContext == null) {
                    forcedContext = this.qualification(obj.getDasParent());
                }
                SqlReferenceExpression ref = (SqlReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(offset > 1 ? offset - 1 : offset), SqlReferenceExpression.class, (boolean)false);
                SqlIdentifier sqlIdentifier = identifier = ref == null ? null : ref.getIdentifier();
                if (identifier == null || ref.getQualifierExpression() != null || ref.getParent() instanceof SqlReferenceExpression) {
                    return;
                }
                Condition filter2 = element2 instanceof SqlElement ? rr -> rr.getElement() instanceof SqlElement : rr -> !(rr.getElement() instanceof SqlElement);
                List resolveResults = ContainerUtil.filter((Object[])ref.multiResolve(false), (Condition)filter2);
                if (!this.shouldQualify(ref, resolveResults)) {
                    return;
                }
                SqlLanguageDialectEx language = SqlImplUtil.getSqlDialectSafe((PsiElement)context.getFile());
                List<List<ObjectName>> qualifiers = this.getQualifier(language, resolveResults, forcedContext, obj);
                if ((!qualifyWholeList || customQualifiers.isEmpty()) && qualifiers.isEmpty()) {
                    return;
                }
                if (!qualifyWholeList) {
                    SqlIntentionUtil.qualifyReference(qualifiers, namingService, identifier, context.getEditor());
                } else {
                    PsiElement parent2 = ref.getParent();
                    List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parent2, SqlReferenceExpression.class);
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        PsiElement qualifier;
                        SqlIdentifier ident;
                        SqlReferenceExpression expression = (SqlReferenceExpression)list2.get(i2);
                        if (expression.getQualifierExpression() != null || (ident = expression.getIdentifier()) == null) continue;
                        if (i2 < customQualifiers.size() && (qualifier = (PsiElement)customQualifiers.get(i2)) instanceof DasObject) {
                            JBIterable<String> qualification = this.qualification((DasObject)qualifier);
                            resolveResults = ContainerUtil.filter((Object[])expression.multiResolve(false), (Condition)filter2);
                            qualifiers = this.getQualifier(language, resolveResults, (Iterable<String>)qualification, null);
                        }
                        context.getEditor().getCaretModel().moveToOffset(expression.getTextRange().getEndOffset());
                        SqlIntentionUtil.qualifyReference(qualifiers, namingService, ident, context.getEditor());
                        context.commitDocument();
                    }
                }
            }

            private boolean shouldQualify(@NotNull SqlReferenceExpression ref, List<ResolveResult> resolveResults) {
                if (ref == null) {
                    5.$$$reportNull$$$0(2);
                }
                SqlEditorOptions options = SqlEditorOptions.getInstance();
                ObjectKind kind = ObjectKind.NONE;
                if (resolveResults.isEmpty()) {
                    kind = ref.getReferenceElementType().getTargetKind();
                } else {
                    ResolveResult result;
                    Iterator<ResolveResult> iterator = resolveResults.iterator();
                    while (iterator.hasNext() && (kind = DasUtil.getKind((DasObject)((DasObject)ObjectUtils.tryCast((Object)SqlImplUtil.getQualifier(result = iterator.next()), DasObject.class)))) == ObjectKind.NONE) {
                    }
                }
                SqlEditorOptions.QualificationType qualification = ModelConsts.TABLE_OR_VIEW_KINDS.contains(kind) ? options.getTableQualification() : (kind == SqlDbElementType.LOCAL_ALIAS ? options.getAliasQualification() : options.getNamespaceQualification());
                return qualification.shouldQualify(resolveResults.size());
            }

            @NotNull
            private List<List<ObjectName>> getQualifier(@NotNull CasingProvider casingProvider, @NotNull List<ResolveResult> results2, @Nullable Iterable<String> forcedContext, @Nullable DasObject obj) {
                if (casingProvider == null) {
                    5.$$$reportNull$$$0(3);
                }
                if (results2 == null) {
                    5.$$$reportNull$$$0(4);
                }
                LinkedHashSet<DasObject> qualifiers = new LinkedHashSet<DasObject>();
                HashSet<DasObject> all = new HashSet<DasObject>();
                if (results2.isEmpty() && obj != null) {
                    qualifiers.add(obj.getDasParent());
                } else {
                    for (ResolveResult result : results2) {
                        boolean kindUnsuitable;
                        PsiElement psi = SqlImplUtil.getQualifier(result);
                        DasObject qual = (DasObject)ObjectUtils.tryCast((Object)psi, DasObject.class);
                        DasObject elem = (DasObject)ObjectUtils.tryCast((Object)result.getElement(), DasObject.class);
                        ObjectKind elementKind = elem == null ? null : elem.getKind();
                        boolean bl = kindUnsuitable = elementKind != ObjectKind.TABLE && elementKind != ObjectKind.VIEW && elementKind != ObjectKind.COLUMN && (elementKind != SqlDbElementType.LOCAL_ALIAS || qual != null && qual.getKind() != SqlDbElementType.LOCAL_ALIAS);
                        if (psi != null && qual == null || elem == null || kindUnsuitable) continue;
                        if (qual == null) {
                            qual = elem.getDasParent();
                        }
                        if (qual == null) continue;
                        if ((obj == null || Comparing.equal((String)elem.getName(), (String)obj.getName())) && this.eq((Iterable<String>)this.qualification(qual), forcedContext)) {
                            qualifiers.add(qual);
                        }
                        all.add(qual);
                    }
                }
                SmartList qualPaths = new SmartList();
                for (DasObject qualifier : qualifiers) {
                    SmartList list = new SmartList();
                    all.remove(qualifier);
                    this.appendQualification(qualifier, all, (List<ObjectName>)list, casingProvider);
                    all.add(qualifier);
                    if (list.isEmpty()) continue;
                    qualPaths.add(list);
                }
                SmartList smartList = qualPaths;
                if (smartList == null) {
                    5.$$$reportNull$$$0(5);
                }
                return smartList;
            }

            @Contract(value="null -> null; !null -> !null")
            private JBIterable<String> qualification(@Nullable DasObject obj) {
                return obj == null ? null : DasUtil.dasParents((DasObject)obj).transform(DasUtil.TO_NAME);
            }

            private boolean eq(@Nullable Iterable<String> it1, @Nullable Iterable<String> it2) {
                if (it1 == null || it2 == null) {
                    return it1 == it2;
                }
                Iterator<String> i1 = it1.iterator();
                Iterator<String> i2 = it2.iterator();
                while (i1.hasNext() && i2.hasNext()) {
                    if (Comparing.equal((String)i1.next(), (String)i2.next())) continue;
                    return false;
                }
                return i1.hasNext() == i2.hasNext();
            }

            private void appendQualification(@Nullable DasObject qualifier, @NotNull Set<DasObject> other, @NotNull List<ObjectName> path, @NotNull CasingProvider casingProvider) {
                if (other == null) {
                    5.$$$reportNull$$$0(6);
                }
                if (path == null) {
                    5.$$$reportNull$$$0(7);
                }
                if (casingProvider == null) {
                    5.$$$reportNull$$$0(8);
                }
                if (qualifier == null || StringUtil.isEmpty((String)qualifier.getName())) {
                    return;
                }
                List qualifications = ContainerUtil.map(other, current -> this.fullQualification((DasObject)current));
                List<DasObject> qualification = this.fullQualification(qualifier);
                path.addAll(ContainerUtil.map(this.cutAllFromFirstDifferentElement(qualification, qualifications, casingProvider), DbSqlUtil::getName));
            }

            @NotNull
            private List<DasObject> fullQualification(@NotNull DasObject object) {
                if (object == null) {
                    5.$$$reportNull$$$0(9);
                }
                List list = ContainerUtil.reverse((List)DasUtil.dasParents((DasObject)object).toList());
                if (list == null) {
                    5.$$$reportNull$$$0(10);
                }
                return list;
            }

            @NotNull
            private List<DasObject> cutAllFromFirstDifferentElement(@NotNull List<DasObject> qualification, @NotNull List<List<DasObject>> qualifications, @NotNull CasingProvider provider) {
                OptionalInt indices;
                if (qualification == null) {
                    5.$$$reportNull$$$0(11);
                }
                if (qualifications == null) {
                    5.$$$reportNull$$$0(12);
                }
                if (provider == null) {
                    5.$$$reportNull$$$0(13);
                }
                int firstDifferentIndex = Math.max((indices = qualifications.stream().mapToInt(list -> this.firstDifferentElement(qualification, (List<DasObject>)list, provider)).min()).isPresent() ? indices.getAsInt() : qualification.size() - 1, 0);
                List list2 = ContainerUtil.subList(qualification, (int)firstDifferentIndex);
                if (list2 == null) {
                    5.$$$reportNull$$$0(14);
                }
                return list2;
            }

            private int firstDifferentElement(@NotNull List<DasObject> first2, @NotNull List<DasObject> second, @NotNull CasingProvider provider) {
                if (first2 == null) {
                    5.$$$reportNull$$$0(15);
                }
                if (second == null) {
                    5.$$$reportNull$$$0(16);
                }
                if (provider == null) {
                    5.$$$reportNull$$$0(17);
                }
                int firstIdx = first2.size() - 1;
                for (int secondIdx = second.size() - 1; firstIdx >= 0 && secondIdx >= 0 && DasUtil.byName((String)first2.get(firstIdx).getName(), (CasingProvider)provider).value((Object)second.get(secondIdx)); --firstIdx, --secondIdx) {
                }
                return firstIdx;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 14: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 14: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 3: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "casingProvider";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "results";
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/sql/completion/SqlInsertHandlers$5";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "other";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "object";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualification";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qualifications";
                        break;
                    }
                    case 13: 
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "first";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "second";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/sql/completion/SqlInsertHandlers$5";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQualifier";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fullQualification";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "cutAllFromFirstDifferentElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "handleInsert";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldQualify";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "getQualifier";
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 14: {
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "appendQualification";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "fullQualification";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "cutAllFromFirstDifferentElement";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "firstDifferentElement";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: 
                    case 10: 
                    case 14: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static InsertHandler<LookupElement> createPrefixHandler(final String name, final String prefix, final NamingService namingService) {
        return new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                if (context == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    6.$$$reportNull$$$0(1);
                }
                int start2 = context.getStartOffset();
                int end2 = context.getTailOffset();
                context.getDocument().replaceString(start2, end2, (CharSequence)(prefix + namingService.nameToScript(name, false, SqlPsiMiscUtil.settings(context.getFile()).getQuotesPriority())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$6";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static InsertHandler<LookupElement> getQuoteAndDotHandler(PsiNamedElement t, NamingService namingService, boolean addDot, boolean isPlaceQuoted) {
        boolean mayOmitQuotes;
        String prefix;
        SqlPrefixedElement prefixed = SqlCompletionUtil.getPrefixed(t);
        String string = prefix = prefixed == null ? null : prefixed.getNamePrefix();
        if (prefix != null) {
            return SqlInsertHandlers.createPrefixHandler(t.getName(), prefix, namingService);
        }
        SqlCodeStyleSettings settings = SqlPsiMiscUtil.settings((PsiElement)t);
        boolean bl = mayOmitQuotes = SqlCompletionUtil.hasPlainIdentifier((PsiElement)t) && settings.QUOTE_IDENTIFIER != 0;
        return isPlaceQuoted ? (addDot ? INSIDE_QUOT_DOT_INSERT_HANDLER : INSIDE_QUOT_INSERT_HANDLER) : (mayOmitQuotes ? (addDot ? DOT_INSERT_HANDLER : null) : (addDot ? QUOT_DOT_INSERT_HANDLER : QUOT_INSERT_HANDLER));
    }

    public static class FunctionElementInsertHandler
    implements InsertHandler<LookupElement> {
        private final Dbms myDbms;
        private final boolean myUseSpaces;
        private final boolean myNoParams;
        @Nullable
        private final String myParameterList;
        private final SqlFunctionDefinition myDefinition;
        private final SqlFunctionDefinition.Prototype myPrototype;
        private static final String TRUE = "true";

        public FunctionElementInsertHandler(@NotNull Dbms dbms, boolean useSpaces, boolean noParams, @Nullable String parameterList, @Nullable SqlFunctionDefinition definition, @Nullable SqlFunctionDefinition.Prototype prototype) {
            if (dbms == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
            this.myUseSpaces = useSpaces;
            this.myNoParams = noParams;
            this.myParameterList = parameterList;
            this.myDefinition = definition;
            this.myPrototype = prototype;
        }

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            if (context == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(1);
            }
            if (item == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(2);
            }
            if (!SqlCompletionUtil.hasPlainIdentifier(item.getPsiElement())) {
                QUOT_INSERT_HANDLER.handleInsert(context, item);
            }
            if (!FunctionElementInsertHandler.isInsertingInPgFunctionColumn(context, this.myDbms)) {
                FunctionElementInsertHandler.getInsertHandler(this.myUseSpaces, this.myNoParams, this.myParameterList).handleInsert(context, item);
            }
            if (this.myDefinition != null) {
                SqlFunctionDefinition function2 = this.myDefinition;
                boolean analytic = (!TRUE.equals(function2.getDialectAttribute("aggregate")) || TRUE.equals(function2.getDialectAttribute("rank"))) && (TRUE.equals(function2.getDialectAttribute("analytic")) || this.myPrototype != null && TRUE.equals(this.myPrototype.getAttributes().get("analytic")));
                boolean withinGroup = TRUE.equals(function2.getDialectAttribute("within_group"));
                if (analytic) {
                    int offset = context.getEditor().getCaretModel().getOffset();
                    int insertionPlace = this.myNoParams ? offset : offset + 1;
                    PsiFile file = context.getFile();
                    PsiElement element2 = file.findElementAt(insertionPlace);
                    if (element2 instanceof PsiWhiteSpace) {
                        element2 = PsiTreeUtil.skipWhitespacesForward((PsiElement)element2);
                    }
                    if (element2 != null && "over".equalsIgnoreCase(element2.getText())) {
                        return;
                    }
                    if (withinGroup && element2 != null && "within".equalsIgnoreCase(element2.getText())) {
                        return;
                    }
                    SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((PsiFile)file);
                    Case mode = SqlCodeStyleSettings.getCaseMode((int)settings.KEYWORD_CASE);
                    String withinGroupString = withinGroup ? " within group ( order by )" : "";
                    String fullString = withinGroupString + " over ()" + (element2 instanceof PsiErrorElement ? "," : "");
                    if (mode == Case.UPPER) {
                        fullString = StringUtil.toUpperCase((String)fullString);
                    }
                    context.getDocument().insertString(insertionPlace, (CharSequence)fullString);
                    int newOffset = offset + withinGroupString.length() + " over (".length();
                    if (this.myNoParams) {
                        context.getEditor().getCaretModel().moveToOffset(newOffset);
                    }
                    context.commitDocument();
                    SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)context.getFile().findElementAt(newOffset), SqlQueryExpression.class);
                    if (PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)query, SqlWindowClauseImpl.class).size() > 0) {
                        context.getDocument().deleteString(newOffset - 1, newOffset + 1);
                    }
                }
            }
        }

        @NotNull
        private static InsertHandler<LookupElement> getInsertHandler(boolean useSpaces, boolean noParams, final @Nullable String parameterList) {
            if (useSpaces) {
                InsertHandler insertHandler = noParams ? DUMMY_HANDLER : AddSpaceInsertHandler.INSTANCE;
                if (insertHandler == null) {
                    FunctionElementInsertHandler.$$$reportNull$$$0(3);
                }
                return insertHandler;
            }
            if (noParams) {
                ParenthesesInsertHandler parenthesesInsertHandler = ParenthesesInsertHandler.NO_PARAMETERS;
                if (parenthesesInsertHandler == null) {
                    FunctionElementInsertHandler.$$$reportNull$$$0(4);
                }
                return parenthesesInsertHandler;
            }
            if (parameterList != null) {
                return new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                        if (context == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Editor editor = context.getEditor();
                        CaretModel caretModel = editor.getCaretModel();
                        int offset = caretModel.getOffset();
                        editor.getDocument().insertString(offset, (CharSequence)parameterList);
                        caretModel.moveToOffset(offset + parameterList.length());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/sql/completion/SqlInsertHandlers$FunctionElementInsertHandler$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
            ParenthesesInsertHandler parenthesesInsertHandler = ParenthesesInsertHandler.WITH_PARAMETERS;
            if (parenthesesInsertHandler == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(5);
            }
            return parenthesesInsertHandler;
        }

        private static boolean isInsertingInPgFunctionColumn(@NotNull InsertionContext context, @NotNull Dbms dbms) {
            PsiReference ref;
            if (context == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(6);
            }
            if (dbms == null) {
                FunctionElementInsertHandler.$$$reportNull$$$0(7);
            }
            return dbms.isPostgres() && SqlImplUtil.canResolveToPgFunctionColumn((ref = context.getFile().findReferenceAt(context.getStartOffset())) == null ? null : ref.getElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/completion/SqlInsertHandlers$FunctionElementInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/completion/SqlInsertHandlers$FunctionElementInsertHandler";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInsertHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "handleInsert";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isInsertingInPgFunctionColumn";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class TemplateSafeInsertHandler
    extends AddSpaceInsertHandler {
        public TemplateSafeInsertHandler(String ignoreOnChars, boolean triggerAutoPopup) {
            super(ignoreOnChars, triggerAutoPopup);
        }

        protected boolean shouldOverwriteExistingSpace(Editor editor) {
            TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
            TextRange range = state == null ? null : state.getCurrentVariableRange();
            int offset = editor.getCaretModel().getOffset();
            return range == null || offset != range.getEndOffset();
        }
    }
}

