/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.ImplicitJoinInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/intentions/SqlConvertNaturalJoinToUsingIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertNaturalJoinToUsingIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Replace NATURAL JOIN with USING clause";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!SqlImplUtil.getSqlDialectSafe(element2).supportsJoinUsing()) {
            return false;
        }
        ImplicitJoinInfo info = JoinUtilsKt.getNaturalJoinInfo(element2);
        if (info == null) return false;
        Collection collection = info.getColumns();
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        ImplicitJoinInfo implicitJoinInfo = JoinUtilsKt.getNaturalJoinInfo(element2);
        if (implicitJoinInfo == null) {
            return;
        }
        ImplicitJoinInfo info = implicitJoinInfo;
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof SqlJoinExpression)) {
            psiElement = null;
        }
        SqlJoinExpression sqlJoinExpression = (SqlJoinExpression)psiElement;
        if (sqlJoinExpression == null) {
            return;
        }
        SqlJoinExpression joinExpression = sqlJoinExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)joinExpression);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(joinExpression)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        builder.plain("select * from foo join bar ").keyword("using ").symbol("(");
        Iterable $this$forEachIndexed$iv = info.getColumns();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void column;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            DasColumn dasColumn = (DasColumn)item$iv;
            int i2 = n2;
            boolean bl2 = false;
            if (i2 > 0) {
                builder.symbol(", ");
            }
            builder.identifier((DasObject)column);
        }
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)ddlBuilder, (String)"builder");
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText(ddlBuilder.getStatement(), (SqlLanguageDialect)dialect, project);
        if (sqlQueryExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sqlQueryExpression, (String)"SqlPsiElementFactory.cre\u2026ment, dialect, project)!!");
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlUsingClause.class);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.findChildOfT\u2026singClause::class.java)!!");
        SqlUsingClause usingClause = (SqlUsingClause)psiElement2;
        element2.delete();
        joinExpression.add((PsiElement)usingClause);
    }
}

