/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.liveTemplates;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.database.DbmsExtension;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.liveTemplates.SqlCodeContextType;
import com.intellij.sql.liveTemplates.SqlDialectSpecificContextType;
import com.intellij.sql.liveTemplates.SqlStatementContextType;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class SqlDialectTemplateRegistrar
implements ApplicationInitializedListener {
    static final String GENERIC_DIALECT_CLASS_POSTFIX = ".GenericDialect";
    static final String SQL92_LANGUAGE_CLASS_NAME = "Sql92Dialect";
    static final String SQL92_LANGUAGE_DESC = "Sql92";

    SqlDialectTemplateRegistrar() {
    }

    public void componentsInitialized() {
        MultiMap map2 = MultiMap.createSmart();
        for (DbmsExtension.Bean b2 : SqlLanguageDialect.EP.allExtensions()) {
            if (b2.implementationClass.endsWith(GENERIC_DIALECT_CLASS_POSTFIX)) continue;
            map2.putValue((Object)b2.dbmsStr, (Object)b2);
        }
        ArrayList<TemplateContextType> list = new ArrayList<TemplateContextType>();
        for (Map.Entry entry : map2.entrySet()) {
            String dbms = (String)entry.getKey();
            List beans = (List)entry.getValue();
            if (beans.isEmpty()) continue;
            SqlDialectSpecificContextType contextType = new SqlDialectSpecificContextType(dbms, SqlDialectTemplateRegistrar.getDisplayName((DbmsExtension.Bean<SqlLanguageDialect>)((DbmsExtension.Bean)beans.get(0))), beans);
            SqlCodeContextType codeContextType = new SqlCodeContextType(dbms, contextType);
            SqlStatementContextType statementContextType = new SqlStatementContextType(dbms, codeContextType);
            list.add(contextType);
            list.add(codeContextType);
            list.add(statementContextType);
        }
        ((ExtensionPointImpl)TemplateContextType.EP_NAME.getPoint(null)).registerExtensions(list);
    }

    @NotNull
    private static String getDisplayName(@NotNull DbmsExtension.Bean<SqlLanguageDialect> bean) {
        if (bean == null) {
            SqlDialectTemplateRegistrar.$$$reportNull$$$0(0);
        }
        if (bean.implementationClass.endsWith(SQL92_LANGUAGE_CLASS_NAME)) {
            return SQL92_LANGUAGE_DESC;
        }
        String string = bean.getDbms().getDisplayName();
        if (string == null) {
            SqlDialectTemplateRegistrar.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/liveTemplates/SqlDialectTemplateRegistrar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/liveTemplates/SqlDialectTemplateRegistrar";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

