/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.details.action;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.pullrequest.action.ui.GithubMergeCommitMessageDialog;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRMergeAction;
import org.jetbrains.plugins.github.pullrequest.ui.details.action.GHPRSquashMergeAction;
import org.jetbrains.plugins.github.ui.util.SingleValueModel;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BO\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/details/action/GHPRSquashMergeAction;", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/action/GHPRMergeAction;", "busyStateModel", "Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;", "", "errorHandler", "Lkotlin/Function1;", "", "", "detailsModel", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "project", "Lcom/intellij/openapi/project/Project;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;", "(Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/plugins/github/ui/util/SingleValueModel;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProvider;)V", "submitMergeTask", "Ljava/util/concurrent/CompletableFuture;", "mergeability", "intellij.vcs.github"})
public final class GHPRSquashMergeAction
extends GHPRMergeAction {
    private final Project project;
    private final GHPRStateService stateService;
    private final GHPRDataProvider dataProvider;

    @Override
    @Nullable
    public CompletableFuture<Unit> submitMergeTask(@NotNull GHPRMergeabilityState mergeability) {
        Intrinsics.checkParameterIsNotNull((Object)mergeability, (String)"mergeability");
        return GithubAsyncUtilKt.successOnEdt(this.dataProvider.getApiCommitsRequest(), (Function1)new Function1<List<? extends GHCommit>, Pair<? extends String, ? extends String>>(this, mergeability){
            final /* synthetic */ GHPRSquashMergeAction this$0;
            final /* synthetic */ GHPRMergeabilityState $mergeability;

            @NotNull
            public final Pair<String, String> invoke(@NotNull List<GHCommit> commits) {
                Intrinsics.checkParameterIsNotNull(commits, (String)"commits");
                String body2 = "* " + StringUtil.join((Collection)commits, (Function)submitMergeTask.body.1.INSTANCE, (String)"\n\n* ");
                GithubMergeCommitMessageDialog dialog2 = new GithubMergeCommitMessageDialog(GHPRSquashMergeAction.access$getProject$p(this.this$0), "Merge Pull Request", "Merge pull request #" + this.$mergeability.getNumber(), body2);
                if (!dialog2.showAndGet()) {
                    throw (Throwable)new ProcessCanceledException();
                }
                return dialog2.getMessage();
            }
            {
                this.this$0 = gHPRSquashMergeAction;
                this.$mergeability = gHPRMergeabilityState;
                super(1);
            }
        }).thenCompose(new java.util.function.Function<T, CompletionStage<U>>(this, mergeability){
            final /* synthetic */ GHPRSquashMergeAction this$0;
            final /* synthetic */ GHPRMergeabilityState $mergeability;

            @NotNull
            public final CompletableFuture<Unit> apply(Pair<String, String> message) {
                GHPRStateService gHPRStateService = GHPRSquashMergeAction.access$getStateService$p(this.this$0);
                ProgressIndicator progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                long l = this.$mergeability.getNumber();
                Pair<String, String> pair = message;
                Intrinsics.checkExpressionValueIsNotNull(pair, (String)"message");
                return gHPRStateService.squashMerge(progressIndicator, l, pair, this.$mergeability.getHeadRefOid());
            }
            {
                this.this$0 = gHPRSquashMergeAction;
                this.$mergeability = gHPRMergeabilityState;
            }
        });
    }

    public GHPRSquashMergeAction(@NotNull SingleValueModel<Boolean> busyStateModel, @NotNull Function1<? super String, Unit> errorHandler, @NotNull SingleValueModel<GHPRMergeabilityState> detailsModel, @NotNull Project project, @NotNull GHPRStateService stateService, @NotNull GHPRDataProvider dataProvider) {
        Intrinsics.checkParameterIsNotNull(busyStateModel, (String)"busyStateModel");
        Intrinsics.checkParameterIsNotNull(errorHandler, (String)"errorHandler");
        Intrinsics.checkParameterIsNotNull(detailsModel, (String)"detailsModel");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        super("Squash and Merge...", busyStateModel, errorHandler, detailsModel);
        this.project = project;
        this.stateService = stateService;
        this.dataProvider = dataProvider;
        this.update();
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRSquashMergeAction $this) {
        return $this.project;
    }

    public static final /* synthetic */ GHPRStateService access$getStateService$p(GHPRSquashMergeAction $this) {
        return $this.stateService;
    }
}

