/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.ui.preview.MarkdownAccessor;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownJCEFHtmlPanel
extends JCEFHtmlPanel
implements MarkdownHtmlPanel {
    private final JBCefJSQuery myJSQuerySetScrollY = JBCefJSQuery.create((JBCefBrowser)this);
    private final JBCefJSQuery myJSQueryOpenInBrowser = JBCefJSQuery.create((JBCefBrowser)this);
    private static final NotNullLazyValue<String> MY_SCRIPTING_LINES = new NotNullLazyValue<String>(){

        @NotNull
        protected String compute() {
            String string = MarkdownHtmlPanel.SCRIPTS.stream().map(s -> "<script src=\"" + PreviewStaticServer.getScriptUrl(s) + "\"></script>").reduce((s, s2) -> s + "\n" + s2).orElseGet(String::new);
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$1", "compute"));
        }
    };
    private String @NotNull [] myCssUris = ArrayUtil.EMPTY_STRING_ARRAY;
    @NotNull
    private String myCSP = "";
    @NotNull
    private String myLastRawHtml = "";
    @NotNull
    private final ScrollPreservingListener myScrollPreservingListener = new ScrollPreservingListener();
    @NotNull
    private final BridgeSettingListener myBridgeSettingListener = new BridgeSettingListener();
    private final CefLoadHandler myCefLoadHandler;
    @NotNull
    private static final String ourClassUrl;

    public MarkdownJCEFHtmlPanel() {
        super(ourClassUrl + "@" + new Random().nextInt(Integer.MAX_VALUE));
        this.myJSQuerySetScrollY.addHandler(scrollY -> {
            try {
                this.myScrollPreservingListener.myScrollY = Integer.parseInt(scrollY);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return null;
        });
        if (Registry.is((String)"markdown.open.link.in.external.browser")) {
            this.myJSQueryOpenInBrowser.addHandler(link -> {
                MarkdownAccessor.getSafeOpenerAccessor().openLink((String)link);
                return null;
            });
        }
        this.myCefLoadHandler = new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                MarkdownJCEFHtmlPanel.this.myScrollPreservingListener.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
                MarkdownJCEFHtmlPanel.this.myBridgeSettingListener.onLoadingStateChange(browser, isLoading, canGoBack, canGoForward);
            }
        };
        this.getJBCefClient().addLoadHandler(this.myCefLoadHandler, this.getCefBrowser());
    }

    @Override
    public void setHtml(@NotNull String html) {
        if (html == null) {
            MarkdownJCEFHtmlPanel.$$$reportNull$$$0(0);
        }
        this.myLastRawHtml = html;
        super.setHtml(html);
    }

    @NotNull
    protected String prepareHtml(@NotNull String html) {
        if (html == null) {
            MarkdownJCEFHtmlPanel.$$$reportNull$$$0(1);
        }
        String string = MarkdownAccessor.getImageRefreshFixAccessor().setStamps(html.replace("<head>", "<head><meta http-equiv=\"Content-Security-Policy\" content=\"" + this.myCSP + "\"/>" + MarkdownHtmlPanel.getCssLines(null, this.myCssUris) + "\n" + MarkdownJCEFHtmlPanel.getScriptingLines()));
        if (string == null) {
            MarkdownJCEFHtmlPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setCSS(@Nullable String inlineCss, String ... fileUris) {
        if (fileUris == null) {
            MarkdownJCEFHtmlPanel.$$$reportNull$$$0(3);
        }
        PreviewStaticServer.getInstance().setInlineStyle(inlineCss);
        this.myCssUris = inlineCss == null ? fileUris : ArrayUtil.mergeArrays((String[])fileUris, (String[])new String[]{PreviewStaticServer.getStyleUrl("inline.css")});
        this.myCSP = PreviewStaticServer.createCSP(ContainerUtil.map((Collection)SCRIPTS, s -> PreviewStaticServer.getScriptUrl(s)), ContainerUtil.concat((List)ContainerUtil.map((Collection)STYLES, s -> PreviewStaticServer.getStyleUrl(s)), (List)ContainerUtil.filter((Object[])fileUris, s -> s.startsWith("http://") || s.startsWith("https://"))));
        this.setHtml(this.myLastRawHtml);
    }

    @Override
    public void render() {
    }

    @Override
    public void scrollToMarkdownSrcOffset(int offset) {
        this.getCefBrowser().executeJavaScript("if ('__IntelliJTools' in window) __IntelliJTools.scrollToOffset(" + offset + ", '" + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "');", this.getCefBrowser().getURL(), 0);
        this.getCefBrowser().executeJavaScript("var value = document.documentElement.scrollTop || (document.body && document.body.scrollTop);" + this.myJSQuerySetScrollY.inject("value"), this.getCefBrowser().getURL(), 0);
    }

    public void dispose() {
        super.dispose();
        this.getJBCefClient().removeLoadHandler(this.myCefLoadHandler, this.getCefBrowser());
        Disposer.dispose((Disposable)this.myJSQuerySetScrollY);
        Disposer.dispose((Disposable)this.myJSQueryOpenInBrowser);
    }

    @NotNull
    private static String getScriptingLines() {
        String string = (String)MY_SCRIPTING_LINES.getValue();
        if (string == null) {
            MarkdownJCEFHtmlPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    static {
        String url = "about:blank";
        try {
            url = MarkdownJCEFHtmlPanel.class.getResource(MarkdownJCEFHtmlPanel.class.getSimpleName() + ".class").toExternalForm();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ourClassUrl = url;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUris";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHtml";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptingLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareHtml";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCSS";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScrollPreservingListener
    extends CefLoadHandlerAdapter {
        volatile int myScrollY = 0;

        private ScrollPreservingListener() {
        }

        public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
            if (isLoading) {
                MarkdownJCEFHtmlPanel.this.getCefBrowser().executeJavaScript("var value = document.documentElement.scrollTop || document.body.scrollTop;" + MarkdownJCEFHtmlPanel.this.myJSQuerySetScrollY.inject("value"), MarkdownJCEFHtmlPanel.this.getCefBrowser().getURL(), 0);
            } else {
                MarkdownJCEFHtmlPanel.this.getCefBrowser().executeJavaScript("document.documentElement.scrollTop = ({} || document.body).scrollTop = " + this.myScrollY, MarkdownJCEFHtmlPanel.this.getCefBrowser().getURL(), 0);
            }
        }
    }

    private class BridgeSettingListener
    extends CefLoadHandlerAdapter {
        private BridgeSettingListener() {
        }

        public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
            if (Registry.is((String)"markdown.open.link.in.external.browser")) {
                MarkdownJCEFHtmlPanel.this.getCefBrowser().executeJavaScript("window.JavaPanelBridge = {openInExternalBrowser : function(link) {" + MarkdownJCEFHtmlPanel.this.myJSQueryOpenInBrowser.inject("link") + "}};", MarkdownJCEFHtmlPanel.this.getCefBrowser().getURL(), 0);
            }
        }
    }
}

