/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.components.DiagramNodeBodyComponent;
import com.intellij.diagram.components.DiagramNodeHeaderComponent;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramNodeContainer
extends CellRendererPanel {
    private final CellRendererPanel myHeader;
    private final CellRendererPanel myBody;
    private final DiagramNode myNode;
    private final DiagramBuilder myBuilder;
    private SoftReference<Image> myCache;
    private CacheKey myCacheKey;

    public DiagramNodeContainer(DiagramNode node, DiagramBuilder builder, Point point) {
        this.myBuilder = builder;
        this.setLayout(new BorderLayout(0, 0));
        this.setFocusable(false);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setFont(this.myBuilder.getColorScheme().getFont(EditorFontType.PLAIN));
        this.myNode = node;
        this.myHeader = new DiagramNodeHeaderComponent(builder, node);
        this.myBody = new CellRendererPanel();
        this.myBody.setLayout((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        this.myBody.setBorder((Border)JBUI.Borders.empty());
        DiagramNodeBodyComponent bodyComponent = new DiagramNodeBodyComponent(this.myNode, builder, point);
        this.myBody.add((Component)((Object)bodyComponent));
        this.myHeader.setBorder((Border)new CustomLineBorder((Color)(GraphViewUtil.isPrintMode() ? Gray._168 : Gray._90), 0, 0, 1, 0));
        this.add(this.getHeader(), "North");
        if (this.getBody().getComponentCount() > 0) {
            this.add(this.getBody(), "Center");
        }
        for (JComponent c : UIUtil.uiTraverser((Component)((Object)this)).filter(JComponent.class)) {
            ComponentUtil.putClientProperty((JComponent)c, (Key)IdeBackgroundUtil.NO_BACKGROUND, (Object)true);
        }
    }

    @NotNull
    public JPanel getHeader() {
        CellRendererPanel cellRendererPanel = this.myHeader;
        if (cellRendererPanel == null) {
            DiagramNodeContainer.$$$reportNull$$$0(0);
        }
        return cellRendererPanel;
    }

    @NotNull
    public JPanel getBody() {
        CellRendererPanel cellRendererPanel = this.myBody;
        if (cellRendererPanel == null) {
            DiagramNodeContainer.$$$reportNull$$$0(1);
        }
        return cellRendererPanel;
    }

    public void paint(Graphics g) {
        double scaleY;
        boolean tooLargeToCache;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        Boolean isSelected = (Boolean)this.myNode.getUserData(DiagramNode.SELECTED_NODE_KEY);
        Rectangle visibleRect = this.myBuilder.getView().getVisibleRect();
        boolean bl = tooLargeToCache = visibleRect.width <= width || visibleRect.height <= height;
        if (GraphViewUtil.isPrintMode() || GraphViewUtil.isExportMode() || tooLargeToCache || UIUtil.isPrinting((Graphics)g) || this.getClientProperty("cell.editor") == Boolean.TRUE) {
            this.doPaint(g, isSelected);
            return;
        }
        Icon icon = this.myNode.getIcon();
        Graphics2D g2d = (Graphics2D)g;
        double scaleX = g2d.getTransform().getScaleX();
        CacheKey cacheKey = new CacheKey(width, height, scaleX, scaleY = g2d.getTransform().getScaleY(), isSelected, icon);
        if (cacheKey.widthScaled() <= 0 || cacheKey.heightScaled() <= 0) {
            return;
        }
        Image image = (Image)SoftReference.dereference(this.myCache);
        do {
            int validateResult;
            GraphicsConfiguration configuration = ((Graphics2D)g).getDeviceConfiguration();
            int n = validateResult = image instanceof VolatileImage ? ((VolatileImage)image).validate(configuration) : -1;
            if (validateResult == 2) {
                image.flush();
                image = null;
            }
            if (image == null || !cacheKey.equals(this.myCacheKey)) {
                image = DiagramNodeContainer.createImage(cacheKey, configuration);
                this.doPaint(image, cacheKey);
                this.myCache = new SoftReference((Object)image);
                this.myCacheKey = cacheKey;
            } else if (validateResult == 1) {
                this.doPaint(image, cacheKey);
            }
            ((Graphics2D)g).scale(1.0 / scaleX, 1.0 / scaleY);
            StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
            ((Graphics2D)g).scale(scaleX, scaleY);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost());
    }

    @NotNull
    private static Image createImage(CacheKey key, GraphicsConfiguration configuration) {
        Image image;
        int imageWidth = key.widthScaled();
        int imageHeight = key.heightScaled();
        try {
            image = configuration.createCompatibleVolatileImage(imageWidth, imageHeight, new ImageCapabilities(true), 1);
        }
        catch (AWTException e) {
            image = new BufferedImage(imageWidth, imageHeight, 1);
        }
        Image image2 = image;
        if (image2 == null) {
            DiagramNodeContainer.$$$reportNull$$$0(2);
        }
        return image2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPaint(@NotNull Image image, @NotNull CacheKey key) {
        boolean wasDoubleBuffered;
        if (image == null) {
            DiagramNodeContainer.$$$reportNull$$$0(3);
        }
        if (key == null) {
            DiagramNodeContainer.$$$reportNull$$$0(4);
        }
        if (wasDoubleBuffered = this.isDoubleBuffered()) {
            this.setDoubleBuffered(false);
        }
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.scale(key.scaleX, key.scaleY);
        try {
            GraphicsUtil.setupAAPainting((Graphics)g);
            GraphicsUtil.setupAntialiasing((Graphics)g);
            this.doPaint(g, key.selected);
        }
        finally {
            g.dispose();
        }
        if (wasDoubleBuffered) {
            this.setDoubleBuffered(true);
        }
    }

    private void doPaint(@NotNull Graphics g, @Nullable Boolean isSelected) {
        Color defaultFg;
        Color headerBg;
        if (g == null) {
            DiagramNodeContainer.$$$reportNull$$$0(5);
        }
        boolean printing = GraphViewUtil.isPrintMode();
        DiagramColorManager colorManager = this.myBuilder.getProvider().getColorManager();
        Object element = this.myNode.getIdentifyingElement();
        Color headerFgOverride = printing ? null : DiagramUtils.getFileTabForeground(element);
        Color headerFg = headerFgOverride != null ? headerFgOverride : this.myBuilder.getColorScheme().getDefaultForeground();
        Color color = headerBg = printing ? null : colorManager.getNodeHeaderBackground(this.myBuilder, this.myNode, element);
        if (headerBg != null && !ColorUtil.areContrasting((Color)headerBg, (Color)headerFg) && ColorUtil.areContrasting((Color)headerBg, (Color)(defaultFg = EditorColorsManager.getInstance().getSchemeForCurrentUITheme().getDefaultForeground()))) {
            headerFg = defaultFg;
        }
        Color bodyBg = printing ? null : colorManager.getNodeBackground(this.myBuilder, this.myNode, element, false);
        this.myHeader.setForeground(headerFg);
        this.myHeader.setForcedBackground(headerBg);
        this.myBody.setForcedBackground(bodyBg);
        this.setFont(this.myBuilder.getColorScheme().getFont(EditorFontType.PLAIN));
        if (Boolean.FALSE.equals(isSelected)) {
            Color bg = headerBg != null ? headerBg : this.myBuilder.getColorScheme().getDefaultBackground();
            boolean dark = ColorUtil.isDark((Color)bg);
            AlphaComposite composite = AlphaComposite.getInstance(3, dark ? 0.8f : 0.4f);
            ((Graphics2D)g).setComposite(composite);
        }
        super.paint(g);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeContainer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeContainer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doPaint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CacheKey {
        final int width;
        final int height;
        final double scaleX;
        final double scaleY;
        final Boolean selected;
        final Icon icon;

        CacheKey(int width, int height, double scaleX, double scaleY, Boolean selected, Icon icon) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.width = width;
            this.height = height;
            this.selected = selected;
            this.icon = icon;
        }

        int widthScaled() {
            return (int)Math.round((double)this.width * this.scaleX);
        }

        int heightScaled() {
            return (int)Math.round((double)this.height * this.scaleY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.width != cacheKey.width) {
                return false;
            }
            if (this.height != cacheKey.height) {
                return false;
            }
            if (Double.compare(cacheKey.scaleX, this.scaleX) != 0) {
                return false;
            }
            if (Double.compare(cacheKey.scaleY, this.scaleY) != 0) {
                return false;
            }
            if (this.selected != null ? !this.selected.equals(cacheKey.selected) : cacheKey.selected != null) {
                return false;
            }
            return !(this.icon != null ? !this.icon.equals(cacheKey.icon) : cacheKey.icon != null);
        }
    }
}

