/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.google.gson.Gson;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.css.descriptor.BrowserVersion;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssCompatibilityData {
    private static final Map<String, Map> PROPERTIES_CACHE = new HashMap<String, Map>();
    private static final Map<String, Map> PSEUDO_SELECTOR_CACHE = new HashMap<String, Map>();

    @Nullable
    public static Map getPropertyData(@NotNull String propertyName) {
        if (propertyName == null) {
            CssCompatibilityData.$$$reportNull$$$0(0);
        }
        return CssCompatibilityData.getCssCompatData(PROPERTIES_CACHE, "properties", propertyName);
    }

    @Nullable
    public static Map getPseudoSelectorData(@NotNull String selectorName) {
        if (selectorName == null) {
            CssCompatibilityData.$$$reportNull$$$0(1);
        }
        return CssCompatibilityData.getCssCompatData(PSEUDO_SELECTOR_CACHE, "selectors", selectorName);
    }

    @Nullable
    private static Map getCssCompatData(Map<String, Map> cache, String cssCompatDataType, @NotNull String name) {
        if (name == null) {
            CssCompatibilityData.$$$reportNull$$$0(2);
        }
        if (cache.containsKey(name)) {
            return cache.get(name);
        }
        URL resource = CssCompatibilityData.class.getResource("/cssCompatData/" + cssCompatDataType + "/" + name + ".json");
        if (resource == null) {
            cache.put(name, null);
            return null;
        }
        try {
            Map json = (Map)new Gson().fromJson((Reader)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8), Map.class);
            Map propertiesHolder = (Map)json.get("css");
            Map properties = (Map)propertiesHolder.get(cssCompatDataType);
            Map data = (Map)properties.get(name);
            Map validData = CssCompatibilityData.findBestData(data);
            cache.put(name, validData);
            return validData;
        }
        catch (IOException e) {
            cache.put(name, null);
            return null;
        }
    }

    @NotNull
    private static Map findBestData(@NotNull Map data) {
        if (data == null) {
            CssCompatibilityData.$$$reportNull$$$0(3);
        }
        if (data.get("__compat") != null) {
            Map map = data;
            if (map == null) {
                CssCompatibilityData.$$$reportNull$$$0(4);
            }
            return map;
        }
        Map bestData = null;
        BrowserVersion[] minimalVersions = BrowserVersion.EMPTY_ARRAY;
        for (Object subData : data.values()) {
            if (bestData == null) {
                bestData = (Map)subData;
                minimalVersions = CssCompatibilityData.getBrowsersData((Map)subData);
                continue;
            }
            BrowserVersion[] candidate = CssCompatibilityData.getBrowsersData((Map)subData);
            if (!CssCompatibilityData.isFirstBetter(candidate, minimalVersions)) continue;
            bestData = (Map)subData;
            minimalVersions = candidate;
        }
        Map map = bestData != null ? bestData : data;
        if (map == null) {
            CssCompatibilityData.$$$reportNull$$$0(5);
        }
        return map;
    }

    private static boolean isFirstBetter(BrowserVersion[] candidate1, BrowserVersion[] candidate2) {
        int score = 0;
        for (BrowserVersion.Browser browser : BrowserVersion.Browser.values()) {
            BrowserVersion version1 = (BrowserVersion)ContainerUtil.find((Object[])candidate1, version -> version.getBrowser() == browser);
            BrowserVersion version2 = (BrowserVersion)ContainerUtil.find((Object[])candidate2, version -> version.getBrowser() == browser);
            score += Comparing.compare((Object)version1, (Object)version2, (o1, o2) -> {
                String v2;
                String v1 = o1.getVersion();
                if (v1.equals(v2 = o2.getVersion())) {
                    return 0;
                }
                if (v1.equals("true")) {
                    return 1;
                }
                if (v2.equals("true")) {
                    return -1;
                }
                return Integer.signum(StringUtil.compareVersionNumbers((String)v2, (String)v1));
            });
        }
        return score > 0;
    }

    public static BrowserVersion @NotNull [] getBrowsersDataForProperty(String propertyName) {
        return CssCompatibilityData.getBrowsersData(CssCompatibilityData.getPropertyData(propertyName));
    }

    public static BrowserVersion[] getBrowsersDataForPseudoSelector(String selectorName) {
        return CssCompatibilityData.getBrowsersData(CssCompatibilityData.getPseudoSelectorData(selectorName));
    }

    private static BrowserVersion @NotNull [] getBrowsersData(Map mdnCompatData) {
        if (mdnCompatData == null) {
            if (BrowserVersion.EMPTY_ARRAY == null) {
                CssCompatibilityData.$$$reportNull$$$0(6);
            }
            return BrowserVersion.EMPTY_ARRAY;
        }
        Map compat = (Map)mdnCompatData.get("__compat");
        if (compat == null) {
            if (BrowserVersion.EMPTY_ARRAY == null) {
                CssCompatibilityData.$$$reportNull$$$0(7);
            }
            return BrowserVersion.EMPTY_ARRAY;
        }
        Map support = (Map)compat.get("support");
        if (support == null) {
            if (BrowserVersion.EMPTY_ARRAY == null) {
                CssCompatibilityData.$$$reportNull$$$0(8);
            }
            return BrowserVersion.EMPTY_ARRAY;
        }
        ArrayList<BrowserVersion> result = new ArrayList<BrowserVersion>();
        for (Object key : support.keySet()) {
            Object browserInfos;
            Map browserInfo;
            Object versionAdded;
            String version;
            String browserId = key.toString();
            BrowserVersion.Browser browser = CssCompatibilityData.getBrowserByMdnId(browserId);
            if (browser == null || StringUtil.isEmpty((String)(version = (versionAdded = (browserInfo = (Map)((browserInfos = support.get(key)) instanceof ArrayList ? ((ArrayList)browserInfos).get(0) : browserInfos)).get("version_added")) != null ? versionAdded.toString() : "")) || "false".equals(version)) continue;
            result.add(new BrowserVersion(browser, version));
        }
        BrowserVersion[] browserVersionArray = result.toArray(BrowserVersion.EMPTY_ARRAY);
        if (browserVersionArray == null) {
            CssCompatibilityData.$$$reportNull$$$0(9);
        }
        return browserVersionArray;
    }

    @Nullable
    private static BrowserVersion.Browser getBrowserByMdnId(String mdnBrowserId) {
        switch (mdnBrowserId) {
            case "chrome": {
                return BrowserVersion.Browser.CHROME;
            }
            case "firefox": {
                return BrowserVersion.Browser.FIREFOX;
            }
            case "ie": {
                return BrowserVersion.Browser.IE;
            }
            case "opera": {
                return BrowserVersion.Browser.OPERA;
            }
            case "safari": {
                return BrowserVersion.Browser.SAFARI;
            }
            case "edge": {
                return BrowserVersion.Browser.EDGE;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/CssCompatibilityData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/CssCompatibilityData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findBestData";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowsersData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPseudoSelectorData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCssCompatData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findBestData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

