/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FilePathByPathComparator;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TriggerAdditionOrDeletion {
    private final Collection<FilePath> myExisting;
    private final Collection<FilePath> myDeleted;
    private final Set<FilePath> myAffected;
    private final Project myProject;
    private static final Logger LOG = Logger.getInstance(TriggerAdditionOrDeletion.class);
    private final VcsFileListenerContextHelper myVcsFileListenerContextHelper;
    private Map<AbstractVcs, List<FilePath>> myPreparedAddition;
    private Map<AbstractVcs, List<FilePath>> myPreparedDeletion;

    public TriggerAdditionOrDeletion(Project project) {
        this.myProject = project;
        this.myExisting = new HashSet<FilePath>();
        this.myDeleted = new HashSet<FilePath>();
        this.myAffected = new HashSet<FilePath>();
        this.myVcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.myProject);
    }

    public void addExisting(Collection<? extends FilePath> files) {
        this.myExisting.addAll(files);
    }

    public void addDeleted(Collection<? extends FilePath> files) {
        this.myDeleted.addAll(files);
    }

    public void prepare() {
        if (this.myExisting.isEmpty() && this.myDeleted.isEmpty()) {
            return;
        }
        if (!this.myExisting.isEmpty()) {
            this.processAddition();
        }
        if (!this.myDeleted.isEmpty()) {
            this.processDeletion();
        }
    }

    public void processIt() {
        if (this.myPreparedDeletion != null) {
            for (Map.Entry<AbstractVcs, List<FilePath>> entry : this.myPreparedDeletion.entrySet()) {
                AbstractVcs vcs = entry.getKey();
                CheckinEnvironment localChangesProvider = vcs.getCheckinEnvironment();
                if (localChangesProvider == null) continue;
                List<FilePath> filePaths = entry.getValue();
                if (vcs.fileListenerIsSynchronous()) {
                    this.myAffected.addAll(filePaths);
                    continue;
                }
                this.myAffected.addAll(filePaths);
                localChangesProvider.scheduleMissingFileForDeletion(filePaths);
            }
        }
        if (this.myPreparedAddition != null) {
            ArrayList<FilePath> incorrectFilePath = new ArrayList<FilePath>();
            for (Map.Entry<AbstractVcs, List<FilePath>> entry : this.myPreparedAddition.entrySet()) {
                AbstractVcs vcs = entry.getKey();
                CheckinEnvironment localChangesProvider = vcs.getCheckinEnvironment();
                if (localChangesProvider == null) continue;
                List<FilePath> filePaths = entry.getValue();
                if (vcs.fileListenerIsSynchronous()) {
                    this.myAffected.addAll(filePaths);
                    continue;
                }
                this.myAffected.addAll(filePaths);
                ArrayList virtualFiles = new ArrayList();
                ContainerUtil.process(filePaths, path2 -> {
                    VirtualFile vf = path2.getVirtualFile();
                    if (vf == null) {
                        incorrectFilePath.add((FilePath)path2);
                    } else {
                        virtualFiles.add(vf);
                    }
                    return true;
                });
                localChangesProvider.scheduleUnversionedFilesForAddition(virtualFiles);
            }
            if (!incorrectFilePath.isEmpty()) {
                this.notifyAndLogFiles(incorrectFilePath);
            }
        }
    }

    private void notifyAndLogFiles(@NotNull List<FilePath> incorrectFilePath) {
        if (incorrectFilePath == null) {
            TriggerAdditionOrDeletion.$$$reportNull$$$0(0);
        }
        String message = VcsBundle.message((String)"patch.apply.incorrectly.processed.warning", (Object[])new Object[]{incorrectFilePath.size(), incorrectFilePath});
        LOG.warn(message);
        VcsNotifier.getInstance(this.myProject).notifyImportantWarning(VcsBundle.message((String)"patch.apply.new.files.warning", (Object[])new Object[0]), message);
    }

    public Set<FilePath> getAffected() {
        return this.myAffected;
    }

    private void processDeletion() {
        Map map2 = VcsUtil.groupByRoots((Project)this.myProject, this.myDeleted, (Function)Functions.identity());
        this.myPreparedDeletion = new HashMap<AbstractVcs, List<FilePath>>();
        for (VcsRoot vcsRoot : map2.keySet()) {
            CheckinEnvironment localChangesProvider;
            AbstractVcs vcs;
            if (vcsRoot == null || (vcs = vcsRoot.getVcs()) == null || (localChangesProvider = vcs.getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcs.areDirectoriesVersionedItems();
            Collection files = (Collection)map2.get(vcsRoot);
            ArrayList<FilePath> toBeDeleted = new ArrayList<FilePath>();
            for (FilePath file : files) {
                FilePath parent = file.getParentPath();
                if (!takeDirs && file.isDirectory() || parent == null || !parent.getIOFile().exists()) continue;
                toBeDeleted.add(file);
            }
            if (toBeDeleted.isEmpty()) {
                return;
            }
            if (!vcs.fileListenerIsSynchronous()) {
                for (FilePath filePath : toBeDeleted) {
                    this.myVcsFileListenerContextHelper.ignoreDeleted(filePath);
                }
            }
            List paths = this.myPreparedDeletion.computeIfAbsent(vcs, key -> new ArrayList());
            paths.addAll(toBeDeleted);
        }
    }

    private void processAddition() {
        Map map2 = VcsUtil.groupByRoots((Project)this.myProject, this.myExisting, (Function)Functions.identity());
        this.myPreparedAddition = new HashMap<AbstractVcs, List<FilePath>>();
        for (VcsRoot vcsRoot : map2.keySet()) {
            List<Object> toBeAdded;
            CheckinEnvironment localChangesProvider;
            AbstractVcs vcs;
            if (vcsRoot == null || (vcs = vcsRoot.getVcs()) == null || (localChangesProvider = vcs.getCheckinEnvironment()) == null) continue;
            boolean takeDirs = vcs.areDirectoriesVersionedItems();
            Collection files = (Collection)map2.get(vcsRoot);
            if (takeDirs) {
                Iterator<Object> adder = new RecursiveCheckAdder(vcsRoot.getPath());
                for (FilePath file : files) {
                    ((RecursiveCheckAdder)((Object)adder)).process(file);
                }
                toBeAdded = ((RecursiveCheckAdder)((Object)adder)).getToBeAdded();
            } else {
                toBeAdded = new ArrayList();
                for (FilePath filePath : files) {
                    if (filePath.isDirectory()) continue;
                    toBeAdded.add(filePath);
                }
            }
            if (toBeAdded.isEmpty()) {
                return;
            }
            Collections.sort(toBeAdded, FilePathByPathComparator.getInstance());
            if (!vcs.fileListenerIsSynchronous()) {
                for (FilePath filePath : toBeAdded) {
                    this.myVcsFileListenerContextHelper.ignoreAdded(filePath.getVirtualFile());
                }
            }
            List paths = this.myPreparedAddition.computeIfAbsent(vcs, key -> new ArrayList());
            paths.addAll(toBeAdded);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incorrectFilePath", "com/intellij/openapi/diff/impl/patch/formove/TriggerAdditionOrDeletion", "notifyAndLogFiles"));
    }

    private static class RecursiveCheckAdder {
        private final Set<FilePath> myToBeAdded;
        private final VirtualFile myRoot;

        private RecursiveCheckAdder(VirtualFile root) {
            this.myRoot = root;
            this.myToBeAdded = new HashSet<FilePath>();
        }

        public void process(FilePath path2) {
            for (FilePath current = path2; current != null; current = current.getParentPath()) {
                VirtualFile vf = current.getVirtualFile();
                if (vf == null) {
                    vf = LocalFileSystem.getInstance().refreshAndFindFileByPath(current.getPath());
                }
                if (vf == null) {
                    return;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)this.myRoot, (VirtualFile)vf, (boolean)true)) {
                    return;
                }
                this.myToBeAdded.add(current);
            }
        }

        public List<FilePath> getToBeAdded() {
            return new ArrayList<FilePath>(this.myToBeAdded);
        }
    }
}

