/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStatusBarProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CustomVcsLogUiFactoryProvider;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.PostponableLogRefresher;
import com.intellij.vcs.log.impl.VcsLogTabsProperties;
import com.intellij.vcs.log.impl.VcsLogTabsWatcher;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManagerImpl;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VcsLogFiltererImpl;
import com.intellij.vcs.log.visible.VisiblePackRefresherImpl;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogTabsProperties myUiProperties;
    @Nullable
    private final Consumer<? super Throwable> myRecreateMainLogHandler;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogColorManagerImpl myColorManager;
    @Nullable
    private VcsLogTabsWatcher myTabsLogRefresher;
    @NotNull
    private final PostponableLogRefresher myPostponableRefresher;
    @NotNull
    private final VcsLogStatusBarProgress myStatusBarProgress;
    private boolean myDisposed;

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Collection<? extends VcsRoot> roots) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(0);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(1);
        }
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(2);
        }
        this(project, uiProperties, VcsLogManager.findLogProviders(roots, project), true, null);
    }

    public VcsLogManager(@NotNull Project project, @NotNull VcsLogTabsProperties uiProperties, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, boolean scheduleRefreshImmediately, @Nullable Consumer<? super Throwable> recreateHandler) {
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(3);
        }
        if (uiProperties == null) {
            VcsLogManager.$$$reportNull$$$0(4);
        }
        if (logProviders == null) {
            VcsLogManager.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        this.myUiProperties = uiProperties;
        this.myRecreateMainLogHandler = recreateHandler;
        MyFatalErrorsHandler fatalErrorsHandler = new MyFatalErrorsHandler();
        this.myLogData = new VcsLogData(this.myProject, logProviders, fatalErrorsHandler, this);
        this.myPostponableRefresher = new PostponableLogRefresher(this.myLogData);
        VcsLogManager.refreshLogOnVcsEvents(logProviders, this.myPostponableRefresher, this.myLogData);
        this.myColorManager = new VcsLogColorManagerImpl(logProviders.keySet());
        this.myStatusBarProgress = new VcsLogStatusBarProgress(this.myProject, logProviders, this.myLogData.getProgress());
        if (scheduleRefreshImmediately) {
            this.scheduleInitialization();
        }
    }

    public void scheduleInitialization() {
        this.myLogData.initialize();
    }

    public boolean isLogVisible() {
        return this.myPostponableRefresher.isLogVisible();
    }

    @NotNull
    public VcsLogData getDataManager() {
        VcsLogData vcsLogData = this.myLogData;
        if (vcsLogData == null) {
            VcsLogManager.$$$reportNull$$$0(6);
        }
        return vcsLogData;
    }

    @NotNull
    public VcsLogColorManagerImpl getColorManager() {
        VcsLogColorManagerImpl vcsLogColorManagerImpl = this.myColorManager;
        if (vcsLogColorManagerImpl == null) {
            VcsLogManager.$$$reportNull$$$0(7);
        }
        return vcsLogColorManagerImpl;
    }

    @NotNull
    public VcsLogTabsProperties getUiProperties() {
        VcsLogTabsProperties vcsLogTabsProperties = this.myUiProperties;
        if (vcsLogTabsProperties == null) {
            VcsLogManager.$$$reportNull$$$0(8);
        }
        return vcsLogTabsProperties;
    }

    @NotNull
    public MainVcsLogUi createLogUi(@NotNull String logId, @NotNull LogWindowKind kind, boolean isClosedOnDispose) {
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(9);
        }
        if (kind == null) {
            VcsLogManager.$$$reportNull$$$0(10);
        }
        MainVcsLogUi mainVcsLogUi = this.createLogUi(this.getMainLogUiFactory(logId, null), kind, isClosedOnDispose);
        if (mainVcsLogUi == null) {
            VcsLogManager.$$$reportNull$$$0(11);
        }
        return mainVcsLogUi;
    }

    @NotNull
    public VcsLogUiFactory<? extends MainVcsLogUi> getMainLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters) {
        Optional<CustomVcsLogUiFactoryProvider> customVcsLogUiFactoryProviderOptional;
        if (logId == null) {
            VcsLogManager.$$$reportNull$$$0(12);
        }
        return (customVcsLogUiFactoryProviderOptional = CustomVcsLogUiFactoryProvider.LOG_CUSTOM_UI_FACTORY_PROVIDER_EP.extensions((AreaInstance)this.myProject).filter(p -> p.isActive(this)).findFirst()).isPresent() ? customVcsLogUiFactoryProviderOptional.get().createLogUiFactory(logId, this, filters) : new MainVcsLogUiFactory(logId, filters);
    }

    @NotNull
    private VcsLogTabsWatcher getTabsWatcher() {
        LOG.assertTrue(!this.myDisposed);
        if (this.myTabsLogRefresher == null) {
            this.myTabsLogRefresher = new VcsLogTabsWatcher(this.myProject, this.myPostponableRefresher);
        }
        VcsLogTabsWatcher vcsLogTabsWatcher = this.myTabsLogRefresher;
        if (vcsLogTabsWatcher == null) {
            VcsLogManager.$$$reportNull$$$0(13);
        }
        return vcsLogTabsWatcher;
    }

    @NotNull
    public <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory, @NotNull LogWindowKind kind) {
        if (factory == null) {
            VcsLogManager.$$$reportNull$$$0(14);
        }
        if (kind == null) {
            VcsLogManager.$$$reportNull$$$0(15);
        }
        U u = this.createLogUi(factory, kind, true);
        if (u == null) {
            VcsLogManager.$$$reportNull$$$0(16);
        }
        return u;
    }

    @NotNull
    public <U extends VcsLogUiEx> U createLogUi(@NotNull VcsLogUiFactory<U> factory, @NotNull LogWindowKind kind, boolean isClosedOnDispose) {
        if (factory == null) {
            VcsLogManager.$$$reportNull$$$0(17);
        }
        if (kind == null) {
            VcsLogManager.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            throw new ProcessCanceledException();
        }
        U ui2 = factory.createLogUi(this.myProject, this.myLogData);
        Disposer.register(ui2, (Disposable)this.getTabsWatcher().addTabToWatch(ui2.getId(), ui2.getRefresher(), kind, isClosedOnDispose));
        U u = ui2;
        if (u == null) {
            VcsLogManager.$$$reportNull$$$0(19);
        }
        return u;
    }

    @ApiStatus.Internal
    @NonNls
    public String getLogWindowsInformation() {
        return StringUtil.join(this.myPostponableRefresher.getLogWindows(), window -> window.toString() + (window.isVisible() ? " (visible)" : ""), (String)"\n");
    }

    private static void refreshLogOnVcsEvents(@NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsLogRefresher refresher, @NotNull Disposable disposableParent) {
        if (logProviders == null) {
            VcsLogManager.$$$reportNull$$$0(20);
        }
        if (refresher == null) {
            VcsLogManager.$$$reportNull$$$0(21);
        }
        if (disposableParent == null) {
            VcsLogManager.$$$reportNull$$$0(22);
        }
        MultiMap providers2roots = MultiMap.create();
        logProviders.forEach((key, value) -> providers2roots.putValue(value, key));
        for (Map.Entry entry : providers2roots.entrySet()) {
            Disposable disposable = ((VcsLogProvider)entry.getKey()).subscribeToRootRefreshEvents((Collection)entry.getValue(), refresher);
            Disposer.register((Disposable)disposableParent, (Disposable)disposable);
        }
    }

    @NotNull
    public static Map<VirtualFile, VcsLogProvider> findLogProviders(@NotNull Collection<? extends VcsRoot> roots, @NotNull Project project) {
        if (roots == null) {
            VcsLogManager.$$$reportNull$$$0(23);
        }
        if (project == null) {
            VcsLogManager.$$$reportNull$$$0(24);
        }
        if (roots.isEmpty()) {
            Map<VirtualFile, VcsLogProvider> map2 = Collections.emptyMap();
            if (map2 == null) {
                VcsLogManager.$$$reportNull$$$0(25);
            }
            return map2;
        }
        HashMap<VirtualFile, VcsLogProvider> logProviders = new HashMap<VirtualFile, VcsLogProvider>();
        VcsLogProvider[] allLogProviders = (VcsLogProvider[])VcsLogProvider.LOG_PROVIDER_EP.getExtensions((AreaInstance)project);
        block0: for (VcsRoot vcsRoot : roots) {
            AbstractVcs vcs = vcsRoot.getVcs();
            VirtualFile path2 = vcsRoot.getPath();
            if (vcs == null) {
                LOG.debug("Skipping invalid VCS root: " + vcsRoot);
                continue;
            }
            for (VcsLogProvider provider : allLogProviders) {
                if (!provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())) continue;
                logProviders.put(path2, provider);
                continue block0;
            }
        }
        HashMap<VirtualFile, VcsLogProvider> hashMap = logProviders;
        if (hashMap == null) {
            VcsLogManager.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    void disposeUi() {
        this.myDisposed = true;
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (this.myTabsLogRefresher != null) {
            Disposer.dispose((Disposable)this.myTabsLogRefresher);
        }
        Disposer.dispose((Disposable)this.myStatusBarProgress);
    }

    public void dispose(@Nullable Runnable callback2) {
        this.disposeUi();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Disposer.dispose((Disposable)this);
            if (callback2 != null) {
                callback2.run();
            }
        });
    }

    public void dispose() {
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.debug("Disposed Vcs Log for " + VcsLogUtil.getProvidersMapText(this.myLogData.getLogProviders()));
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logProviders";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogManager";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiProperties";
                break;
            }
            case 11: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createLogUi";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsWatcher";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findLogProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 26: {
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createLogUi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMainLogUiFactory";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "refreshLogOnVcsEvents";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findLogProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LogWindowKind {
        TOOL_WINDOW,
        EDITOR,
        STANDALONE;

    }

    private class MainVcsLogUiFactory
    extends BaseVcsLogUiFactory<VcsLogUiImpl> {
        MainVcsLogUiFactory(@Nullable String logId, VcsLogFilterCollection filters) {
            if (logId == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            super(logId, filters, VcsLogManager.this.myUiProperties, VcsLogManager.this.myColorManager);
        }

        @Override
        @NotNull
        protected VcsLogUiImpl createVcsLogUiImpl(@NotNull String logId, @NotNull VcsLogData logData, @NotNull MainVcsLogUiProperties properties, @NotNull VcsLogColorManagerImpl colorManager, @NotNull VisiblePackRefresherImpl refresher, @Nullable VcsLogFilterCollection filters) {
            if (logId == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            if (logData == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            if (properties == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            if (colorManager == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(4);
            }
            if (refresher == null) {
                MainVcsLogUiFactory.$$$reportNull$$$0(5);
            }
            return new VcsLogUiImpl(logId, logData, colorManager, properties, refresher, filters);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorManager";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refresher";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$MainVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createVcsLogUiImpl";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BaseVcsLogUiFactory<T extends VcsLogUiImpl>
    implements VcsLogUiFactory<T> {
        @NotNull
        private final String myLogId;
        @Nullable
        private final VcsLogFilterCollection myFilters;
        @NotNull
        private final VcsLogTabsProperties myUiProperties;
        @NotNull
        private final VcsLogColorManagerImpl myColorManager;

        public BaseVcsLogUiFactory(@NotNull String logId, @Nullable VcsLogFilterCollection filters, @NotNull VcsLogTabsProperties uiProperties, @NotNull VcsLogColorManagerImpl colorManager) {
            if (logId == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(0);
            }
            if (uiProperties == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(1);
            }
            if (colorManager == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(2);
            }
            this.myLogId = logId;
            this.myFilters = filters;
            this.myUiProperties = uiProperties;
            this.myColorManager = colorManager;
        }

        @Override
        public T createLogUi(@NotNull Project project, @NotNull VcsLogData logData) {
            if (project == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(3);
            }
            if (logData == null) {
                BaseVcsLogUiFactory.$$$reportNull$$$0(4);
            }
            MainVcsLogUiProperties properties = this.myUiProperties.createProperties(this.myLogId);
            VcsLogFiltererImpl vcsLogFilterer = new VcsLogFiltererImpl(logData.getLogProviders(), logData.getStorage(), logData.getTopCommitsCache(), logData.getCommitDetailsGetter(), logData.getIndex());
            PermanentGraph.SortType initialSortType = properties.get(MainVcsLogUiProperties.BEK_SORT_TYPE);
            VcsLogFilterCollection initialFilters = this.myFilters == null ? VcsLogFilterObject.collection(new VcsLogFilter[0]) : this.myFilters;
            VisiblePackRefresherImpl refresher = new VisiblePackRefresherImpl(project, logData, initialFilters, initialSortType, vcsLogFilterer, this.myLogId);
            return this.createVcsLogUiImpl(this.myLogId, logData, properties, this.myColorManager, refresher, this.myFilters);
        }

        @NotNull
        protected abstract T createVcsLogUiImpl(@NotNull String var1, @NotNull VcsLogData var2, @NotNull MainVcsLogUiProperties var3, @NotNull VcsLogColorManagerImpl var4, @NotNull VisiblePackRefresherImpl var5, @Nullable VcsLogFilterCollection var6);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiProperties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorManager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logData";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$BaseVcsLogUiFactory";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createLogUi";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface VcsLogUiFactory<T extends VcsLogUiEx> {
        public T createLogUi(@NotNull Project var1, @NotNull VcsLogData var2);
    }

    private class MyFatalErrorsHandler
    implements FatalErrorHandler {
        private final AtomicBoolean myIsBroken = new AtomicBoolean(false);

        private MyFatalErrorsHandler() {
        }

        @Override
        public void consume(@Nullable Object source, @NotNull Throwable e) {
            if (e == null) {
                MyFatalErrorsHandler.$$$reportNull$$$0(0);
            }
            if (this.myIsBroken.compareAndSet(false, true)) {
                this.processError(source, e);
            } else {
                LOG.debug("Vcs Log storage is broken and is being recreated", e);
            }
        }

        protected void processError(@Nullable Object source, @NotNull Throwable e) {
            if (e == null) {
                MyFatalErrorsHandler.$$$reportNull$$$0(1);
            }
            if (VcsLogManager.this.myRecreateMainLogHandler != null) {
                ApplicationManager.getApplication().invokeLater(() -> VcsLogManager.this.myRecreateMainLogHandler.consume((Object)e));
            } else {
                LOG.error(e);
            }
            if (source instanceof VcsLogStorage) {
                ((VcsLogModifiableIndex)VcsLogManager.this.myLogData.getIndex()).markCorrupted();
            }
        }

        @Override
        public void displayFatalErrorMessage(@Nls @NotNull String message) {
            if (message == null) {
                MyFatalErrorsHandler.$$$reportNull$$$0(2);
            }
            VcsBalloonProblemNotifier.showOverChangesView(VcsLogManager.this.myProject, message, MessageType.ERROR, new NamedRunnable[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogManager$MyFatalErrorsHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "consume";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processError";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "displayFatalErrorMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

