/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class NodeModuleSearchUtil {
    private static final String NODE_MODULES = "node_modules";
    public static final String[] FILE_EXTENSIONS_IN_ORDER = new String[]{".coffee", ".ts", ".tsx", ".d.ts", ".js.flow", ".js", ".jsx", ".json", ".node"};

    private NodeModuleSearchUtil() {
    }

    public static void findModulesWithName(@NotNull List<? super CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, @Nullable NodeJsInterpreter interpreter) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(1);
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules, requester, moduleName);
        }
        NodeModuleSearchUtil.findGloballyInstalledModules(modules, moduleName, interpreter);
    }

    @Deprecated
    public static void findModulesWithName(@NotNull List<? super CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable VirtualFile requester, boolean includeGloballyInstalled, @Nullable NodeJsInterpreter interpreter) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(3);
        }
        NodeModuleSearchUtil.findModulesWithName(modules, moduleName, requester, interpreter);
    }

    public static void findModulesByNameInContentRoots(@NotNull List<? super CompletionModuleInfo> modules, @NotNull String moduleName, @NotNull Project project) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(4);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(6);
        }
        ReadAction.run(() -> {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                    VirtualFile nodeModulesDir = contentRoot.findChild(NODE_MODULES);
                    if (!NodeModuleSearchUtil.isDirectory(nodeModulesDir)) continue;
                    NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
                }
            }
        });
    }

    public static void findGloballyInstalledModules(@NotNull List<? super CompletionModuleInfo> modules, @NotNull String moduleName, @Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter local;
        VirtualFile globalNodeModulesDir;
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(7);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = globalNodeModulesDir = (local = NodeJsLocalInterpreter.tryCast(interpreter)) != null ? local.getGlobalNodeModulesVirtualDir() : null;
        if (globalNodeModulesDir != null) {
            ReadAction.run(() -> NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName, true));
        }
    }

    private static void findModulesWithNameFromNodeModulesDir(@NotNull List<? super CompletionModuleInfo> modules, @NotNull VirtualFile requester, @NotNull String moduleName) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(9);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(11);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
            return true;
        }));
    }

    public static boolean findModuleWithNameInDirectory(@NotNull List<? super CompletionModuleInfo> modules, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(12);
        }
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(13);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(14);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(15);
        }
        return NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, dir, moduleType, moduleName, false);
    }

    public static boolean findModuleWithNameInDirectory(@NotNull List<? super CompletionModuleInfo> modules, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName, boolean withRefresh) {
        boolean ok;
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(16);
        }
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(17);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(18);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(19);
        }
        VirtualFile child = dir.findFileByRelativePath(moduleName);
        if (withRefresh && child == null && dir instanceof NewVirtualFile && ApplicationManager.getApplication().isDispatchThread()) {
            child = ((NewVirtualFile)dir).refreshAndFindChild(moduleName);
        }
        if (child != null && (ok = NodeModuleSearchUtil.canLoad(child))) {
            String name = child.isDirectory() ? child.getName() : child.getNameWithoutExtension();
            modules.add(new CompletionModuleInfo(name, child, moduleType));
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<CompletionModuleInfo> collectVisibleNodeModules(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(21);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromNodeModulesDir(modules, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectYarnPnpDependencies(modules, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromResourceRoots(modules, project, requester);
        }
        Collection<CompletionModuleInfo> collection = modules.values();
        if (collection == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(22);
        }
        return collection;
    }

    private static void collectYarnPnpDependencies(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(24);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(25);
        }
        PackageJsonUtil.processUpPackageJsonFiles(project, requester, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance(project);
            if (yarnPnpManager.isUnderPnp((VirtualFile)packageJson)) {
                Set<String> dependencies = PackageJsonData.getOrCreate(packageJson).getAllDependencies();
                for (String dependency : dependencies) {
                    VirtualFile dependencyRoot;
                    if (modules.containsKey(dependency) || (dependencyRoot = yarnPnpManager.findInstalledPackageDir((VirtualFile)packageJson, dependency)) == null) continue;
                    modules.put(dependency, new CompletionModuleInfo(dependency, null, ModuleType.NODE_MODULES_DIR));
                }
            }
            return true;
        }));
    }

    private static void collectModulesFromResourceRoots(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @Nullable VirtualFile requester) {
        WebResourcesPathsConfiguration pathsConfiguration;
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(26);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(27);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project)) != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            NodeModuleSearchUtil.collectModulesInDirectories(directories, modules, ModuleType.RESOURCE_ROOT);
        }
        if (requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            NodeModuleSearchUtil.collectModulesInDirectories(resourceRoots, modules, ModuleType.RESOURCE_ROOT);
        }
    }

    private static void collectModulesFromNodeModulesDir(@NotNull Map<String, CompletionModuleInfo> modules, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(28);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(29);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(30);
        }
        HashSet dependencies = new HashSet();
        NodeModuleSearchUtil.processUpNodeModulesDirsAndPackageJsonFiles(project, requester, true, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(nodeModulesDir, packageJsonFile) -> {
            if (packageJsonFile != null) {
                dependencies.addAll(PackageJsonData.getOrCreate(packageJsonFile).getAllDependencies());
            }
            if (nodeModulesDir != null) {
                NodeModuleSearchUtil.collectModulesInDirectory(nodeModulesDir, modules, ModuleType.NODE_MODULES_DIR, dependencies);
            }
            return true;
        }));
    }

    private static void collectModulesInDirectories(@NotNull List<? extends VirtualFile> directories, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType) {
        if (directories == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(31);
        }
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(32);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(33);
        }
        for (VirtualFile virtualFile : directories) {
            if (!virtualFile.isDirectory() || !virtualFile.isValid()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(virtualFile, modules, moduleType, null);
        }
    }

    private static void collectModulesInDirectory(@NotNull VirtualFile dir, @NotNull Map<String, CompletionModuleInfo> modules, @NotNull ModuleType moduleType, @Nullable Set<String> dependencies) {
        VirtualFile[] children;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(34);
        }
        if (modules == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(35);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(36);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(dir) && (packageJson = NodeModuleUtil.findPackageJsonByNodeModules(dir)) != null && packageJson.isValid()) {
            Set<String> deps = dependencies;
            if (deps == null) {
                deps = PackageJsonData.getOrCreate(packageJson).getAllDependencies();
            }
            for (String dependency : deps) {
                VirtualFile moduleDir = dir.findFileByRelativePath(dependency);
                if (moduleDir == null || !moduleDir.isDirectory() || !moduleDir.isValid() || modules.containsKey(dependency)) continue;
                modules.put(dependency, new CompletionModuleInfo(dependency, moduleDir, moduleType));
            }
            return;
        }
        for (VirtualFile child : children = VfsUtil.getChildren((VirtualFile)dir)) {
            String moduleName;
            String childName = child.getName();
            if (NodeModuleSearchUtil.isScopeDir(child)) {
                for (VirtualFile grandChild : child.getChildren()) {
                    String moduleName2;
                    if (!NodeModuleSearchUtil.canLoad(grandChild) || modules.containsKey(moduleName2 = childName + "/" + NodeModuleSearchUtil.getModuleName(grandChild))) continue;
                    modules.put(moduleName2, new CompletionModuleInfo(moduleName2, grandChild, moduleType));
                }
                continue;
            }
            if (!NodeModuleSearchUtil.canLoad(child) || modules.containsKey(moduleName = NodeModuleSearchUtil.getModuleName(child))) continue;
            modules.put(moduleName, new CompletionModuleInfo(moduleName, child, moduleType));
        }
    }

    private static String getModuleName(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(37);
        }
        return fileOrDir.isDirectory() ? fileOrDir.getName() : fileOrDir.getNameWithoutExtension();
    }

    private static boolean canLoad(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(38);
        }
        if (fileOrDir.isDirectory()) {
            return NodeModuleSearchUtil.canLoadDirectory(fileOrDir);
        }
        return NodeModuleSearchUtil.canLoadFile(fileOrDir);
    }

    public static boolean canLoadFile(@NotNull VirtualFile file2) {
        String ext;
        if (file2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(39);
        }
        if ((ext = file2.getExtension()) == null) {
            return false;
        }
        for (String expectedExt : FILE_EXTENSIONS_IN_ORDER) {
            if (!expectedExt.endsWith(ext) || ext.length() + 1 != expectedExt.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean canLoadDirectory(@NotNull VirtualFile dir) {
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(40);
        }
        if (NodeModuleSearchUtil.isFile(packageJson = dir.findChild("package.json"))) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS_IN_ORDER) {
            VirtualFile child = dir.findChild("index" + ext);
            if (!NodeModuleSearchUtil.isFile(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester, @NotNull List<? extends VirtualFile> nodePathFolders, boolean respectResourceRoots, @NotNull Project project) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(41);
        }
        if (nodePathFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(42);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(43);
        }
        ResolvedModuleInfo info = null;
        if (requester != null) {
            info = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, NodeModuleDirectorySearchProcessor.PROCESSOR);
        }
        if (info == null && requester != null) {
            info = NodeModuleSearchUtil.resolveYarnModule(project, requiredModuleName, requester);
        }
        if (info == null && respectResourceRoots) {
            info = NodeModuleSearchUtil.resolveModuleFromResourceRoots(project, requiredModuleName, requester);
        }
        if (info == null) {
            info = NodeModuleSearchUtil.resolveModuleFromGlobalFolders(requiredModuleName, nodePathFolders);
        }
        return info;
    }

    private static ResolvedModuleInfo resolveYarnModule(@NotNull Project project, @NotNull String requiredModuleName, @NotNull VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(44);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(45);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(46);
        }
        return NodeModuleSearchUtil.resolveYarnModule(project, requiredModuleName, requester, NodeModuleDirectorySearchProcessor.PROCESSOR);
    }

    @Nullable
    public static ResolvedModuleInfo resolveYarnModule(@NotNull Project project, @NotNull String requiredModuleName, @NotNull VirtualFile requester, @NotNull NodeModuleDirectorySearchProcessor processor) {
        VirtualFile nodeModulesParent;
        int separatorInd;
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(47);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(48);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(50);
        }
        if ((separatorInd = requiredModuleName.indexOf(47)) > 0 && NodeModuleSearchUtil.isScopedPackageName(requiredModuleName)) {
            separatorInd = requiredModuleName.indexOf(47, separatorInd + 1);
        }
        String dependencyName = separatorInd >= 0 ? requiredModuleName.substring(0, separatorInd) : requiredModuleName;
        Ref packageJsonRef = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, requester, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
            if (data.isDependencyOfAnyType(dependencyName)) {
                packageJsonRef.set(packageJson);
                return false;
            }
            return true;
        }));
        VirtualFile packageJson2 = (VirtualFile)packageJsonRef.get();
        if (packageJson2 == null) {
            return null;
        }
        VirtualFile dependencyRoot = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson2, dependencyName);
        VirtualFile virtualFile = nodeModulesParent = dependencyRoot != null ? dependencyRoot.getParent() : null;
        if (NodeModuleSearchUtil.isScopedPackageName(requiredModuleName)) {
            VirtualFile virtualFile2 = nodeModulesParent = nodeModulesParent != null ? nodeModulesParent.getParent() : null;
        }
        if (nodeModulesParent == null) {
            return null;
        }
        return NodeModuleDirectorySearchProcessor.PROCESSOR.doResolveModule(dependencyRoot, ModuleType.NODE_MODULES_DIR, nodeModulesParent, requiredModuleName, true, true);
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleFromNodeModulesDir(@NotNull VirtualFile requester, @NotNull String requiredModuleName, @NotNull NodeModuleDirectorySearchProcessor processor) {
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(51);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(53);
        }
        Ref resolveRef = Ref.create();
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            ResolvedModuleInfo info = processor.doResolveModule(null, ModuleType.NODE_MODULES_DIR, (VirtualFile)nodeModulesDir, requiredModuleName, true, true);
            if (info != null) {
                resolveRef.set((Object)info);
                return false;
            }
            return true;
        }));
        return (ResolvedModuleInfo)resolveRef.get();
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromResourceRoots(@NotNull Project project, @NotNull String requiredModuleName, @Nullable VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(54);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(55);
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project);
        ResolvedModuleInfo info = null;
        if (pathsConfiguration != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, directories);
        }
        if (info == null && requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            info = NodeModuleSearchUtil.resolveModuleInResourceRoots(requiredModuleName, resourceRoots);
        }
        return info;
    }

    @NotNull
    private static List<VirtualFile> getJavaResourceRoots(@NotNull Project project, @NotNull VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(56);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(57);
        }
        if (!PlatformUtils.isIdeaUltimate()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(58);
            }
            return list2;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        Module module = index.getModuleForFile(requester, false);
        if (module == null) {
            List<VirtualFile> list3 = Collections.emptyList();
            if (list3 == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(59);
            }
            return list3;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list4 = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (list4 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(60);
        }
        return list4;
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleInResourceRoots(@NotNull String requiredModuleName, @NotNull List<? extends VirtualFile> resourceRoots) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(61);
        }
        if (resourceRoots == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(62);
        }
        if (resourceRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile virtualFile : resourceRoots) {
            ResolvedModuleInfo info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.RESOURCE_ROOT, virtualFile, requiredModuleName, true, true);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public static void processUpNodeModulesDirs(@Nullable Project project, @NotNull VirtualFile requester, @NotNull Processor<? super VirtualFile> nodeModulesDirProcessor) {
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(63);
        }
        if (nodeModulesDirProcessor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(64);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirsAndPackageJsonFiles(project, requester, false, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(nodeModulesDir, packageJsonFile) -> nodeModulesDirProcessor.process((Object)Objects.requireNonNull(nodeModulesDir))));
    }

    private static void processUpNodeModulesDirsAndPackageJsonFiles(@Nullable Project project, @NotNull VirtualFile requester, boolean includePackageJsonFiles, @NotNull PairProcessor<? super VirtualFile, ? super VirtualFile> processor) {
        ProjectFileIndex index;
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(65);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(66);
        }
        ProjectFileIndex projectFileIndex = index = project == null ? null : ProjectFileIndex.getInstance((Project)project);
        for (VirtualFile dir = requester.isDirectory() ? requester : requester.getParent(); dir != null && (index == null || index.getContentRootForFile(dir, false) != null); dir = dir.getParent()) {
            boolean continueIteration;
            VirtualFile packageJsonFile;
            VirtualFile nodeModulesDir = NodeModuleUtil.findChildNodeModulesDir(dir);
            VirtualFile virtualFile = packageJsonFile = includePackageJsonFiles ? PackageJsonUtil.findChildPackageJsonFile(dir) : null;
            if ((nodeModulesDir != null || packageJsonFile != null) && !(continueIteration = processor.process((Object)nodeModulesDir, (Object)packageJsonFile))) break;
        }
    }

    @Nullable
    private static ResolvedModuleInfo resolveModuleFromGlobalFolders(@NotNull String requiredModuleName, @NotNull List<? extends VirtualFile> globalFolders) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(67);
        }
        if (globalFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(68);
        }
        for (VirtualFile virtualFile : globalFolders) {
            ResolvedModuleInfo info;
            if (!virtualFile.isValid() || !virtualFile.isDirectory() || (info = NodeModuleSearchUtil.doResolveModule(null, ModuleType.GLOBAL_FOLDER, virtualFile, requiredModuleName, true, true)) == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleByExactPath(@NotNull VirtualFile baseDir, @NotNull String requiredModuleName) {
        if (baseDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(69);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(70);
        }
        return NodeModuleSearchUtil.doResolveModule(null, ModuleType.EXACT_PATH, baseDir, requiredModuleName, true, true);
    }

    @Nullable
    private static ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        if (type == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(71);
        }
        if (baseDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(72);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(73);
        }
        return NodeModuleDirectorySearchProcessor.PROCESSOR.doResolveModule(moduleSourceRoot, type, baseDir, requiredModuleName, resolveDirectory, respectPackageJson);
    }

    @NotNull
    public static Pair<Boolean, ModuleMainFiles> findMainModuleInPackage(@NotNull VirtualFile dir) {
        VirtualFile candidate;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(74);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(dir)) != null) {
            PackageJsonData data = PackageJsonUtil.getOrCreateData(packageJson);
            VirtualFile mainModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getMain());
            VirtualFile mainJsNextModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getJsNextMain());
            if (mainModule != null || mainJsNextModule != null) {
                Pair pair = Pair.create((Object)true, (Object)new ModuleMainFiles(mainModule, mainJsNextModule));
                if (pair == null) {
                    NodeModuleSearchUtil.$$$reportNull$$$0(75);
                }
                return pair;
            }
        }
        if ((candidate = dir.findChild("index.js")) == null) {
            candidate = dir.findChild("index.node");
        }
        Pair pair = Pair.create((Object)false, (Object)new ModuleMainFiles(candidate, candidate));
        if (pair == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(76);
        }
        return pair;
    }

    @Nullable
    public static VirtualFile findMainModuleByPath(@NotNull VirtualFile dir, @Nullable String main) {
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(77);
        }
        if (main != null) {
            String[] parts = (main = main.startsWith("./") ? main.substring(2) : main).split("/");
            VirtualFile file2 = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
            if (file2 == null && parts.length > 0 && !parts[parts.length - 1].contains(".")) {
                String withoutExtension = parts[parts.length - 1];
                parts[parts.length - 1] = withoutExtension + ".js";
                file2 = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                if (file2 == null) {
                    parts[parts.length - 1] = withoutExtension + ".node";
                    file2 = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                }
            }
            return file2;
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    static boolean isFile(@Nullable VirtualFile file2) {
        return file2 != null && file2.isValid() && !file2.isDirectory();
    }

    @Contract(value="null -> false", pure=true)
    private static boolean isDirectory(@Nullable VirtualFile dir) {
        return dir != null && dir.isValid() && dir.isDirectory();
    }

    @Nullable
    public static VirtualFile findAncestorNodeModulesDir(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(78);
        }
        return JSLibraryUtil.findAncestorLibraryDir(fileOrDir, NODE_MODULES);
    }

    @Nullable
    public static VirtualFile findDependencyRoot(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(79);
        }
        VirtualFile scope = fileOrDir;
        VirtualFile pkg = fileOrDir;
        while (scope != null) {
            VirtualFile parent = scope.getParent();
            if (parent != null && parent.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)parent.getNameSequence())) {
                return NodeModuleSearchUtil.isScopeDir(scope) ? pkg : scope;
            }
            pkg = scope;
            scope = parent;
        }
        return null;
    }

    public static boolean isScopeDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && NodeModuleSearchUtil.isScopeDirName(dir.getNameSequence());
    }

    public static boolean isScopeDirName(@NotNull CharSequence dirName) {
        if (dirName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(80);
        }
        return StringUtil.startsWithChar((CharSequence)dirName, (char)'@');
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isScopedPackageName(@Nullable String packageName) {
        return packageName != null && StringUtil.startsWithChar((CharSequence)packageName, (char)'@') && StringUtil.containsChar((String)packageName, (char)'/');
    }

    @Nullable
    public static String getScopeByPackageName(@NotNull String packageName) {
        int slashInd;
        if (packageName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(81);
        }
        if (StringUtil.startsWithChar((CharSequence)packageName, (char)'@') && (slashInd = packageName.indexOf(47, 1)) > 0) {
            return packageName.substring(0, slashInd);
        }
        return null;
    }

    @Nullable
    public static String getScopeByScopedPackageName(@NotNull String packageName) {
        int slashInd;
        if (packageName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(82);
        }
        if (StringUtil.startsWithChar((CharSequence)packageName, (char)'@') && (slashInd = packageName.indexOf(47, 1)) > 0) {
            return packageName.substring(1, slashInd);
        }
        return null;
    }

    @Nullable
    public static String getNameByScopedPackageName(@NotNull String packageName) {
        int slashInd;
        if (packageName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(83);
        }
        if (NodeModuleSearchUtil.isScopedPackageName(packageName) && (slashInd = packageName.indexOf(47, 1)) > 0) {
            return packageName.substring(slashInd + 1);
        }
        return null;
    }

    public static boolean isFileModuleRequired(@NotNull String requiredModuleName) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(84);
        }
        return requiredModuleName.startsWith("/") || requiredModuleName.startsWith("./") || requiredModuleName.startsWith("../");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 25: 
            case 30: 
            case 46: 
            case 49: 
            case 51: 
            case 57: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 13: 
            case 17: 
            case 34: 
            case 40: 
            case 74: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 18: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 22: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeModuleSearchUtil";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 37: 
            case 38: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: 
            case 45: 
            case 48: 
            case 52: 
            case 55: 
            case 61: 
            case 67: 
            case 70: 
            case 73: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePathFolders";
                break;
            }
            case 50: 
            case 53: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceRoots";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirProcessor";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalFolders";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeModuleSearchUtil";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleNodeModules";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaResourceRoots";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "findMainModuleInPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModulesByNameInContentRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findGloballyInstalledModules";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithNameFromNodeModulesDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findModuleWithNameInDirectory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectVisibleNodeModules";
                break;
            }
            case 22: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: {
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectYarnPnpDependencies";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromResourceRoots";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromNodeModulesDir";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesInDirectories";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesInDirectory";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canLoad";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canLoadFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canLoadDirectory";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "resolveYarnModule";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromNodeModulesDir";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromResourceRoots";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getJavaResourceRoots";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleInResourceRoots";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processUpNodeModulesDirs";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processUpNodeModulesDirsAndPackageJsonFiles";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromGlobalFolders";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleByExactPath";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "doResolveModule";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "findMainModuleInPackage";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findMainModuleByPath";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorNodeModulesDir";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyRoot";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isScopeDirName";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getScopeByPackageName";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getScopeByScopedPackageName";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getNameByScopedPackageName";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isFileModuleRequired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: 
            case 58: 
            case 59: 
            case 60: 
            case 75: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ModuleMainFiles {
        @Nullable
        private final VirtualFile myMain;
        @Nullable
        private final VirtualFile myJsNextMain;

        public ModuleMainFiles(@Nullable VirtualFile jsNextMain, @Nullable VirtualFile main) {
            this.myMain = main;
            this.myJsNextMain = jsNextMain;
        }

        @Nullable
        public VirtualFile getMain() {
            return this.myMain;
        }

        @Nullable
        public VirtualFile getJsNextMain() {
            return this.myJsNextMain;
        }

        @NotNull
        public Collection<VirtualFile> getFiles() {
            List list2 = StreamEx.of((Object[])new VirtualFile[]{this.myJsNextMain, this.myMain}).nonNull().toList();
            if (list2 == null) {
                ModuleMainFiles.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil$ModuleMainFiles", "getFiles"));
        }
    }
}

