/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AvailablePackageVersions {
    public static final String LATEST_DIST_TAG = "latest";
    private static final Logger LOG = Logger.getInstance(AvailablePackageVersions.class);
    private final List<Pair<String, SemVer>> myDistTags;
    private final SortedMap<SemVer, VersionInfo> myVersions;

    @NotNull
    public static AvailablePackageVersions parseFromPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(0);
        }
        return new AvailablePackageVersions(reader);
    }

    private AvailablePackageVersions() {
        this.myDistTags = Collections.emptyList();
        this.myVersions = Collections.emptySortedMap();
    }

    private AvailablePackageVersions(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(1);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            this.myDistTags = Collections.emptyList();
            this.myVersions = Collections.emptySortedMap();
        } else {
            this.myDistTags = new ArrayList<Pair<String, SemVer>>();
            this.myVersions = new TreeMap(Comparator.reverseOrder());
            this.readPackageMetadata(reader);
        }
    }

    @NotNull
    public List<SemVer> getVersions() {
        return new ArrayList<SemVer>(this.myVersions.keySet());
    }

    @NotNull
    public List<Pair<String, SemVer>> getDistTags() {
        List<Pair<String, SemVer>> list2 = Collections.unmodifiableList(this.myDistTags);
        if (list2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public SortedMap<SemVer, VersionInfo> getVersionsInfo() {
        SortedMap<SemVer, VersionInfo> sortedMap = Collections.unmodifiableSortedMap(this.myVersions);
        if (sortedMap == null) {
            AvailablePackageVersions.$$$reportNull$$$0(3);
        }
        return sortedMap;
    }

    @Nullable
    public SemVer findVersionByDistTag(@NotNull String distTagName) {
        if (distTagName == null) {
            AvailablePackageVersions.$$$reportNull$$$0(4);
        }
        for (Pair<String, SemVer> tag : this.myDistTags) {
            if (!distTagName.equals(tag.getFirst())) continue;
            return (SemVer)tag.getSecond();
        }
        return null;
    }

    @Nullable
    public SemVer findVersionByLatestDistTag() {
        return this.findVersionByDistTag(LATEST_DIST_TAG);
    }

    @Nullable
    public String findDistTagByVersion(@NotNull SemVer version) {
        if (version == null) {
            AvailablePackageVersions.$$$reportNull$$$0(5);
        }
        return this.myDistTags.stream().filter(pair -> version.getRawVersion().equals(((SemVer)pair.second).getRawVersion())).map(pair -> (String)pair.first).findFirst().orElse(null);
    }

    private void readPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(6);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("dist-tags".equals(name)) {
                this.readDistTags(reader);
                continue;
            }
            if ("versions".equals(name)) {
                this.readVersions(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private void readDistTags(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(7);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = JsonUtil.nextStringOrSkip((JsonReader)reader);
            SemVer version = SemVer.parseFromText((String)versionStr);
            if (version == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            this.myDistTags.add((Pair<String, SemVer>)Pair.create((Object)distTagName, (Object)version));
        }
        reader.endObject();
    }

    private void readVersions(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(8);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            SemVer version = SemVer.parseFromText((String)name);
            if (version != null) {
                this.readVersionInfo(reader, version);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private void readVersionInfo(@NotNull JsonReader reader, @NotNull SemVer version) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(9);
        }
        if (version == null) {
            AvailablePackageVersions.$$$reportNull$$$0(10);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        boolean isDeprecated = false;
        String url = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("dist") && reader.peek() == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                while (reader.hasNext()) {
                    name = reader.nextName();
                    if (name.equals("tarball") && reader.peek() == JsonToken.STRING) {
                        url = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            if (name.equals("deprecated")) {
                if (reader.peek() == JsonToken.STRING) {
                    reader.skipValue();
                    isDeprecated = true;
                    continue;
                }
                if (reader.peek() == JsonToken.BOOLEAN) {
                    isDeprecated = reader.nextBoolean();
                    continue;
                }
                reader.skipValue();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        this.myVersions.put(version, new VersionInfo(url, isDeprecated));
    }

    @NotNull
    public static AvailablePackageVersions createEmpty() {
        return new AvailablePackageVersions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTagName";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFromPackageMetadata";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVersionByDistTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDistTagByVersion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readPackageMetadata";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readDistTags";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readVersions";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readVersionInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VersionInfo {
        private final boolean myDeprecated;
        private final String myUrl;

        public VersionInfo(@Nullable String url, boolean deprecated) {
            this.myUrl = url;
            this.myDeprecated = deprecated;
        }

        public boolean isDeprecated() {
            return this.myDeprecated;
        }

        @Nullable
        public String getUrl() {
            return this.myUrl;
        }
    }
}

