/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskListingSettingsDialog;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskStructureUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskTreeView;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntConfigurationType;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntService
extends JsbtService {
    private static final Logger LOG = Logger.getInstance(GruntService.class);
    private static final String GRUNTFILE_NAME_WITHOUT_EXT = "Gruntfile";
    private static final String[] KNOWN_EXTENSIONS = new String[]{"coffee", "js"};
    private static final NotNullLazyValue<GruntService> LAZY_INSTANCE = JsbtService.newLazyInstance(GruntService.class);

    @NotNull
    public static GruntService getInstance() {
        GruntService gruntService = (GruntService)LAZY_INSTANCE.getValue();
        if (gruntService == null) {
            GruntService.$$$reportNull$$$0(0);
        }
        return gruntService;
    }

    @Override
    @NotNull
    public String getName() {
        return "Grunt";
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Grunt.Grunt;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager(@NotNull Project project) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(1);
        }
        GruntfileManager gruntfileManager = GruntfileManager.getInstance(project);
        if (gruntfileManager == null) {
            GruntService.$$$reportNull$$$0(2);
        }
        return gruntfileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager(@NotNull Project project) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(3);
        }
        return new JsbtToolWindowManager(project, "Grunt ", JavaScriptLanguageIcons.BuildTools.Grunt.Grunt_toolwindow, "reference.tool.window.grunt", this);
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@NotNull Project project, @Nullable String layoutPlace) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(4);
        }
        return new GruntTaskTreeView(this, project, layoutPlace);
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles(@NotNull Project project) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(5);
        }
        List<VirtualFile> list2 = JsbtUtil.detectAllBuildfiles(project, GRUNTFILE_NAME_WITHOUT_EXT, new String[]{GRUNTFILE_NAME_WITHOUT_EXT}, KNOWN_EXTENSIONS);
        if (list2 == null) {
            GruntService.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(7);
        }
        List<VirtualFile> list2 = JsbtUtil.detectAllBuildfilesInContentRoots(project, webModulesOnly, GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS, false);
        if (list2 == null) {
            GruntService.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    public String getBuildfileCommonName() {
        return GRUNTFILE_NAME_WITHOUT_EXT;
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GruntService.$$$reportNull$$$0(9);
        }
        return JsbtUtil.isFilenameMatched(file2.getNameSequence(), GRUNTFILE_NAME_WITHOUT_EXT, KNOWN_EXTENSIONS);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            GruntService.$$$reportNull$$$0(10);
        }
        return new GruntfileStructure(buildfile);
    }

    @Override
    @NotNull
    public GruntfileStructure fetchBuildfileStructure(@NotNull Project project, @NotNull VirtualFile gruntfile) throws JsbtTaskFetchException {
        GruntfileStructure gruntfileStructure;
        if (project == null) {
            GruntService.$$$reportNull$$$0(11);
        }
        if (gruntfile == null) {
            GruntService.$$$reportNull$$$0(12);
        }
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(project);
        NodeJsInterpreter interpreter = templateRunSettings.getInterpreterRef().resolve(project);
        GruntNonSharedSettings settings = GruntUtil.getGruntPackage(project, interpreter, gruntfile);
        try {
            gruntfileStructure = GruntTaskStructureUtil.fetchStructure(project, interpreter, templateRunSettings.getNodeOptions(), settings.getGruntCliPackage(), gruntfile, templateRunSettings.getEnvData());
        }
        catch (JsbtTaskFetchException e) {
            String description = e.getDescription();
            LOG.info(description);
            throw e;
        }
        if (gruntfileStructure == null) {
            GruntService.$$$reportNull$$$0(13);
        }
        return gruntfileStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        GruntConfigurationType gruntConfigurationType = GruntConfigurationType.getInstance();
        if (gruntConfigurationType == null) {
            GruntService.$$$reportNull$$$0(14);
        }
        return gruntConfigurationType;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            GruntService.$$$reportNull$$$0(15);
        }
        if (patternObject == null) {
            GruntService.$$$reportNull$$$0(16);
        }
        if (runConfiguration instanceof GruntRunConfiguration) {
            GruntRunSettings runSettings = ((GruntRunConfiguration)runConfiguration).getRunSettings();
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                if (JsbtUtil.equalsOrderless(runSettings.getTasks(), patternTaskSet.getTaskNames())) {
                    String systemIndependentPath = patternTaskSet.getStructure().getBuildfile().getPath();
                    return systemIndependentPath.equals(FileUtil.toSystemIndependentName((String)runSettings.getGruntfilePath()));
                }
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            GruntService.$$$reportNull$$$0(17);
        }
        if (taskSet == null) {
            GruntService.$$$reportNull$$$0(18);
        }
        GruntfileStructure structure = (GruntfileStructure)taskSet.getStructure();
        GruntRunConfiguration gruntRunConfiguration = (GruntRunConfiguration)runConfiguration;
        GruntRunSettings merged = new GruntRunSettings.Builder(gruntRunConfiguration.getRunSettings()).setGruntfilePath(structure.getBuildfile().getPath()).setTasks(taskSet.getTaskNames()).build();
        GruntRunConfigurationProducer.setupConfigurationFromSettings(gruntRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(19);
        }
        return new GruntTaskListingSettingsDialog(project, contextGruntfile).showAndGet();
    }

    @Nullable
    public VirtualFile detectFirstBuildfileInContentRoots(@NotNull Project project, boolean webModulesOnly) {
        if (project == null) {
            GruntService.$$$reportNull$$$0(20);
        }
        List<VirtualFile> buildfiles = this.detectAllBuildfilesInContentRoots(project, webModulesOnly);
        return (VirtualFile)ContainerUtil.getFirstItem(buildfiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntService";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntfile";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFileManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowManager";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTaskTreeView";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showTaskListingSettingsDialog";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "detectFirstBuildfileInContentRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

