/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.psi.tree.IElementType;

public class GwtParser
extends JavaScriptParser {
    public GwtParser(PsiBuilder builder) {
        super(JavaScriptSupportLoader.GWT_DIALECT, builder);
        this.myExpressionParser = new ExpressionParser(this){

            @Override
            protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
                return tokenType == JSTokenTypes.DOT || tokenType == JSTokenTypes.COLON_COLON;
            }

            @Override
            protected boolean parseSpecialReference() {
                if (this.builder.getTokenType() == JSTokenTypes.AT) {
                    this.parseGwtReferenceExpression();
                    return true;
                }
                return false;
            }

            private void parseGwtReferenceExpression() {
                PsiBuilder.Marker gwtExpr = this.builder.mark();
                LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.AT);
                this.builder.advanceLexer();
                while (true) {
                    if (this.isIdentifierToken(this.builder.getTokenType())) {
                        this.builder.advanceLexer();
                    } else {
                        this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                    }
                    if (this.builder.getTokenType() != JSTokenTypes.DOT) break;
                    this.builder.advanceLexer();
                }
                if (this.builder.getTokenType() == JSTokenTypes.COLON_COLON) {
                    this.builder.advanceLexer();
                    if (this.builder.getTokenType() == JSTokenTypes.GWT_FIELD_OR_METHOD) {
                        this.builder.advanceLexer();
                    }
                }
                gwtExpr.done(JSElementTypes.GWT_REFERENCE_EXPRESSION);
            }
        };
    }

    @Override
    public boolean isIdentifierToken(IElementType tokenType) {
        return JSKeywordSets.GWT_IDENTIFIER_TOKENS_SET.contains(tokenType);
    }
}

