/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSCodeStyleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class StandardJSCodeStyle
extends PredefinedCodeStyle {
    public StandardJSCodeStyle() {
        super("JavaScript Standard Style", (Language)JavascriptLanguage.INSTANCE);
    }

    public void apply(CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)settings.getCustomSettings(JSCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            return;
        }
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        commonSettings.ALIGN_MULTILINE_PARAMETERS_IN_CALLS = false;
        commonSettings.ALIGN_MULTILINE_PARAMETERS = false;
        commonSettings.ALIGN_MULTILINE_TERNARY_OPERATION = false;
        commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION = false;
        commonSettings.ALIGN_MULTILINE_CHAINED_METHODS = false;
        commonSettings.ALIGN_MULTILINE_FOR = false;
        jsSettings.USE_DOUBLE_QUOTES = false;
        jsSettings.FORCE_QUOTE_STYlE = true;
        commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
        commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
        commonSettings.SPACE_BEFORE_DO_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_ELSE_KEYWORD = true;
        commonSettings.SPACE_BEFORE_CATCH_KEYWORD = true;
        commonSettings.SPACE_BEFORE_FINALLY_KEYWORD = true;
        jsSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH = true;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        jsSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR = true;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE = true;
        jsSettings.USE_SEMICOLON_AFTER_STATEMENT = false;
        jsSettings.FORCE_SEMICOLON_STYLE = true;
        jsSettings.SPACES_WITHIN_IMPORTS = true;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        jsSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        jsSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES = false;
        commonSettings.SPACE_AFTER_QUEST = true;
        commonSettings.SPACE_BEFORE_QUEST = true;
        commonSettings.SPACE_BEFORE_COLON = true;
        commonSettings.SPACE_AFTER_COLON = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        commonSettings.SPACE_BEFORE_SEMICOLON = false;
        jsSettings.SPACE_BEFORE_PROPERTY_COLON = false;
        jsSettings.SPACE_AFTER_PROPERTY_COLON = true;
        jsSettings.SPACE_BEFORE_GENERATOR_MULT = true;
        jsSettings.SPACE_AFTER_GENERATOR_MULT = true;
        jsSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES = true;
    }

    public static void install(@NotNull Project project) {
        if (project == null) {
            StandardJSCodeStyle.$$$reportNull$$$0(0);
        }
        JSCodeStyleUtil.updateProjectCodeStyle(project, (Consumer<? super CodeStyleSettings>)((Consumer)settings -> new StandardJSCodeStyle().apply((CodeStyleSettings)settings)));
    }

    public static boolean isInstalled(@NotNull Project project) {
        if (project == null) {
            StandardJSCodeStyle.$$$reportNull$$$0(1);
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        CommonCodeStyleSettings commonSettings = codeStyleSettings.getCommonSettings((Language)JavascriptLanguage.INSTANCE);
        JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)codeStyleSettings.getCustomSettings(JSCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        if (indentOptions == null) {
            return false;
        }
        return indentOptions.CONTINUATION_INDENT_SIZE == 2 && indentOptions.INDENT_SIZE == 2 && indentOptions.TAB_SIZE == 2 && !jsSettings.USE_DOUBLE_QUOTES && jsSettings.FORCE_QUOTE_STYlE && commonSettings.SPACE_BEFORE_METHOD_PARENTHESES && commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE && commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && commonSettings.KEEP_BLANK_LINES_IN_CODE == 1 && commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && !jsSettings.USE_SEMICOLON_AFTER_STATEMENT && jsSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH && jsSettings.FORCE_SEMICOLON_STYLE && jsSettings.SPACES_WITHIN_IMPORTS && jsSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/lang/javascript/formatter/StandardJSCodeStyle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInstalled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

