/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessToDestructuringElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.evaluable.JSNumericIndexerAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLocalTypeEvaluatorBase {
    @Nullable
    protected JSType evaluate(@Nullable JSExpression expression) {
        if (JSSymbolUtil.isLiteralOrLiteralWithSign(expression)) {
            return JSTypeEvaluator.getTypeFromConstant(expression);
        }
        if (expression instanceof JSArrayLiteralExpression) {
            return this.getArrayLiteralExpressionType((JSArrayLiteralExpression)expression);
        }
        if (expression instanceof JSObjectLiteralExpression) {
            return this.getObjectLiteralExpressionType((JSObjectLiteralExpression)expression);
        }
        if (expression instanceof JSConditionalExpression) {
            return this.getConditionalExpressionType((JSConditionalExpression)expression);
        }
        if (expression instanceof JSParenthesizedExpression) {
            return this.evaluate(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSAssignmentExpression) {
            return this.evaluate(((JSAssignmentExpression)expression).getROperand());
        }
        if (expression instanceof JSIndexedPropertyAccessExpression) {
            return this.getIndexedPropertyAccessExpressionType((JSIndexedPropertyAccessExpression)expression);
        }
        if (expression == null) {
            return new JSUndefinedType(JSLocalTypeEvaluatorBase.createTypeSource(null));
        }
        if (expression instanceof JSNewExpression) {
            return this.getNewExpressionType((JSNewExpression)expression);
        }
        if (expression instanceof JSCallExpression) {
            JSExpression methodExpression = ((JSCallExpression)expression).getMethodExpression();
            return this.getCallLikeExpressionType((JSCallLikeExpression)((JSCallExpression)expression), methodExpression);
        }
        if (expression instanceof ES6TaggedTemplateExpression) {
            JSExpression tag = ((ES6TaggedTemplateExpression)expression).getTag();
            return this.getCallLikeExpressionType((JSCallLikeExpression)expression, tag);
        }
        if (expression instanceof JSReferenceExpression) {
            return this.getReferenceExpressionType((JSReferenceExpression)expression);
        }
        if (expression instanceof JSFunctionExpression) {
            return JSLocalTypeEvaluatorBase.getFunctionExpressionType((JSFunctionExpression)expression);
        }
        if (expression instanceof JSThisExpression) {
            return this.getThisExpressionType(expression);
        }
        if (expression instanceof JSBinaryExpression) {
            return this.getBinaryExpressionType((JSBinaryExpression)expression);
        }
        if (expression instanceof JSClassExpression) {
            return this.getClassExpression((JSClassExpression)expression);
        }
        return null;
    }

    protected JSType getClassExpression(@NotNull JSClassExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(0);
        }
        if (expression instanceof StubBasedPsiElement) {
            return new JSStubBasedExpressionType((StubBasedPsiElement)expression, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression));
        }
        return null;
    }

    @Nullable
    protected JSType getBinaryExpressionType(@NotNull JSBinaryExpression expression) {
        ASTNode node;
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(1);
        }
        if ((node = expression.getOperationNode()) == null) {
            return null;
        }
        IElementType sign = node.getElementType();
        if (JSTokenTypes.BOOLEAN_RESULT_OPERATIONS.contains(sign)) {
            return new JSBooleanType(true, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression), JSTypeContext.INSTANCE);
        }
        if (sign == JSTokenTypes.PLUS) {
            JSExpression lOperand = expression.getLOperand();
            JSType lType = this.evaluate(lOperand);
            if (lType instanceof JSStringType) {
                return JSLocalTypeEvaluatorBase.createPrimitiveStringType(expression);
            }
            JSExpression rOperand = expression.getROperand();
            JSType rType = this.evaluate(rOperand);
            JSType type = JSLocalTypeEvaluatorBase.evaluatePlusForExpandedTypes((PsiElement)expression, lType, rType);
            if (type != null) {
                return type;
            }
        }
        return null;
    }

    @NotNull
    private static JSStringType createPrimitiveStringType(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(2);
        }
        return new JSStringType(true, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression), JSTypeContext.INSTANCE);
    }

    @Nullable
    private static JSType getFunctionExpressionType(@NotNull JSFunctionExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(3);
        }
        if (expression instanceof StubBasedPsiElement) {
            return new JSStubBasedExpressionType((StubBasedPsiElement)expression, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression));
        }
        return null;
    }

    @NotNull
    protected static JSTypeSource createTypeSource(@Nullable PsiElement context) {
        JSTypeSource jSTypeSource = JSTypeSourceFactory.createTypeSource(context, true);
        if (jSTypeSource == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(4);
        }
        return jSTypeSource;
    }

    @Nullable
    protected JSType getThisExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    protected JSType getNewExpressionType(@NotNull JSNewExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    protected JSType getReferenceExpressionType(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(7);
        }
        return null;
    }

    @Nullable
    protected JSType getIndexedPropertyAccessExpressionType(@NotNull JSIndexedPropertyAccessExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    protected JSType getObjectLiteralExpressionType(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(9);
        }
        if (expression instanceof StubBasedPsiElement) {
            return new JSStubBasedExpressionType((StubBasedPsiElement)expression, JSLocalTypeEvaluatorBase.createTypeSource((PsiElement)expression));
        }
        return null;
    }

    @Nullable
    protected JSType getArrayLiteralExpressionType(@NotNull JSArrayLiteralExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nullable
    protected JSType getConditionalExpressionType(@NotNull JSConditionalExpression expression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    protected JSType getCallLikeExpressionType(@NotNull JSCallLikeExpression expression, @Nullable JSExpression methodExpression) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(12);
        }
        return null;
    }

    @Nullable
    public static JSType applyEvaluateContext(@NotNull JSType type, @NotNull JSEvaluationResultContext context) {
        if (type == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(13);
        }
        if (context == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(14);
        }
        for (JSApplyContextElement applyContextElement : context.getJSElementsToApply()) {
            if (applyContextElement instanceof JSApplyPropertyElement) {
                type = new JSQualifiedReferenceType(((JSApplyPropertyElement)applyContextElement).getName(), type, type.getSource());
                continue;
            }
            if (applyContextElement instanceof JSApplyIndexedAccessToDestructuringElement) {
                int index = ((JSApplyIndexedAccessToDestructuringElement)applyContextElement).getIndex();
                if (index == -1) {
                    type = null;
                    break;
                }
                type = new JSNumericIndexerAccessType(index, type, type.getSource());
                continue;
            }
            type = null;
            break;
        }
        return type;
    }

    @Nullable
    public static JSType evaluatePlusForExpandedTypes(@NotNull PsiElement context, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (context == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(15);
        }
        if (lProcType instanceof JSStringType || rProcType instanceof JSStringType) {
            return new JSStringType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        if ((lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
            return new JSIntType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        if ((lProcType instanceof JSNumberType || lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSNumberType || rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
            return new JSNumberType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        if (lProcType instanceof JSBigIntType && rProcType instanceof JSBigIntType) {
            return new JSBigIntType(true, JSLocalTypeEvaluatorBase.createTypeSource(context), JSTypeContext.INSTANCE);
        }
        return null;
    }

    @Nullable
    protected List<JSType> getArrayNestedTypes(@NotNull JSArrayLiteralExpression expression, int limit, boolean widen) {
        if (expression == null) {
            JSLocalTypeEvaluatorBase.$$$reportNull$$$0(16);
        }
        SmartList types2 = new SmartList();
        for (JSExpression element : StreamEx.of((Stream)expression.getExpressionStream())) {
            JSType locallyEvaluatedType;
            if (element instanceof JSSpreadExpression) {
                return null;
            }
            JSType evaluate = this.evaluate(element);
            JSType jSType = locallyEvaluatedType = widen ? JSWidenType.createWidening(evaluate, null) : evaluate;
            if (locallyEvaluatedType == null) {
                return null;
            }
            types2.add(locallyEvaluatedType);
            if (types2.size() <= limit) continue;
            return null;
        }
        return types2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluatorBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSLocalTypeEvaluatorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryExpressionType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPrimitiveStringType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionExpressionType";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getThisExpressionType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewExpressionType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceExpressionType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessExpressionType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getObjectLiteralExpressionType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArrayLiteralExpressionType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConditionalExpressionType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCallLikeExpressionType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyEvaluateContext";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusForExpandedTypes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getArrayNestedTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

