/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringIntentionBase;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementList;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TDoubleArrayList;
import gnu.trove.TDoubleHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSStatementDestructuringIntentionBase
extends JSDestructuringIntentionBase {
    private final boolean myUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.intentions.destructuring.JSStatementDestructuringIntentionBase");

    protected JSStatementDestructuringIntentionBase() {
    }

    protected static void collectExpressions(JSExpression expression, List<PsiElement> allExpressions) {
        if (expression instanceof JSCommaExpression) {
            JSStatementDestructuringIntentionBase.collectExpressions(((JSCommaExpression)expression).getLOperand(), allExpressions);
            allExpressions.add((PsiElement)((JSCommaExpression)expression).getROperand());
        } else {
            allExpressions.add((PsiElement)expression);
        }
    }

    protected static Collection<PsiElement> getChildExpressionsOfNeededType(JSStatement javaScriptStatement) {
        JSExpression expression;
        JSExpressionStatement expStatement = (JSExpressionStatement)ObjectUtils.tryCast((Object)javaScriptStatement, JSExpressionStatement.class);
        JSExpression jSExpression = expression = expStatement == null ? null : expStatement.getExpression();
        if (expression != null) {
            SmartList allExpressions = new SmartList();
            JSStatementDestructuringIntentionBase.collectExpressions(expression, (List<PsiElement>)allExpressions);
            return allExpressions;
        }
        JSVarStatement varDeclStatement = (JSVarStatement)ObjectUtils.tryCast((Object)javaScriptStatement, JSVarStatement.class);
        if (varDeclStatement != null) {
            return Arrays.asList(varDeclStatement.getVariables());
        }
        return null;
    }

    protected static boolean isConst(JSVariable variable) {
        JSVarStatement statement = variable.getStatement();
        return statement != null && statement.getVarKeyword() == JSVarStatement.VarKeyword.CONST;
    }

    protected static boolean isLet(JSVariable variable) {
        JSVarStatement statement = variable.getStatement();
        return statement != null && statement.getVarKeyword() == JSVarStatement.VarKeyword.LET;
    }

    protected static PsiElement getStatementsOwner(PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatementList.class, JSEmbeddedContent.class});
    }

    protected static List<JSStatement> getStatements(PsiElement element) {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, JSStatement.class);
    }

    protected JSExpression getInitializer(PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression();
            return definitionExpression != null ? definitionExpression.getInitializer() : null;
        }
        if (element instanceof JSInitializerOwner) {
            return ((JSInitializerOwner)element).getInitializer();
        }
        return null;
    }

    protected void doInvoke(JSExpression reference, Project project, Editor editor) {
        Data data = this.checkIndexerListForDestructuring(editor, project, reference);
        if (data == null) {
            return;
        }
        JSStatementDestructuringIntentionBase.runInWriteAction(() -> this.performWriteActivity(data));
    }

    protected boolean validateData(Data data) {
        return true;
    }

    protected static void runInWriteAction(Runnable runnable) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                runnable.run();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private void performWriteActivity(Data data) {
        TDoubleArrayList indices = new TDoubleArrayList();
        ArrayList<String> leftHandSides = new ArrayList<String>();
        ArrayList<Triple<String, String, String>> propertyData = new ArrayList<Triple<String, String, String>>();
        this.initialize(data, indices, leftHandSides, propertyData);
        JSExpression expression = data.myExpression;
        if (expression == null) {
            return;
        }
        String qualifier = propertyData.isEmpty() ? JSStatementDestructuringIntentionBase.getQualifier(expression) : (String)((Triple)Objects.requireNonNull(ContainerUtil.getLastItem(propertyData))).component3();
        StringBuilder destructuringString = new StringBuilder();
        this.appendDestructuringInitializer(indices, leftHandSides, propertyData, destructuringString);
        if (data.myCommonDeclarationPrefix != null) {
            destructuringString.insert(0, data.myCommonDeclarationPrefix + " ");
        }
        JSStatementDestructuringIntentionBase.doTransformItems(data, destructuringString, qualifier);
    }

    private static String getQualifier(JSExpression expression) {
        return expression instanceof JSPrefixExpression ? expression.getText() : Objects.requireNonNull(((JSQualifiedExpression)expression).getQualifier()).getText();
    }

    protected abstract void appendDestructuringInitializer(TDoubleArrayList var1, List<String> var2, List<Triple<String, String, String>> var3, StringBuilder var4);

    protected static void doTransformItems(Data data, StringBuilder destructuringString, String qualifier) {
        List elementPointers = ContainerUtil.map(data.myAllItems, e -> SmartPointerManager.createPointer((PsiElement)e));
        String string = destructuringString.toString();
        String lbrace = string.startsWith("{") ? "(" : "";
        String rbrace = string.startsWith("{") ? ")" : "";
        JSStatement newStatement = JSPsiElementFactory.createJSStatement(lbrace + string + " = " + qualifier + rbrace + JSCodeStyleSettings.getSemicolon(data.myContext), data.myContext);
        JSStatement parentStatement = (JSStatement)Objects.requireNonNull(PsiTreeUtil.getParentOfType((PsiElement)data.myContext, JSStatement.class, (boolean)false));
        JSStatement addedStatement = parentStatement.addStatementBefore(newStatement);
        String parentPrefix = parentStatement instanceof JSVarStatement ? Objects.requireNonNull(((JSVarStatement)parentStatement).getVarKeyword()).getText() : null;
        ArrayList<String> varVarsToDeclare = new ArrayList<String>();
        ArrayList<String> letVarsToDeclare = new ArrayList<String>();
        ArrayList<String> constVarsToDeclare = new ArrayList<String>();
        boolean first = true;
        for (SmartPsiElementPointer javaScriptExpression : elementPointers) {
            JSAssignmentExpression assignment;
            JSVariable varDecl = (JSVariable)ObjectUtils.tryCast((Object)javaScriptExpression.getElement(), JSVariable.class);
            if (varDecl != null) {
                NewLineEraser eraser;
                if (data.myCommonDeclarationPrefix == null) {
                    if (JSStatementDestructuringIntentionBase.isConst(varDecl)) {
                        constVarsToDeclare.add(varDecl.getName());
                    } else if (JSStatementDestructuringIntentionBase.isLet(varDecl)) {
                        letVarsToDeclare.add(varDecl.getName());
                    } else {
                        varVarsToDeclare.add(varDecl.getName());
                    }
                }
                if (first && data.myCommonDeclarationPrefix != null && Objects.equals(data.myCommonDeclarationPrefix, parentPrefix)) {
                    first = false;
                    varDecl.replace((PsiElement)((JSVarStatement)addedStatement).getDeclarations()[0]);
                    eraser = new NewLineEraser((PsiElement)addedStatement);
                    addedStatement.delete();
                    eraser.process();
                } else {
                    eraser = null;
                    JSVarStatement statement = varDecl.getStatement();
                    if (statement != null && statement.getVariables().length == 1) {
                        eraser = new NewLineEraser((PsiElement)statement);
                    }
                    varDecl.delete();
                    if (eraser != null) {
                        eraser.process();
                    }
                }
            }
            if ((assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)javaScriptExpression.getElement(), JSAssignmentExpression.class)) == null) continue;
            JSStatementDestructuringIntentionBase.removeAssignment(assignment);
        }
        if (varVarsToDeclare.size() != 0) {
            JSStatementDestructuringIntentionBase.appendDeclarationStatement(addedStatement, varVarsToDeclare, "var");
        }
        if (letVarsToDeclare.size() != 0) {
            JSStatementDestructuringIntentionBase.appendDeclarationStatement(addedStatement, letVarsToDeclare, "let");
        }
        if (constVarsToDeclare.size() != 0) {
            JSStatementDestructuringIntentionBase.appendDeclarationStatement(addedStatement, constVarsToDeclare, "let");
        }
    }

    private static void removeAssignment(JSAssignmentExpression assignment) {
        JSCommaExpression commaExpression;
        PsiElement parent = assignment.getParent();
        JSExpressionStatement statement = (JSExpressionStatement)ObjectUtils.tryCast((Object)parent, JSExpressionStatement.class);
        if (statement != null) {
            NewLineEraser eraser = new NewLineEraser((PsiElement)statement);
            statement.delete();
            eraser.process();
        }
        if ((commaExpression = (JSCommaExpression)ObjectUtils.tryCast((Object)parent, JSCommaExpression.class)) != null) {
            if (commaExpression.getLOperand() == assignment) {
                commaExpression.replace(commaExpression.getROperand());
            } else {
                commaExpression.replace(commaExpression.getLOperand());
            }
        }
    }

    protected static void appendDeclarationStatement(JSStatement addedStatement, List<String> varVarsToDeclare, String keyword) {
        StringBuilder newStatementString = new StringBuilder(keyword);
        newStatementString.append(" ");
        for (int i = 0; i < varVarsToDeclare.size(); ++i) {
            newStatementString.append(varVarsToDeclare.get(i));
            if (i == varVarsToDeclare.size() - 1) continue;
            newStatementString.append(", ");
        }
        newStatementString.append(JSCodeStyleSettings.getSemicolon((PsiElement)addedStatement));
        JSStatement nStatement = JSPsiElementFactory.createJSStatement(newStatementString.toString(), (PsiElement)addedStatement);
        addedStatement.addStatementBefore(nStatement);
    }

    @Nullable
    protected Data checkIndexerListForDestructuring(@Nullable Editor editor, Project project, JSExpression expression) {
        PsiElement owner = JSStatementDestructuringIntentionBase.getStatementsOwner((PsiElement)expression);
        if (owner == null || !DialectDetector.hasFeature((PsiElement)expression, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT)) {
            return null;
        }
        JSExpression qualifier = this.getInitialQualifier(expression);
        if (qualifier == null && !(expression instanceof JSPrefixExpression)) {
            return null;
        }
        String indexedExpressionString = qualifier != null ? qualifier.getText() : null;
        ArrayList<PsiElement> allIndexersInScope = new ArrayList<PsiElement>();
        List<JSStatement> statements = JSStatementDestructuringIntentionBase.getStatements(owner);
        for (JSStatement javaScriptStatement : statements) {
            Collection<PsiElement> allExpressionsForStatement = JSStatementDestructuringIntentionBase.getChildExpressionsOfNeededType(javaScriptStatement);
            if (allExpressionsForStatement == null) {
                if (allIndexersInScope.size() <= 0) continue;
                return this.checkIndexerAndEmitHint(allIndexersInScope, project, editor);
            }
            for (PsiElement exp : allExpressionsForStatement) {
                JSExpression e = this.checkValidExpressionInValue(this.getInitializer(exp));
                if (e == null || !(e instanceof JSPrefixExpression) && indexedExpressionString != null && !indexedExpressionString.equals(e.getText())) {
                    if (allIndexersInScope.size() <= 0) continue;
                    if (exp == null || exp.getTextOffset() < expression.getTextOffset()) {
                        allIndexersInScope.clear();
                        continue;
                    }
                    return this.checkIndexerAndEmitHint(allIndexersInScope, project, editor);
                }
                allIndexersInScope.add(exp);
                if (indexedExpressionString != null) continue;
                indexedExpressionString = e.getText();
            }
        }
        return this.checkIndexerAndEmitHint(allIndexersInScope, project, editor);
    }

    protected JSExpression getInitialQualifier(JSExpression expression) {
        return expression instanceof JSQualifiedExpression ? ((JSQualifiedExpression)expression).getQualifier() : null;
    }

    @Nullable
    protected abstract JSExpression checkValidExpressionInValue(@Nullable JSExpression var1);

    @Nullable
    private Data checkIndexerAndEmitHint(List<PsiElement> allIndexersInScope, Project project, @Nullable Editor editor) {
        if (allIndexersInScope.size() == 0) {
            return null;
        }
        boolean hasAssignments = false;
        boolean hasVarDeclarations = false;
        boolean hasLetDeclarations = false;
        boolean hasConstDeclarations = false;
        TDoubleArrayList indices = new TDoubleArrayList();
        ArrayList<PsiElement> allExpressions = new ArrayList<PsiElement>();
        ArrayList<JSVariable> constVariables = new ArrayList<JSVariable>();
        int i = -1;
        for (PsiElement assignment : allIndexersInScope) {
            ++i;
            JSExpression initializer = this.getInitializer(assignment);
            if (initializer instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)initializer;
                double number = JSStatementDestructuringIntentionBase.toDouble((JSLiteralExpression)Objects.requireNonNull(indexer.getIndexExpression()));
                indices.add(number);
            } else if (initializer instanceof JSPrefixExpression) {
                indices.add((double)i);
            }
            allExpressions.add(assignment);
            JSVariable variableDeclaration = (JSVariable)ObjectUtils.tryCast((Object)assignment, JSVariable.class);
            if (variableDeclaration != null) {
                if (JSStatementDestructuringIntentionBase.isConst(variableDeclaration)) {
                    constVariables.add(variableDeclaration);
                    hasConstDeclarations = true;
                    continue;
                }
                if (JSStatementDestructuringIntentionBase.isLet(variableDeclaration)) {
                    hasLetDeclarations = true;
                    continue;
                }
                hasVarDeclarations = true;
                continue;
            }
            hasAssignments = true;
        }
        if (new TDoubleHashSet(indices.toNativeArray()).size() != indices.size()) {
            allIndexersInScope.clear();
            return null;
        }
        String commonVariablePrefix = null;
        if (!hasAssignments) {
            if (hasVarDeclarations && !hasLetDeclarations && !hasConstDeclarations) {
                commonVariablePrefix = "var";
            } else if (!hasVarDeclarations && hasLetDeclarations && !hasConstDeclarations) {
                commonVariablePrefix = "let";
            } else if (!hasVarDeclarations) {
                boolean accepted;
                if (hasLetDeclarations && editor != null && !this.myUnitTestMode && !(accepted = JSStatementDestructuringIntentionBase.showConstToLetDialog(project, editor, constVariables))) {
                    allIndexersInScope.clear();
                    return null;
                }
                commonVariablePrefix = hasLetDeclarations ? "let" : "const";
            }
        }
        Data result2 = new Data(editor == null ? null : this.createInitializer(allIndexersInScope), allIndexersInScope.get(0), allExpressions, commonVariablePrefix);
        allIndexersInScope.clear();
        return result2;
    }

    @Nullable
    protected JSExpression createInitializer(List<PsiElement> allIndexersInScope) {
        return this.getInitializer(allIndexersInScope.get(0));
    }

    private static boolean showConstToLetDialog(Project project, Editor editor, List<JSVariable> constVariables) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(constVariables);
        EditorColorsManager manager2 = EditorColorsManager.getInstance();
        TextAttributes attributes = manager2.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        ArrayList highlighters = new ArrayList();
        highlightManager.addOccurrenceHighlights(editor, elements, attributes, true, highlighters);
        int result2 = Messages.showYesNoDialog((Project)project, (String)JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.const.to.var.warning", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"refactoring.destructuring.vars.intention.const.to.var.warning.title", (Object[])new Object[0]), (String)"Continue", (String)"Abort", null);
        highlighters.forEach(h -> highlightManager.removeSegmentHighlighter(editor, h));
        return result2 == 0;
    }

    protected static Triple<String, String, String> extractPropertyNameAndDefaultValue(JSConditionalExpression ternaryExpression) {
        JSBinaryExpression condition = (JSBinaryExpression)ternaryExpression.getCondition();
        assert (condition != null);
        IElementType sign = condition.getOperationSign();
        boolean isNegativeCondition = sign == JSTokenTypes.NEQEQ || sign == JSTokenTypes.NE;
        JSExpression defaultValueBranch = isNegativeCondition ? ternaryExpression.getElse() : ternaryExpression.getThen();
        JSReferenceExpression assignedValueBranch = (JSReferenceExpression)(isNegativeCondition ? ternaryExpression.getThen() : ternaryExpression.getElse());
        assert (assignedValueBranch != null);
        assert (defaultValueBranch != null);
        String qualifier = Objects.requireNonNull(assignedValueBranch.getQualifier()).getText();
        return new Triple((Object)assignedValueBranch.getReferenceName(), (Object)defaultValueBranch.getText(), (Object)qualifier);
    }

    protected void initialize(Data data, TDoubleArrayList indices, List<String> leftHandSides, List<Triple<String, String, String>> propertyData) {
        if (data.myAllItems == null) {
            return;
        }
        int i = -1;
        for (PsiElement owner : data.myAllItems) {
            ++i;
            JSExpression initializer = this.getInitializer(owner);
            if (initializer instanceof JSIndexedPropertyAccessExpression) {
                JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)initializer;
                JSLiteralExpression expression = (JSLiteralExpression)indexer.getIndexExpression();
                assert (expression != null);
                indices.add(JSStatementDestructuringIntentionBase.toDouble(expression));
            } else if (initializer instanceof JSPrefixExpression) {
                indices.add((double)i);
            } else if (initializer instanceof JSConditionalExpression) {
                propertyData.add(JSStatementDestructuringIntentionBase.extractPropertyNameAndDefaultValue((JSConditionalExpression)initializer));
            } else if (initializer instanceof JSReferenceExpression) {
                propertyData.add((Triple<String, String, String>)new Triple((Object)((JSReferenceExpression)initializer).getReferenceName(), null, (Object)Objects.requireNonNull(((JSReferenceExpression)initializer).getQualifier()).getText()));
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)owner, JSAssignmentExpression.class);
            if (assignment != null) {
                JSExpression operand = assignment.getLOperand();
                assert (operand != null);
                leftHandSides.add(operand.getText());
                continue;
            }
            JSVariable declaration = (JSVariable)owner;
            leftHandSides.add(declaration.getName());
        }
    }

    public boolean startInWriteAction() {
        return this.myUnitTestMode;
    }

    protected boolean checkAvailable(JSExpression literal, Project project) {
        if (literal == null) {
            return false;
        }
        Data data = this.checkIndexerListForDestructuring(null, project, literal);
        return data != null && this.validateData(data);
    }

    @Nullable
    protected static <T extends JSExpression> T findExpression(@NotNull PsiElement element, @NotNull Function<PsiElement, T> finder) {
        JSExpression indexer1;
        if (element == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(0);
        }
        if (finder == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(1);
        }
        if ((indexer1 = (JSExpression)finder.apply(element)) != null) {
            return (T)indexer1;
        }
        if (element instanceof JSExpression) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)parent).getVariables();
            if (variables.length == 1) {
                return (T)((JSExpression)JSStatementDestructuringIntentionBase.findExpressionInInitializer(variables[0], finder));
            }
            JSExpression index = null;
            for (JSVariable variable : variables) {
                JSExpression i = (JSExpression)JSStatementDestructuringIntentionBase.findExpressionInInitializer(variable, finder);
                if (i == null) {
                    return null;
                }
                index = i;
            }
            return (T)index;
        }
        if (parent instanceof JSVariable) {
            return (T)((JSExpression)JSStatementDestructuringIntentionBase.findExpressionInInitializer((JSVariable)parent, finder));
        }
        return null;
    }

    @Nullable
    private static <T> T findExpressionInInitializer(@NotNull JSVariable variable, @NotNull Function<PsiElement, T> finder) {
        JSExpression initializer;
        if (variable == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(2);
        }
        if (finder == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(3);
        }
        return (initializer = variable.getInitializer()) != null ? (T)finder.apply((PsiElement)initializer) : null;
    }

    protected static boolean isTopLevel(@NotNull JSExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(4);
        }
        return (parent = expression.getParent()) instanceof JSVariable || parent instanceof JSAssignmentExpression;
    }

    protected static JSReferenceExpression findReference(@NotNull PsiElement element) {
        JSReferenceExpression referenceExpression;
        if (element == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(5);
        }
        if ((referenceExpression = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSReferenceExpression.class, (boolean)false)) == null) {
            return null;
        }
        PsiElement parent = referenceExpression.getParent();
        JSReferenceExpression parentRef = (JSReferenceExpression)ObjectUtils.tryCast((Object)parent, JSReferenceExpression.class);
        if (parentRef != null) {
            return parentRef.getReferenceName() == null || !JSStatementDestructuringIntentionBase.isTopOrInTopConditional(parentRef) ? null : parentRef;
        }
        if (referenceExpression.getReferenceKind() != JSReferenceExpression.Kind.PropertyAccess) {
            return null;
        }
        return referenceExpression.getReferenceName() == null || !JSStatementDestructuringIntentionBase.isTopOrInTopConditional(referenceExpression) ? null : referenceExpression;
    }

    private static boolean isTopOrInTopConditional(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(6);
        }
        if (JSStatementDestructuringIntentionBase.isTopLevel((JSExpression)referenceExpression)) {
            return true;
        }
        JSConditionalExpression expression = (JSConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSConditionalExpression.class);
        return expression != null && JSStatementDestructuringIntentionBase.isTopLevel((JSExpression)expression);
    }

    @Nullable
    protected static JSIndexedPropertyAccessExpression findIndexer(@NotNull PsiElement element) {
        JSIndexedPropertyAccessExpression indexer;
        if (element == null) {
            JSStatementDestructuringIntentionBase.$$$reportNull$$$0(7);
        }
        return (indexer = (JSIndexedPropertyAccessExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSIndexedPropertyAccessExpression.class, (boolean)false)) != null && JSStatementDestructuringIntentionBase.isValidIndexer(indexer) && JSStatementDestructuringIntentionBase.isTopLevel((JSExpression)indexer) ? indexer : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSStatementDestructuringIntentionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findExpressionInInitializer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopOrInTopConditional";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findIndexer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class Data {
        JSExpression myExpression;
        PsiElement myContext;
        List<PsiElement> myAllItems;
        String myCommonDeclarationPrefix;

        protected Data(JSExpression expression, PsiElement context, List<PsiElement> allItems, String commonDeclarationPrefix) {
            this.myExpression = expression;
            this.myContext = context;
            this.myAllItems = allItems;
            this.myCommonDeclarationPrefix = commonDeclarationPrefix;
        }
    }
}

