/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileTexts;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EslintPanel {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final boolean myFullModeDialog;
    private final NodePackageField myEslintPackageField;
    private final JSLinterConfigFileView myConfigFileView;
    private final TextFieldWithBrowseButton myAdditionalRulesDirField;
    private final RawCommandLineEditor myExtraOptions;
    private final JPanel myPanel;
    private final JPanel myConfigurationPanel;
    private final JLabel myPackageErrorLabel;

    public EslintPanel(@NotNull Project project, boolean fullModeDialog, boolean addLeftIndent) {
        if (project == null) {
            EslintPanel.$$$reportNull$$$0(0);
        }
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myFullModeDialog = fullModeDialog;
        List<String> packageNames = Arrays.asList("eslint", "standard");
        this.myConfigFileView = new JSLinterConfigFileView(project, new JSLinterConfigFileTexts(JavaScriptBundle.message((String)"javascript.linter.configurable.config.autoSearch.title", (Object[])new Object[0]), JavaScriptBundle.message((String)"eslint.configurable.config.autoSearch.description.bodyInnerHtml", (Object[])new Object[0]), JavaScriptBundle.message((String)"eslint.configurable.config.select.config.text", (Object[])new Object[0])), null);
        this.myEslintPackageField = AutodetectLinterPackage.createNodePackageField(packageNames, this.myNodeInterpreterField, this.myConfigFileView);
        this.myConfigFileView.setAdditionalConfigFilesProducer((NotNullProducer<List<VirtualFile>>)((NotNullProducer)() -> EslintUtil.findAllConfigsInScope(project)));
        this.myAdditionalRulesDirField = EslintPanel.createAdditionalRulesDirField(project);
        this.myExtraOptions = new RawCommandLineEditor();
        this.myConfigurationPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.myConfigFileView.getComponent()).addSeparator(4).addVerticalGap(4).addComponent(EslintPanel.createBottomComponent(this.myAdditionalRulesDirField, this.myExtraOptions)).addSeparator(8).getPanel();
        this.myPackageErrorLabel = new JLabel("");
        this.myPackageErrorLabel.setFont(UIUtil.getTitledBorderFont());
        FormBuilder mainBuilder = FormBuilder.createFormBuilder();
        mainBuilder.setHorizontalGap(10).setVerticalGap(4);
        if (addLeftIndent) {
            mainBuilder.setFormLeftIndent(10);
        }
        JPanel panel2 = mainBuilder.addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JavaScriptBundle.message((String)"eslint.configurable.eslintPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myEslintPackageField)).addComponentToRightColumn((JComponent)this.myPackageErrorLabel).addComponentToRightColumn(EslintPanel.createStandardJSLabel()).addComponent((JComponent)this.myConfigurationPanel).getPanel();
        this.myEslintPackageField.addPackageRefSelectionListener((Consumer<NodePackageRef>)((Consumer)this::adjustUiForPackage));
        this.myPanel = SwingHelper.wrapWithHorizontalStretch((JComponent)panel2);
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @NotNull
    private static JComponent createStandardJSLabel() {
        JLabel label = new JLabel();
        label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        Color foreground = UIUtil.getLabelDisabledForeground();
        label.setForeground(foreground);
        label.setText(JavaScriptBundle.message((String)"standardjs.eslint.label", (Object[])new Object[0]));
        JLabel jLabel = label;
        if (jLabel == null) {
            EslintPanel.$$$reportNull$$$0(1);
        }
        return jLabel;
    }

    @NotNull
    private static JComponent createBottomComponent(@NotNull TextFieldWithBrowseButton field, @NotNull RawCommandLineEditor extraOptions) {
        if (field == null) {
            EslintPanel.$$$reportNull$$$0(2);
        }
        if (extraOptions == null) {
            EslintPanel.$$$reportNull$$$0(3);
        }
        JPanel jPanel = FormBuilder.createFormBuilder().setHorizontalGap(10).addLabeledComponent(JavaScriptBundle.message((String)"eslint.configurable.additionalRulesDir.label", (Object[])new Object[0]), (JComponent)field).addLabeledComponent(JavaScriptBundle.message((String)"eslint.configurable.extraOptions.label", (Object[])new Object[0]), (JComponent)extraOptions).getPanel();
        if (jPanel == null) {
            EslintPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithBrowseButton createAdditionalRulesDirField(@NotNull Project project) {
        if (project == null) {
            EslintPanel.$$$reportNull$$$0(5);
        }
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)field, (String)JavaScriptBundle.message((String)"eslint.configurable.additionalRulesDir.browseDialogTitle", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton = field;
        if (textFieldWithBrowseButton == null) {
            EslintPanel.$$$reportNull$$$0(6);
        }
        return textFieldWithBrowseButton;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            EslintPanel.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public void handleEnableStatusChanged(boolean enabled) {
        NodePackageRef selectedRef = this.myEslintPackageField.getSelectedRef();
        this.adjustUiForPackage(selectedRef);
        if (selectedRef == AutodetectLinterPackage.INSTANCE) {
            this.myConfigFileView.setEnabled(false);
        }
        this.myConfigFileView.onEnabledStateChanged(enabled);
    }

    public void setState(@NotNull EslintState state) {
        if (state == null) {
            EslintPanel.$$$reportNull$$$0(8);
        }
        this.setEslintState(state);
        this.adjustUiForPackage(state.getNodePackageRef());
    }

    EslintState.Builder buildEslintState() {
        NodePackageRef selected = this.myEslintPackageField.getSelectedRef();
        EslintState.Builder builder = new EslintState.Builder();
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setEslintPackage(selected);
        builder.setCustomConfigFilePath(this.myConfigFileView.getCustomConfigFilePath());
        builder.setCustomConfigFileUsed(this.myConfigFileView.isCustomConfigFileUsed());
        builder.setAdditionalRulesDirPath(this.myAdditionalRulesDirField.getText());
        builder.setExtraOptions(this.myExtraOptions.getText());
        return builder;
    }

    private void setEslintState(@NotNull EslintState state) {
        if (state == null) {
            EslintPanel.$$$reportNull$$$0(9);
        }
        this.myConfigurationPanel.setEnabled(true);
        this.myNodeInterpreterField.setInterpreterRef(state.getInterpreterRef());
        this.myEslintPackageField.setSelectedRef(state.getNodePackageRef());
        this.myConfigFileView.setCustomConfigFileUsed(state.isCustomConfigFileUsed());
        this.myConfigFileView.setCustomConfigFilePath(state.getCustomConfigFilePath());
        this.myAdditionalRulesDirField.setText(state.getAdditionalRulesDirPath());
        this.myExtraOptions.setText(state.getExtraOptions());
        if (this.myFullModeDialog) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            this.myConfigFileView.setPreferredWidthToComponents();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myAdditionalRulesDirField);
        }
    }

    private void adjustUiForPackage(NodePackageRef nodePackage) {
        this.myPackageErrorLabel.setText(JSLinterUtil.getRedErrorTextHtml(EslintPanel.formatErrorMessage(nodePackage)));
        this.myConfigurationPanel.setVisible(!EslintPanel.isStandardJs(nodePackage));
    }

    @NotNull
    private static String formatErrorMessage(@NotNull NodePackageRef packageRef) {
        NodePackage pkg;
        if (packageRef == null) {
            EslintPanel.$$$reportNull$$$0(10);
        }
        if ((pkg = packageRef.getConstantPackage()) == null) {
            return "";
        }
        if (pkg.getSystemDependentPath().trim().isEmpty()) {
            String string = JavaScriptBundle.message((String)"javascript.linter.error.empty.path", (Object[])new Object[0]);
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (!pkg.isValid()) {
            String string = JavaScriptBundle.message((String)"eslint.error.package.directory.expected", (Object[])new Object[0]);
            if (string == null) {
                EslintPanel.$$$reportNull$$$0(12);
            }
            return string;
        }
        return "";
    }

    public static boolean isStandardJs(@NotNull NodePackageRef nodePackage) {
        NodePackage constantPackage;
        if (nodePackage == null) {
            EslintPanel.$$$reportNull$$$0(13);
        }
        String packageName = (constantPackage = nodePackage.getConstantPackage()) != null ? constantPackage.getName() : null;
        return "standard".equals(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraOptions";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createStandardJSLabel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBottomComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalRulesDirField";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBottomComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalRulesDirField";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setEslintState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isStandardJs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

